/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class ShortConverter
implements AtlasPrimitiveConverter<Short> {
    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean convertToBoolean(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte convertToByte(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value >= -128 && value <= 127) {
            return value.byteValue();
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException(String.format("Short %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE", value)));
    }

    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Character convertToCharacter(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value < 0 || value > 65535) {
            throw new AtlasConversionException(String.format("Short %s is greater than Character.MAX_VALUE  or less than Character.MIN_VALUE", value));
        }
        return Character.valueOf((char)value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.FLOAT)
    public Float convertToFloat(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.INTEGER)
    public Integer convertToInteger(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.LONG)
    public Long convertToLong(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.SHORT)
    public Short convertToShort(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return new Short(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.SHORT, targetType=FieldType.STRING)
    public String convertToString(Short value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

