/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AtlasPath {
    public static final String PATH_SEPARATOR = "/";
    public static final String PATH_SEPARATOR_ESCAPED = "/";
    public static final String PATH_ARRAY_START = "[";
    public static final String PATH_ARRAY_END = "]";
    public static final String PATH_LIST_START = "<";
    public static final String PATH_LIST_END = ">";
    public static final String PATH_MAP_START = "{";
    public static final String PATH_MAP_END = "}";
    private List<String> segments = new ArrayList<String>();
    private String originalPath = null;

    public AtlasPath(String p) {
        String path;
        this.originalPath = path = p;
        if (path != null && !"".equals(path)) {
            if (path.startsWith("/")) {
                path = path.replaceFirst("/", "");
            }
            if (path.contains("/")) {
                String[] parts;
                for (String part : parts = path.split("/", 512)) {
                    this.getSegments().add(part);
                }
            } else {
                this.getSegments().add(path);
            }
        }
    }

    private AtlasPath() {
    }

    public List<SegmentContext> getSegmentContexts(boolean includeLeadingSlashSegment) {
        LinkedList<SegmentContext> contexts = new LinkedList<SegmentContext>();
        String segmentPath = "";
        SegmentContext previousContext = null;
        int index = 0;
        List<String> newSegments = this.getSegments();
        if (includeLeadingSlashSegment) {
            newSegments.add(0, "");
        }
        for (String s : newSegments) {
            SegmentContext c = new SegmentContext();
            segmentPath = segmentPath + "/" + s;
            c.setPathUtil(this);
            c.setSegment(s);
            c.setSegmentIndex(index);
            c.setSegmentPath(segmentPath);
            if (previousContext != null) {
                c.setPrev(previousContext);
                previousContext.setNext(c);
            }
            contexts.add(c);
            previousContext = c;
            if (index == 0 && includeLeadingSlashSegment) {
                segmentPath = "";
            }
            ++index;
        }
        return contexts;
    }

    public AtlasPath appendField(String fieldName) {
        this.segments.add(fieldName);
        return this;
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public String getLastSegment() {
        if (this.segments.isEmpty()) {
            return null;
        }
        return this.segments.get(this.segments.size() - 1);
    }

    public boolean hasParent() {
        return this.segments.size() > 1;
    }

    public static String removeCollectionIndexes(String path) {
        AtlasPath pathUtil = new AtlasPath(path);
        String cleanedPath = "";
        for (String s : pathUtil.getSegments()) {
            cleanedPath = cleanedPath + "/" + AtlasPath.removeCollectionIndex(s);
        }
        return cleanedPath;
    }

    public static String removeCollectionIndex(String segment) {
        if (segment == null) {
            return null;
        }
        if (segment.contains(PATH_ARRAY_START) && segment.contains(PATH_ARRAY_END)) {
            return segment.substring(0, segment.indexOf(PATH_ARRAY_START) + 1) + segment.substring(segment.indexOf(PATH_ARRAY_END));
        }
        if (segment.contains(PATH_LIST_START) && segment.contains(PATH_LIST_END)) {
            return segment.substring(0, segment.indexOf(PATH_LIST_START) + 1) + segment.substring(segment.indexOf(PATH_LIST_END));
        }
        if (segment.contains(PATH_MAP_START) && segment.contains(PATH_MAP_END)) {
            return segment.substring(0, segment.indexOf(PATH_MAP_START) + 1) + segment.substring(segment.indexOf(PATH_MAP_END));
        }
        return segment;
    }

    public boolean hasCollection() {
        for (String seg : this.getSegments()) {
            if (!AtlasPath.isCollectionSegment(seg).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean isIndexedCollection() {
        for (String seg : this.getSegments()) {
            if (!AtlasPath.isCollectionSegment(seg).booleanValue() || AtlasPath.indexOfSegment(seg) == null) continue;
            return true;
        }
        return false;
    }

    public Boolean isCollectionRoot() {
        return AtlasPath.isCollectionSegment(this.getLastSegment());
    }

    public String getLastSegmentParent() {
        if (this.segments.isEmpty() || this.segments.size() == 1) {
            return null;
        }
        return this.segments.get(this.segments.size() - 2);
    }

    public AtlasPath getLastSegmentParentPath() {
        if (this.segments.isEmpty() || this.segments.size() == 1) {
            return null;
        }
        AtlasPath parentPath = new AtlasPath();
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            parentPath.appendField(this.segments.get(i));
        }
        return parentPath;
    }

    public AtlasPath deCollectionify(String collectionSegment) {
        if (this.segments.isEmpty() || this.segments.size() == 1) {
            return null;
        }
        AtlasPath j = new AtlasPath();
        boolean collectionFound = false;
        for (String part : this.segments) {
            String cleanedPart;
            if (collectionFound) {
                j.appendField(part);
            }
            if ((cleanedPart = AtlasPath.cleanPathSegment(part)) == null || !cleanedPart.equals(AtlasPath.cleanPathSegment(collectionSegment))) continue;
            collectionFound = true;
        }
        return j;
    }

    public AtlasPath deParentify() {
        if (this.segments.isEmpty() || this.segments.size() == 1) {
            return null;
        }
        AtlasPath j = new AtlasPath();
        for (int i = 1; i < this.segments.size(); ++i) {
            j.appendField(this.segments.get(i));
        }
        return j;
    }

    public static String cleanPathSegment(String pathSeg) {
        String pathSegment = pathSeg;
        if (pathSegment == null) {
            return null;
        }
        if (pathSegment.contains(":")) {
            pathSegment = pathSegment.substring(pathSegment.indexOf(":") + 1);
        }
        if (pathSegment.startsWith("@")) {
            pathSegment = pathSegment.substring(1);
        }
        if (pathSegment.contains(PATH_ARRAY_START) && pathSegment.endsWith(PATH_ARRAY_END)) {
            return pathSegment.substring(0, pathSegment.indexOf(PATH_ARRAY_START, 0));
        }
        if (pathSegment.contains(PATH_LIST_START) && pathSegment.endsWith(PATH_LIST_END)) {
            return pathSegment.substring(0, pathSegment.indexOf(PATH_LIST_START, 0));
        }
        if (pathSegment.contains(PATH_MAP_START) && pathSegment.endsWith(PATH_MAP_END)) {
            return pathSegment.substring(0, pathSegment.indexOf(PATH_MAP_START, 0));
        }
        return pathSegment;
    }

    public static String getAttribute(String pathSeg) {
        return pathSeg.substring(1);
    }

    public static Boolean isCollectionSegment(String pathSegment) {
        if (pathSegment == null) {
            return false;
        }
        if (pathSegment.contains(PATH_ARRAY_START) && pathSegment.endsWith(PATH_ARRAY_END)) {
            return true;
        }
        if (pathSegment.contains(PATH_LIST_START) && pathSegment.endsWith(PATH_LIST_END)) {
            return true;
        }
        return pathSegment.contains(PATH_MAP_START) && pathSegment.endsWith(PATH_MAP_END);
    }

    public static Boolean isAttributeSegment(String pathSegment) {
        return pathSegment != null && pathSegment.startsWith("@");
    }

    public static Integer indexOfSegment(String pathSegment) {
        if (pathSegment == null) {
            return null;
        }
        if (pathSegment.contains(PATH_ARRAY_START) && pathSegment.endsWith(PATH_ARRAY_END)) {
            int start = pathSegment.indexOf(PATH_ARRAY_START, 0) + 1;
            String index = pathSegment.substring(start, pathSegment.indexOf(PATH_ARRAY_END, start));
            if (index != null && index.length() > 0) {
                return Integer.valueOf(index);
            }
            return null;
        }
        if (pathSegment.contains(PATH_LIST_START) && pathSegment.endsWith(PATH_LIST_END)) {
            int start = pathSegment.indexOf(PATH_LIST_START, 0) + 1;
            String index = pathSegment.substring(start, pathSegment.indexOf(PATH_LIST_END, start));
            if (index != null && index.length() > 0) {
                return Integer.valueOf(index);
            }
            return null;
        }
        return null;
    }

    public Integer getCollectionIndex(String segment) {
        for (String part : this.getSegments()) {
            String cleanedPart = AtlasPath.cleanPathSegment(part);
            if (cleanedPart == null || !cleanedPart.equals(AtlasPath.cleanPathSegment(segment)) || (!part.contains(PATH_ARRAY_START) || !part.contains(PATH_ARRAY_END)) && (!part.contains(PATH_LIST_START) || !part.contains(PATH_LIST_END))) continue;
            return AtlasPath.indexOfSegment(part);
        }
        return null;
    }

    public String getCollectionSegment() {
        for (String part : this.getSegments()) {
            if (!AtlasPath.isCollectionSegment(part).booleanValue()) continue;
            return part;
        }
        return null;
    }

    public void setCollectionIndex(String segment, Integer index) {
        if (segment == null) {
            throw new IllegalArgumentException("PathUtil segment cannot be null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("PathUtil index must be a positive integer");
        }
        if (segment.contains(PATH_ARRAY_START) && segment.contains(PATH_ARRAY_END)) {
            for (int i = 0; i < this.getSegments().size(); ++i) {
                String part = AtlasPath.cleanPathSegment(this.getSegments().get(i));
                if (part == null || !part.equals(AtlasPath.cleanPathSegment(segment))) continue;
                this.getSegments().set(i, AtlasPath.cleanPathSegment(segment) + PATH_ARRAY_START + index + PATH_ARRAY_END);
            }
        } else if (segment.contains(PATH_LIST_START) && segment.contains(PATH_LIST_END)) {
            for (int i = 0; i < this.getSegments().size(); ++i) {
                String part = AtlasPath.cleanPathSegment(this.getSegments().get(i));
                if (part == null || !part.equals(AtlasPath.cleanPathSegment(segment))) continue;
                this.getSegments().set(i, AtlasPath.cleanPathSegment(segment) + PATH_LIST_START + index + PATH_LIST_END);
            }
        } else {
            throw new IllegalArgumentException("PathUtil segment is not a List or Array segment");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        if (this.getSegments().size() > 1) {
            builder.append("/");
        }
        for (String part : this.getSegments()) {
            builder.append(part);
            if (i < this.getSegments().size() - 1) {
                builder.append("/");
            }
            ++i;
        }
        return builder.toString();
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public static boolean isArraySegment(String segment) {
        return AtlasPath.isCollectionSegment(segment) != false && segment.contains(PATH_ARRAY_START);
    }

    public static boolean isListSegment(String segment) {
        return AtlasPath.isCollectionSegment(segment) != false && segment.contains(PATH_LIST_START);
    }

    public static boolean isMapSegment(String segment) {
        return AtlasPath.isCollectionSegment(segment) != false && segment.contains(PATH_MAP_START);
    }

    public static boolean isCollection(String path) {
        return new AtlasPath(path).hasCollection();
    }

    public static String overwriteCollectionIndex(String path, int index) {
        String newPath = "";
        for (SegmentContext sg : new AtlasPath(path).getSegmentContexts(false)) {
            String segment = sg.getSegment();
            if (AtlasPath.isCollection(segment)) {
                if (segment.contains(PATH_ARRAY_START) && segment.contains(PATH_ARRAY_END)) {
                    segment = AtlasPath.cleanPathSegment(segment) + PATH_ARRAY_START + index + PATH_ARRAY_END;
                } else if (segment.contains(PATH_LIST_START) && segment.contains(PATH_LIST_END)) {
                    segment = AtlasPath.cleanPathSegment(segment) + PATH_LIST_START + index + PATH_LIST_END;
                }
            }
            newPath = newPath + "/" + segment;
        }
        return newPath;
    }

    public static class SegmentContext {
        protected String segment;
        protected String segmentPath;
        protected int segmentIndex;
        protected SegmentContext prev;
        protected SegmentContext next;
        protected AtlasPath pathUtil;

        public String getSegment() {
            return this.segment;
        }

        public void setSegment(String segment) {
            this.segment = segment;
        }

        public String getSegmentPath() {
            return this.segmentPath;
        }

        public void setSegmentPath(String segmentPath) {
            this.segmentPath = segmentPath;
        }

        public int getSegmentIndex() {
            return this.segmentIndex;
        }

        public void setSegmentIndex(int segmentIndex) {
            this.segmentIndex = segmentIndex;
        }

        public SegmentContext getPrev() {
            return this.prev;
        }

        public void setPrev(SegmentContext prev) {
            this.prev = prev;
        }

        public SegmentContext getNext() {
            return this.next;
        }

        public void setNext(SegmentContext next) {
            this.next = next;
        }

        public void setPathUtil(AtlasPath pathUtil) {
            this.pathUtil = pathUtil;
        }

        public AtlasPath getPathUtil() {
            return this.pathUtil;
        }

        public boolean hasParent() {
            return this.prev != null;
        }

        public boolean hasChild() {
            return this.next != null;
        }

        public String toString() {
            return "SegmentContext [segment=" + this.segment + ", segmentPath=" + this.segmentPath + ", segmentIndex=" + this.segmentIndex + AtlasPath.PATH_ARRAY_END;
        }
    }
}

