/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasFieldActionService;
import io.atlasmap.mxbean.AtlasModuleMXBean;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.SimpleField;
import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.TabularData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAtlasModule
implements AtlasModule,
AtlasModuleMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAtlasModule.class);
    private boolean automaticallyProcessOutputFieldActions = true;
    private AtlasConversionService atlasConversionService = null;
    private AtlasFieldActionService atlasFieldActionService = null;
    private AtlasModuleMode atlasModuleMode = AtlasModuleMode.UNSET;
    private String docId;
    private String uri;

    public void init() {
    }

    public void destroy() {
    }

    public void processPostValidation(AtlasInternalSession session) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostValidation completed", (Object)this.getDocId());
        }
    }

    protected void processLookupField(AtlasInternalSession session, LookupTable lookupTable, Object sourceValue, Field targetField) throws AtlasException {
        String lookupValue = null;
        FieldType lookupType = null;
        for (LookupEntry lkp : lookupTable.getLookupEntry()) {
            if (!lkp.getSourceValue().equals(sourceValue)) continue;
            lookupValue = lkp.getTargetValue();
            lookupType = lkp.getTargetType();
            break;
        }
        Object targetValue = null;
        targetValue = lookupType == null || FieldType.STRING.equals(lookupType) ? lookupValue : this.atlasConversionService.convertType((Object)lookupValue, FieldType.STRING, lookupType);
        if (targetField.getFieldType() != null && !targetField.getFieldType().equals(lookupType)) {
            targetValue = this.atlasConversionService.convertType(targetValue, lookupType, targetField.getFieldType());
        }
        targetField.setValue(targetValue);
    }

    protected boolean isDocIdMatched(Field field) {
        String fieldDocId = field.getDocId();
        if (this.atlasModuleMode == AtlasModuleMode.SOURCE && "ATLAS_DEFAULT_SOURCE_DOC".equals(this.docId) || this.atlasModuleMode == AtlasModuleMode.TARGET && "ATLAS_DEFAULT_TARGET_DOC".equals(this.docId)) {
            return fieldDocId == null || fieldDocId.isEmpty() || fieldDocId.equals(this.docId);
        }
        return fieldDocId != null && !fieldDocId.isEmpty() && fieldDocId.equals(this.docId);
    }

    public AtlasModuleMode getMode() {
        return this.atlasModuleMode;
    }

    public void setMode(AtlasModuleMode atlasModuleMode) {
        this.atlasModuleMode = atlasModuleMode;
    }

    public Boolean isStatisticsSupported() {
        return false;
    }

    public Boolean isStatisticsEnabled() {
        return false;
    }

    public List<AtlasModuleMode> listSupportedModes() {
        return Arrays.asList(AtlasModuleMode.SOURCE, AtlasModuleMode.TARGET);
    }

    public AtlasConversionService getConversionService() {
        return this.atlasConversionService;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setConversionService(AtlasConversionService atlasConversionService) {
        this.atlasConversionService = atlasConversionService;
    }

    public AtlasFieldActionService getFieldActionService() {
        return this.atlasFieldActionService;
    }

    public void setFieldActionService(AtlasFieldActionService atlasFieldActionService) {
        this.atlasFieldActionService = atlasFieldActionService;
    }

    public boolean isAutomaticallyProcessOutputFieldActions() {
        return this.automaticallyProcessOutputFieldActions;
    }

    public void setAutomaticallyProcessOutputFieldActions(boolean automaticallyProcessOutputFieldActions) {
        this.automaticallyProcessOutputFieldActions = automaticallyProcessOutputFieldActions;
    }

    public boolean isSourceSupported() {
        return Arrays.asList(this.getClass().getAnnotation(AtlasModuleDetail.class).modes()).contains("SOURCE");
    }

    public boolean isTargetSupported() {
        return Arrays.asList(this.getClass().getAnnotation(AtlasModuleDetail.class).modes()).contains("TARGET");
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String[] getDataFormats() {
        return this.getClass().getAnnotation(AtlasModuleDetail.class).dataFormats();
    }

    public String getModeName() {
        return this.atlasModuleMode.name();
    }

    public String getName() {
        return this.getClass().getAnnotation(AtlasModuleDetail.class).name();
    }

    public String[] getPackageNames() {
        return null;
    }

    public long getSourceErrorCount() {
        return 0L;
    }

    public long getSourceCount() {
        return 0L;
    }

    public long getSourceMaxExecutionTime() {
        return 0L;
    }

    public long getSourceMinExecutionTime() {
        return 0L;
    }

    public long getSourceSuccessCount() {
        return 0L;
    }

    public long getSourceTotalExecutionTime() {
        return 0L;
    }

    public long getTargetCount() {
        return 0L;
    }

    public long getTargetErrorCount() {
        return 0L;
    }

    public long getTargetMaxExecutionTime() {
        return 0L;
    }

    public long getTargetMinExecutionTime() {
        return 0L;
    }

    public long getTargetSuccessCount() {
        return 0L;
    }

    public long getTargetTotalExecutionTime() {
        return 0L;
    }

    public String getUuid() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public TabularData readAndResetStatistics() {
        return null;
    }

    public void setStatisticsEnabled(boolean enabled) {
        LOG.warn("Statistics is not yet implemented");
    }

    public Boolean isSupportedField(Field field) {
        return field instanceof SimpleField;
    }
}

