/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.AreaUnitType;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConvertAreaUnit;
import io.atlasmap.v2.ConvertDistanceUnit;
import io.atlasmap.v2.ConvertMassUnit;
import io.atlasmap.v2.ConvertVolumeUnit;
import io.atlasmap.v2.DistanceUnitType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.MassUnitType;
import io.atlasmap.v2.VolumeUnitType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class NumberFieldActions
implements AtlasFieldAction {
    private static final double KILO_GRAMS_IN_A_POUND = 0.45359237;
    private static final double YARDS_IN_A_MILE = 1760.0;
    private static final double FEET_IN_A_YARD = 3.0;
    private static final double INCHES_IN_A_FOOT = 12.0;
    private static final double METERS_IN_A_INCH = 0.0254;
    private static final double SQUARE_FEET_IN_A_SQUARE_METER = Math.pow(3.2808398950131235, 2.0);
    private static final double SQUARE_METERS_IN_A_SQUARE_MILE = Math.pow(1609.3439999999998, 2.0);
    private static final double SQUARE_FEET_IN_A_SQUARE_MILE = Math.pow(5280.0, 2.0);
    private static final double LITTERS_IN_A_CUBIC_METER = 1000.0;
    private static final double CUBIC_FEET_IN_A_CUBIC_METER = Math.pow(3.2808398950131235, 3.0);
    private static final double GALLONS_US_FLUID_IN_A_CUBIC_METER = 264.17205236;
    private static final String COLLECTION_MUST_CONTAIN_NUMBERS_ERR_MSG = "The source collection/arry/map must only contain numbers";
    private static Map<MassUnitType, Map<MassUnitType, Double>> massConvertionTable;
    private static Map<DistanceUnitType, Map<DistanceUnitType, Double>> distanceConvertionTable;
    private static Map<AreaUnitType, Map<AreaUnitType, Double>> areaConvertionTable;
    private static Map<VolumeUnitType, Map<VolumeUnitType, Double>> volumeConvertionTable;

    @AtlasFieldActionInfo(name="AbsoluteValue", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number absoluteValue(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (input instanceof BigDecimal) {
            return ((BigDecimal)input).abs();
        }
        if (NumberFieldActions.requiresDoubleResult(input)) {
            return Math.abs(input.doubleValue());
        }
        return Math.abs(input.longValue());
    }

    @AtlasFieldActionInfo(name="Add", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Number add(Action action, Object input) {
        if (input == null) {
            return 0;
        }
        Collection<?> inputs = NumberFieldActions.collection(input);
        Number sum = 0L;
        for (Object entry : inputs) {
            if (entry instanceof Number) {
                if (sum instanceof BigDecimal) {
                    sum = ((BigDecimal)sum).add(BigDecimal.valueOf(((Number)entry).doubleValue()));
                    continue;
                }
                if (entry instanceof BigDecimal) {
                    sum = BigDecimal.valueOf(sum.doubleValue()).add((BigDecimal)entry);
                    continue;
                }
                if (NumberFieldActions.requiresDoubleResult(sum) || NumberFieldActions.requiresDoubleResult(entry)) {
                    sum = sum.doubleValue() + ((Number)entry).doubleValue();
                    continue;
                }
                sum = sum.longValue() + ((Number)entry).longValue();
                continue;
            }
            throw new IllegalArgumentException(COLLECTION_MUST_CONTAIN_NUMBERS_ERR_MSG);
        }
        return sum;
    }

    @AtlasFieldActionInfo(name="Average", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Number average(Action action, Object input) {
        if (input == null) {
            return 0;
        }
        Collection<?> inputs = NumberFieldActions.collection(input);
        return NumberFieldActions.add(null, input).doubleValue() / (double)inputs.size();
    }

    @AtlasFieldActionInfo(name="Ceiling", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number ceiling(Action action, Number input) {
        return input == null ? 0L : (long)Math.ceil(input.doubleValue());
    }

    @AtlasFieldActionInfo(name="ConvertMassUnit", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number convertMassUnit(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof ConvertMassUnit) || ((ConvertMassUnit)action).getFromUnit() == null || ((ConvertMassUnit)action).getToUnit() == null) {
            throw new IllegalArgumentException("ConvertMassUnit must be specfied  with fromUnit and toUnit");
        }
        MassUnitType fromUnit = ((ConvertMassUnit)action).getFromUnit();
        MassUnitType toUnit = ((ConvertMassUnit)action).getToUnit();
        double rate = massConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasFieldActionInfo(name="ConvertDistanceUnit", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number convertDistanceUnit(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof ConvertDistanceUnit) || ((ConvertDistanceUnit)action).getFromUnit() == null || ((ConvertDistanceUnit)action).getToUnit() == null) {
            throw new IllegalArgumentException("ConvertDistanceUnit must be specfied  with fromUnit and toUnit");
        }
        DistanceUnitType fromUnit = ((ConvertDistanceUnit)action).getFromUnit();
        DistanceUnitType toUnit = ((ConvertDistanceUnit)action).getToUnit();
        double rate = distanceConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasFieldActionInfo(name="ConvertAreaUnit", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number convertAreaUnit(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof ConvertAreaUnit) || ((ConvertAreaUnit)action).getFromUnit() == null || ((ConvertAreaUnit)action).getToUnit() == null) {
            throw new IllegalArgumentException("ConvertAreaUnit must be specfied  with fromUnit and toUnit");
        }
        AreaUnitType fromUnit = ((ConvertAreaUnit)action).getFromUnit();
        AreaUnitType toUnit = ((ConvertAreaUnit)action).getToUnit();
        double rate = areaConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasFieldActionInfo(name="ConvertVolumeUnit", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number convertVolumeUnit(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof ConvertVolumeUnit) || ((ConvertVolumeUnit)action).getFromUnit() == null || ((ConvertVolumeUnit)action).getToUnit() == null) {
            throw new IllegalArgumentException("ConvertVolumeUnit must be specfied  with fromUnit and toUnit");
        }
        VolumeUnitType fromUnit = ((ConvertVolumeUnit)action).getFromUnit();
        VolumeUnitType toUnit = ((ConvertVolumeUnit)action).getToUnit();
        double rate = volumeConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasFieldActionInfo(name="Divide", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Number divide(Action action, Object input) {
        if (input == null) {
            return 0;
        }
        Collection<?> inputs = NumberFieldActions.collection(input);
        Number quotient = null;
        for (Object entry : inputs) {
            if (entry instanceof Number) {
                if (quotient == null) {
                    quotient = (Number)entry;
                    continue;
                }
                if (quotient instanceof BigDecimal) {
                    quotient = ((BigDecimal)quotient).divide(BigDecimal.valueOf(((Number)entry).doubleValue()));
                    continue;
                }
                if (entry instanceof BigDecimal) {
                    quotient = BigDecimal.valueOf(quotient.doubleValue()).divide((BigDecimal)entry);
                    continue;
                }
                quotient = quotient.doubleValue() / ((Number)entry).doubleValue();
                continue;
            }
            throw new IllegalArgumentException(COLLECTION_MUST_CONTAIN_NUMBERS_ERR_MSG);
        }
        return quotient;
    }

    @AtlasFieldActionInfo(name="Floor", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number floor(Action action, Number input) {
        return input == null ? 0L : (long)Math.floor(input.doubleValue());
    }

    @AtlasFieldActionInfo(name="Maximum", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Number maximum(Action action, Object input) {
        if (input == null) {
            return 0;
        }
        Collection<?> inputs = NumberFieldActions.collection(input);
        Number max = null;
        for (Object entry : inputs) {
            if (entry instanceof Number) {
                if (max instanceof BigDecimal && entry instanceof BigDecimal) {
                    max = ((BigDecimal)entry).max((BigDecimal)max);
                    continue;
                }
                if (max != null && !(((Number)entry).doubleValue() > max.doubleValue())) continue;
                max = (Number)entry;
                continue;
            }
            throw new IllegalArgumentException(COLLECTION_MUST_CONTAIN_NUMBERS_ERR_MSG);
        }
        return max;
    }

    @AtlasFieldActionInfo(name="Minimum", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Number minimum(Action action, Object input) {
        if (input == null) {
            return 0;
        }
        Collection<?> inputs = NumberFieldActions.collection(input);
        Number min = null;
        for (Object entry : inputs) {
            if (entry instanceof Number) {
                if (min instanceof BigDecimal && entry instanceof BigDecimal) {
                    min = ((BigDecimal)entry).min((BigDecimal)min);
                    continue;
                }
                if (min != null && !(((Number)entry).doubleValue() < min.doubleValue())) continue;
                min = (Number)entry;
                continue;
            }
            throw new IllegalArgumentException(COLLECTION_MUST_CONTAIN_NUMBERS_ERR_MSG);
        }
        return min;
    }

    @AtlasFieldActionInfo(name="Multiply", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Number multiply(Action action, Object input) {
        if (input == null) {
            return 0;
        }
        Collection<?> inputs = NumberFieldActions.collection(input);
        Number product = 1L;
        for (Object entry : inputs) {
            if (entry instanceof Number) {
                if (product instanceof BigDecimal) {
                    product = ((BigDecimal)product).multiply(BigDecimal.valueOf(((Number)entry).doubleValue()));
                    continue;
                }
                if (entry instanceof BigDecimal) {
                    product = BigDecimal.valueOf(product.doubleValue()).multiply((BigDecimal)entry);
                    continue;
                }
                if (NumberFieldActions.requiresDoubleResult(product) || NumberFieldActions.requiresDoubleResult(entry)) {
                    product = product.doubleValue() * ((Number)entry).doubleValue();
                    continue;
                }
                product = product.longValue() * ((Number)entry).longValue();
                continue;
            }
            throw new IllegalArgumentException(COLLECTION_MUST_CONTAIN_NUMBERS_ERR_MSG);
        }
        return product;
    }

    @AtlasFieldActionInfo(name="Round", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number round(Action action, Number input) {
        return input == null ? 0L : Math.round(input.doubleValue());
    }

    @AtlasFieldActionInfo(name="Subtract", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Number subtract(Action action, Object input) {
        if (input == null) {
            return 0;
        }
        Collection<?> inputs = NumberFieldActions.collection(input);
        Number difference = null;
        for (Object entry : inputs) {
            if (entry instanceof Number) {
                if (difference == null) {
                    difference = (Number)entry;
                    continue;
                }
                if (difference instanceof BigDecimal) {
                    difference = ((BigDecimal)difference).subtract(BigDecimal.valueOf(((Number)entry).doubleValue()));
                    continue;
                }
                if (entry instanceof BigDecimal) {
                    difference = BigDecimal.valueOf(difference.doubleValue()).subtract((BigDecimal)entry);
                    continue;
                }
                if (NumberFieldActions.requiresDoubleResult(difference) || NumberFieldActions.requiresDoubleResult(entry)) {
                    difference = difference.doubleValue() - ((Number)entry).doubleValue();
                    continue;
                }
                difference = difference.longValue() - ((Number)entry).longValue();
                continue;
            }
            throw new IllegalArgumentException(COLLECTION_MUST_CONTAIN_NUMBERS_ERR_MSG);
        }
        return difference;
    }

    private static Collection<?> collection(Object input) {
        if (input instanceof Collection) {
            return (Collection)input;
        }
        if (input instanceof Map) {
            return ((Map)input).values();
        }
        if (input instanceof Number[]) {
            return Arrays.asList((Object[])input);
        }
        if (input instanceof double[]) {
            double[] din = (double[])input;
            ArrayList<Double> dinList = new ArrayList<Double>(din.length);
            for (double e : din) {
                dinList.add(e);
            }
            return dinList;
        }
        if (input instanceof float[]) {
            float[] fin = (float[])input;
            ArrayList<Float> finList = new ArrayList<Float>(fin.length);
            for (float e : fin) {
                finList.add(Float.valueOf(e));
            }
            return finList;
        }
        if (input instanceof long[]) {
            long[] lin = (long[])input;
            ArrayList<Long> linList = new ArrayList<Long>(lin.length);
            for (long e : lin) {
                linList.add(e);
            }
            return linList;
        }
        if (input instanceof int[]) {
            int[] iin = (int[])input;
            ArrayList<Integer> iinList = new ArrayList<Integer>(iin.length);
            for (int e : iin) {
                iinList.add(e);
            }
            return iinList;
        }
        if (input instanceof byte[]) {
            byte[] bin = (byte[])input;
            ArrayList<Byte> binList = new ArrayList<Byte>(bin.length);
            for (byte e : bin) {
                binList.add(e);
            }
            return binList;
        }
        throw new IllegalArgumentException("Illegal input[" + input + "]. Input must be a Collection, Map or array of numbers");
    }

    private static Number doMultiply(Number input, double rate) {
        if (input instanceof BigDecimal) {
            return ((BigDecimal)input).multiply(BigDecimal.valueOf(rate));
        }
        return input.doubleValue() * rate;
    }

    private static boolean requiresDoubleResult(Object object) {
        return object instanceof Double || object instanceof Float;
    }

    static {
        EnumMap rootTable = new EnumMap(MassUnitType.class);
        EnumMap<MassUnitType, Double> kgRates = new EnumMap<MassUnitType, Double>(MassUnitType.class);
        kgRates.put(MassUnitType.KILO_GRAM, 1.0);
        kgRates.put(MassUnitType.POUND, 2.2046226218487757);
        rootTable.put(MassUnitType.KILO_GRAM, Collections.unmodifiableMap(kgRates));
        EnumMap<MassUnitType, Double> lbsRates = new EnumMap<MassUnitType, Double>(MassUnitType.class);
        lbsRates.put(MassUnitType.KILO_GRAM, 0.45359237);
        lbsRates.put(MassUnitType.POUND, 1.0);
        rootTable.put(MassUnitType.POUND, Collections.unmodifiableMap(lbsRates));
        massConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new EnumMap(DistanceUnitType.class);
        EnumMap<DistanceUnitType, Double> mRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        mRates.put(DistanceUnitType.METER, 1.0);
        mRates.put(DistanceUnitType.FOOT, 3.2808398950131235);
        mRates.put(DistanceUnitType.YARD, 1.0936132983377078);
        mRates.put(DistanceUnitType.MILE, 6.21371192237334E-4);
        mRates.put(DistanceUnitType.INCH, 39.37007874015748);
        rootTable.put((MassUnitType)DistanceUnitType.METER, Collections.unmodifiableMap(mRates));
        EnumMap<DistanceUnitType, Double> ftRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        ftRates.put(DistanceUnitType.METER, 0.30479999999999996);
        ftRates.put(DistanceUnitType.FOOT, 1.0);
        ftRates.put(DistanceUnitType.YARD, 0.3333333333333333);
        ftRates.put(DistanceUnitType.MILE, 1.893939393939394E-4);
        ftRates.put(DistanceUnitType.INCH, 12.0);
        rootTable.put((MassUnitType)DistanceUnitType.FOOT, Collections.unmodifiableMap(ftRates));
        EnumMap<DistanceUnitType, Double> ydRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        ydRates.put(DistanceUnitType.METER, 0.9144);
        ydRates.put(DistanceUnitType.FOOT, 3.0);
        ydRates.put(DistanceUnitType.YARD, 1.0);
        ydRates.put(DistanceUnitType.MILE, 5.681818181818182E-4);
        ydRates.put(DistanceUnitType.INCH, 36.0);
        rootTable.put((MassUnitType)DistanceUnitType.YARD, Collections.unmodifiableMap(ydRates));
        EnumMap<DistanceUnitType, Double> miRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        miRates.put(DistanceUnitType.METER, 1609.3439999999998);
        miRates.put(DistanceUnitType.FOOT, 5280.0);
        miRates.put(DistanceUnitType.YARD, 1760.0);
        miRates.put(DistanceUnitType.MILE, 1.0);
        miRates.put(DistanceUnitType.INCH, 63360.0);
        rootTable.put((MassUnitType)DistanceUnitType.MILE, Collections.unmodifiableMap(miRates));
        EnumMap<DistanceUnitType, Double> inRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        inRates.put(DistanceUnitType.METER, 0.0254);
        inRates.put(DistanceUnitType.FOOT, 0.08333333333333333);
        inRates.put(DistanceUnitType.YARD, 0.027777777777777776);
        inRates.put(DistanceUnitType.MILE, 1.5782828282828283E-5);
        inRates.put(DistanceUnitType.INCH, 1.0);
        rootTable.put((MassUnitType)DistanceUnitType.INCH, Collections.unmodifiableMap(inRates));
        distanceConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new EnumMap(AreaUnitType.class);
        EnumMap<AreaUnitType, Double> m2Rates = new EnumMap<AreaUnitType, Double>(AreaUnitType.class);
        m2Rates.put(AreaUnitType.SQUARE_METER, 1.0);
        m2Rates.put(AreaUnitType.SQUARE_FOOT, SQUARE_FEET_IN_A_SQUARE_METER);
        m2Rates.put(AreaUnitType.SQUARE_MILE, 1.0 / SQUARE_METERS_IN_A_SQUARE_MILE);
        rootTable.put((MassUnitType)AreaUnitType.SQUARE_METER, Collections.unmodifiableMap(m2Rates));
        EnumMap<AreaUnitType, Double> ft2Rates = new EnumMap<AreaUnitType, Double>(AreaUnitType.class);
        ft2Rates.put(AreaUnitType.SQUARE_METER, 1.0 / SQUARE_FEET_IN_A_SQUARE_METER);
        ft2Rates.put(AreaUnitType.SQUARE_FOOT, 1.0);
        ft2Rates.put(AreaUnitType.SQUARE_MILE, 1.0 / SQUARE_FEET_IN_A_SQUARE_MILE);
        rootTable.put((MassUnitType)AreaUnitType.SQUARE_FOOT, Collections.unmodifiableMap(ft2Rates));
        EnumMap<AreaUnitType, Double> mi2Rates = new EnumMap<AreaUnitType, Double>(AreaUnitType.class);
        mi2Rates.put(AreaUnitType.SQUARE_METER, SQUARE_METERS_IN_A_SQUARE_MILE);
        mi2Rates.put(AreaUnitType.SQUARE_FOOT, SQUARE_FEET_IN_A_SQUARE_MILE);
        mi2Rates.put(AreaUnitType.SQUARE_MILE, 1.0);
        rootTable.put((MassUnitType)AreaUnitType.SQUARE_MILE, Collections.unmodifiableMap(mi2Rates));
        areaConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new EnumMap(VolumeUnitType.class);
        EnumMap<VolumeUnitType, Double> m3Rates = new EnumMap<VolumeUnitType, Double>(VolumeUnitType.class);
        m3Rates.put(VolumeUnitType.CUBIC_METER, 1.0);
        m3Rates.put(VolumeUnitType.LITTER, 1000.0);
        m3Rates.put(VolumeUnitType.CUBIC_FOOT, CUBIC_FEET_IN_A_CUBIC_METER);
        m3Rates.put(VolumeUnitType.GALLON_US_FLUID, 264.17205236);
        rootTable.put((MassUnitType)VolumeUnitType.CUBIC_METER, Collections.unmodifiableMap(m3Rates));
        EnumMap<VolumeUnitType, Double> litterRates = new EnumMap<VolumeUnitType, Double>(VolumeUnitType.class);
        litterRates.put(VolumeUnitType.CUBIC_METER, 0.001);
        litterRates.put(VolumeUnitType.LITTER, 1.0);
        litterRates.put(VolumeUnitType.CUBIC_FOOT, 0.001 * CUBIC_FEET_IN_A_CUBIC_METER);
        litterRates.put(VolumeUnitType.GALLON_US_FLUID, 0.26417205236);
        rootTable.put((MassUnitType)VolumeUnitType.LITTER, Collections.unmodifiableMap(litterRates));
        EnumMap<VolumeUnitType, Double> cftRates = new EnumMap<VolumeUnitType, Double>(VolumeUnitType.class);
        cftRates.put(VolumeUnitType.CUBIC_METER, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER);
        cftRates.put(VolumeUnitType.LITTER, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER * 1000.0);
        cftRates.put(VolumeUnitType.CUBIC_FOOT, 1.0);
        cftRates.put(VolumeUnitType.GALLON_US_FLUID, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER * 264.17205236);
        rootTable.put((MassUnitType)VolumeUnitType.CUBIC_FOOT, Collections.unmodifiableMap(cftRates));
        EnumMap<VolumeUnitType, Double> galUsFluidRates = new EnumMap<VolumeUnitType, Double>(VolumeUnitType.class);
        galUsFluidRates.put(VolumeUnitType.CUBIC_METER, 0.003785411783973468);
        galUsFluidRates.put(VolumeUnitType.LITTER, 3.785411783973468);
        galUsFluidRates.put(VolumeUnitType.CUBIC_FOOT, 0.003785411783973468 * CUBIC_FEET_IN_A_CUBIC_METER);
        galUsFluidRates.put(VolumeUnitType.GALLON_US_FLUID, 1.0);
        rootTable.put((MassUnitType)VolumeUnitType.GALLON_US_FLUID, Collections.unmodifiableMap(galUsFluidRates));
        volumeConvertionTable = Collections.unmodifiableMap(rootTable);
    }
}

