/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class BooleanConverter
implements AtlasPrimitiveConverter<Boolean> {
    private static final String STRING_VALUES = "true|false";

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.BOOLEAN)
    public Boolean convertToBoolean(Boolean value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return new Boolean(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.BYTE)
    public Byte convertToByte(Boolean value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (byte)(value != false ? 1 : 0);
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.CHAR)
    public Character convertToCharacter(Boolean value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Character.valueOf((char)(value != false ? 1 : 0));
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Boolean value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value != false ? 1.0 : 0.0;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.FLOAT)
    public Float convertToFloat(Boolean value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value != false ? 1.0f : 0.0f);
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.INTEGER)
    public Integer convertToInteger(Boolean value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value != false ? 1 : 0;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.LONG)
    public Long convertToLong(Boolean value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value != false ? 1L : 0L;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.SHORT)
    public Short convertToShort(Boolean value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (short)(value != false ? 1 : 0);
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.STRING, concerns={AtlasConversionConcern.CONVENTION})
    public String convertToString(Boolean value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        String format = targetFormat != null && !"".equals(targetFormat) ? targetFormat : STRING_VALUES;
        String[] values = format.split("\\|");
        String trueValue = "";
        String falseValue = "";
        if (values.length == 2) {
            trueValue = values[0];
            falseValue = values[1];
        } else if (values.length == 1) {
            trueValue = values[0];
        }
        return String.valueOf(value != false ? trueValue : falseValue);
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.NUMBER)
    public Number convertToNumber(Boolean value) throws AtlasConversionException {
        return this.convertToShort(value);
    }
}

