/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class DoubleConverter
implements AtlasPrimitiveConverter<Double> {
    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean convertToBoolean(Double value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value == 0.0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte convertToByte(Double value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value % 1.0 == 0.0 && value >= -128.0 && value <= 127.0) {
            return value.byteValue();
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException(String.format("Double %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE or is not a whole number", value)));
    }

    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Character convertToCharacter(Double value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value < 0.0 || value > 65535.0) {
            throw new AtlasConversionException(String.format("Double %s is greater than Character.MAX_VALUE or less than Character.MIN_VALUE", value));
        }
        return Character.valueOf((char)value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Double value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.FLOAT, concerns={AtlasConversionConcern.RANGE})
    public Float convertToFloat(Double value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > 3.4028234663852886E38 || value < (double)1.4E-45f && value != 0.0) {
            throw new AtlasConversionException(String.format("Double %s is greater than Float.MAX_VALUE or less than Float.MIN_VALUE", value));
        }
        return Float.valueOf(value.floatValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.RANGE})
    public Integer convertToInteger(Double value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > 2.147483647E9) {
            throw new AtlasConversionException(String.format("Double %s is greater than Integer.MAX_VALUE", value));
        }
        return value.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.LONG, concerns={AtlasConversionConcern.RANGE})
    public Long convertToLong(Double value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > 9.223372036854776E18) {
            throw new AtlasConversionException(String.format("Double %s is greater than Long.MAX_VALUE", value));
        }
        return value.longValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short convertToShort(Double value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > 32767.0 || value < -32768.0) {
            throw new AtlasConversionException(String.format("Double %s is greater than Short.MAX_VALUE or less than Short.MIN_VALUE", value));
        }
        return value.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DOUBLE, targetType=FieldType.STRING)
    public String convertToString(Double value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

