/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class FloatConverter
implements AtlasPrimitiveConverter<Float> {
    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean convertToBoolean(Float value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if ((double)value.floatValue() == 0.0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte convertToByte(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() % 1.0f == 0.0f && value.floatValue() >= -128.0f && value.floatValue() <= 127.0f) {
            return value.byteValue();
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException(String.format("Float %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE or is not a whole number", value)));
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Character convertToCharacter(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < 0.0f || value.floatValue() > 65535.0f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Character.MAX_VALUE or is less than Character.MIN_VALUE", value));
        }
        return Character.valueOf((char)value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.FLOAT)
    public Float convertToFloat(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.RANGE})
    public Integer convertToInteger(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < -2.1474836E9f || value.floatValue() > 2.1474836E9f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Integer.MAX_VALUE or is less than Integer.MIN_VALUE", value));
        }
        return value.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.LONG, concerns={AtlasConversionConcern.RANGE})
    public Long convertToLong(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() > 9.223372E18f || value.floatValue() < -9.223372E18f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Long.MAX_VALUE or is less than Long.MIN_VALUE", value));
        }
        return value.longValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short convertToShort(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() > 32767.0f || value.floatValue() < -32768.0f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Short.MAX_VALUE  or is less than Short.MIN_VALUE", value));
        }
        return value.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.STRING)
    public String convertToString(Float value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

