/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class LongConverter
implements AtlasPrimitiveConverter<Long> {
    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean convertToBoolean(Long value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value == 0L) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte convertToByte(Long value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value >= -128L && value <= 127L) {
            return value.byteValue();
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException(String.format("Long %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE", value)));
    }

    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Character convertToCharacter(Long value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value < 0L || value > 65535L) {
            throw new AtlasConversionException(String.format("Long %s is greater than Character.MAX_VALUE  or less than Character.MIN_VALUE", value));
        }
        return Character.valueOf((char)value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Long value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.FLOAT)
    public Float convertToFloat(Long value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.RANGE})
    public Integer convertToInteger(Long value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new AtlasConversionException(String.format("Long %s is greater than Integer.MAX_VALUE  or less than Integer.MIN_VALUE", value));
        }
        return value.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.LONG)
    public Long convertToLong(Long value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return new Long(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short convertToShort(Long value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > 32767L || value < -32768L) {
            throw new AtlasConversionException(String.format("Long %s is greater than Short.MAX_VALUE or less than Short.MIN_VALUE", value));
        }
        return value.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.LONG, targetType=FieldType.STRING)
    public String convertToString(Long value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

