/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.ConstantModule;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.core.PropertyModule;
import io.atlasmap.mxbean.AtlasContextMXBean;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleInfo;
import io.atlasmap.spi.AtlasModuleInfoRegistry;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.Validations;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasContext
implements AtlasContext,
AtlasContextMXBean {
    public static final String CONSTANTS_DOCUMENT_ID = "io.atlasmap.core.DefaultAtlasContext.constants.docId";
    public static final String PROPERTIES_DOCUMENT_ID = "io.atlasmap.core.DefaultAtlasContext.properties.docId";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasContext.class);
    private ObjectName jmxObjectName;
    private final UUID uuid;
    private DefaultAtlasContextFactory factory;
    private AtlasMapping mappingDefinition;
    private AtlasMappingService.AtlasMappingFormat atlasMappingFormat;
    private URI atlasMappingUri;
    private Map<String, AtlasModule> sourceModules = new HashMap<String, AtlasModule>();
    private Map<String, AtlasModule> targetModules = new HashMap<String, AtlasModule>();
    private Map<String, LookupTable> lookupTables = new HashMap<String, LookupTable>();

    public DefaultAtlasContext(URI atlasMappingUri) throws AtlasException {
        this(DefaultAtlasContextFactory.getInstance(), atlasMappingUri, AtlasMappingService.AtlasMappingFormat.XML);
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, URI atlasMappingUri) throws AtlasException {
        this(factory, atlasMappingUri, AtlasMappingService.AtlasMappingFormat.XML);
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, URI atlasMappingUri, AtlasMappingService.AtlasMappingFormat format) throws AtlasException {
        this.factory = factory;
        this.uuid = UUID.randomUUID();
        this.atlasMappingUri = atlasMappingUri;
        this.atlasMappingFormat = format;
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, AtlasMapping mapping) throws AtlasException {
        this.factory = factory;
        this.uuid = UUID.randomUUID();
        this.mappingDefinition = mapping;
    }

    protected void init() throws AtlasException {
        this.registerJmx(this);
        if (this.atlasMappingUri != null) {
            this.mappingDefinition = this.factory.getMappingService().loadMapping(this.atlasMappingUri, this.atlasMappingFormat);
        }
        this.sourceModules.clear();
        ConstantModule constant = new ConstantModule();
        constant.setConversionService(this.factory.getConversionService());
        constant.setFieldActionService(this.factory.getFieldActionService());
        this.sourceModules.put(CONSTANTS_DOCUMENT_ID, constant);
        PropertyModule propSource = new PropertyModule(this.factory.getPropertyStrategy());
        propSource.setMode(AtlasModuleMode.SOURCE);
        propSource.setConversionService(this.factory.getConversionService());
        propSource.setFieldActionService(this.factory.getFieldActionService());
        this.sourceModules.put(PROPERTIES_DOCUMENT_ID, propSource);
        this.targetModules.clear();
        this.lookupTables.clear();
        if (this.mappingDefinition.getLookupTables() != null && this.mappingDefinition.getLookupTables().getLookupTable() != null) {
            for (LookupTable table : this.mappingDefinition.getLookupTables().getLookupTable()) {
                this.lookupTables.put(table.getName(), table);
            }
        }
        AtlasModuleInfoRegistry moduleInfoRegistry = this.factory.getModuleInfoRegistry();
        for (DataSource ds : this.mappingDefinition.getDataSource()) {
            AtlasModuleInfo moduleInfo = moduleInfoRegistry.lookupByUri(ds.getUri());
            if (moduleInfo == null) {
                LOG.error("Cannot find module info for the DataSource uri '{}'", (Object)ds.getUri());
                continue;
            }
            if (ds.getDataSourceType() != DataSourceType.SOURCE && ds.getDataSourceType() != DataSourceType.TARGET) {
                LOG.error("Unsupported DataSource type '{}'", (Object)ds.getDataSourceType());
                continue;
            }
            String docId = ds.getId();
            if (docId == null || docId.isEmpty()) {
                String string = docId = ds.getDataSourceType() == DataSourceType.SOURCE ? "ATLAS_DEFAULT_SOURCE_DOC" : "ATLAS_DEFAULT_TARGET_DOC";
            }
            if (ds.getDataSourceType() == DataSourceType.SOURCE && this.sourceModules.containsKey(docId)) {
                LOG.error("Duplicated {} DataSource ID '{}' was detected, ignoring...", (Object)ds.getDataSourceType(), (Object)ds.getId());
                continue;
            }
            if (ds.getDataSourceType() == DataSourceType.TARGET && this.targetModules.containsKey(docId)) {
                LOG.error("Duplicated {} DataSource ID '{}' was detected, ignoring...", (Object)ds.getDataSourceType(), (Object)docId);
                continue;
            }
            try {
                AtlasModule module = (AtlasModule)moduleInfo.getModuleClass().newInstance();
                module.setConversionService(this.factory.getConversionService());
                module.setFieldActionService(this.factory.getFieldActionService());
                module.setUri(ds.getUri());
                if (ds.getDataSourceType() == DataSourceType.SOURCE) {
                    module.setMode(AtlasModuleMode.SOURCE);
                    this.getSourceModules().put(docId, module);
                } else if (ds.getDataSourceType() == DataSourceType.TARGET) {
                    module.setMode(AtlasModuleMode.TARGET);
                    this.getTargetModules().put(docId, module);
                }
                module.setDocId(docId);
                module.init();
            }
            catch (Throwable t) {
                LOG.error("Unable to initialize {} module: {}", (Object)ds.getDataSourceType(), (Object)moduleInfo.toString());
                LOG.error(t.getMessage(), t);
                throw new AtlasException(String.format("Unable to initialize %s module: %s", ds.getDataSourceType(), moduleInfo.toString()), t);
            }
        }
    }

    protected void registerJmx(DefaultAtlasContext context) {
        try {
            this.setJmxObjectName(new ObjectName(this.getDefaultAtlasContextFactory().getJmxObjectName() + ",context=Contexts,uuid=" + this.uuid.toString()));
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, this.getJmxObjectName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered AtlasContext {} with JMX", (Object)context.getUuid());
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to register AtlasContext {} with JMX", (Object)context.getUuid());
            LOG.warn(t.getMessage(), t);
        }
    }

    public void process(AtlasSession userSession) throws AtlasException {
        if (!(userSession instanceof DefaultAtlasSession)) {
            throw new AtlasException(String.format("Unsupported session class '%s'", userSession.getClass().getName()));
        }
        if (!this.equals(userSession.getAtlasContext())) {
            throw new AtlasException("Cannot execute AtlasSession created by the other AtlasContext");
        }
        DefaultAtlasSession session = (DefaultAtlasSession)userSession;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Begin process {}", (Object)(session == null ? null : session.toString()));
        }
        session.head().unset();
        session.getAudits().getAudit().clear();
        session.getValidations().getValidation().clear();
        this.processValidation((AtlasSession)session);
        for (Validation v : session.getValidations().getValidation()) {
            AtlasUtil.addAudit((AtlasSession)session, v);
        }
        if (session.hasErrors()) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Aborting due to {} errors in pre-validation", (Object)session.errorCount());
            }
            return;
        }
        for (AtlasModule module : this.getSourceModules().values()) {
            module.processPreSourceExecution((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getTargetModules().values()) {
            module.processPreTargetExecution((AtlasInternalSession)session);
        }
        if (session.hasErrors()) {
            if (LOG.isDebugEnabled()) {
                LOG.error("Aborting due to {} errors in pre-execution", (Object)session.errorCount());
            }
            return;
        }
        for (BaseMapping baseMapping : session.getMapping().getMappings().getMapping()) {
            for (Mapping mapping : this.extractCollectionMappings(session, baseMapping)) {
                session.head().setMapping(mapping).setLookupTable(this.lookupTables.get(mapping.getLookupTableName()));
                if (mapping.getOutputField() == null || mapping.getOutputField().isEmpty()) {
                    AtlasUtil.addAudit((AtlasSession)session, null, String.format("Mapping does not contain at least one output field: alias=%s desc=%s", mapping.getAlias(), mapping.getDescription()), null, AuditStatus.WARN, null);
                    continue;
                }
                if (mapping.getInputField() == null || mapping.getInputField().isEmpty()) {
                    AtlasUtil.addAudit((AtlasSession)session, null, String.format("Mapping does not contain at least one source field: alias=%s desc=%s", mapping.getAlias(), mapping.getDescription()), null, AuditStatus.WARN, null);
                } else {
                    this.processSourceFieldMappings(session, mapping.getInputField());
                }
                this.processTargetFieldMappings(session, mapping);
            }
        }
        for (AtlasModule module : this.getSourceModules().values()) {
            module.processPostValidation((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getTargetModules().values()) {
            module.processPostValidation((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getSourceModules().values()) {
            module.processPostSourceExecution((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getTargetModules().values()) {
            module.processPostTargetExecution((AtlasInternalSession)session);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End process {}", (Object)(session == null ? null : session.toString()));
        }
    }

    private List<Mapping> extractCollectionMappings(DefaultAtlasSession session, BaseMapping baseMapping) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generating Source Mappings from mapping: {}", (Object)baseMapping);
        }
        if (!baseMapping.getMappingType().equals((Object)MappingType.COLLECTION)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Mapping is not a collection mapping, not cloning: {}", (Object)baseMapping);
            }
            return Arrays.asList((Mapping)baseMapping);
        }
        LinkedList<Mapping> mappings = new LinkedList<Mapping>();
        for (BaseMapping m : ((Collection)baseMapping).getMappings().getMapping()) {
            Mapping mapping = (Mapping)m;
            Field sourceField = (Field)mapping.getInputField().get(0);
            boolean sourceIsCollection = AtlasPath.isCollection(sourceField.getPath());
            if (!sourceIsCollection) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Internal mapping's source field is not a collection, not cloning: {}", (Object)mapping);
                }
                for (Field f : mapping.getOutputField()) {
                    f.setPath(AtlasPath.overwriteCollectionIndex(f.getPath(), 0));
                }
                mappings.add(mapping);
                continue;
            }
            AtlasModule module = this.resolveModule(FieldDirection.SOURCE, sourceField);
            int sourceCollectionSize = module.getCollectionSize((AtlasInternalSession)session, sourceField);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Internal mapping's source field is a collection. Cloning it for each item ({} clones): {}", (Object)sourceCollectionSize, (Object)mapping);
            }
            for (int i = 0; i < sourceCollectionSize; ++i) {
                Field clonedField;
                Mapping cloneMapping = (Mapping)AtlasModelFactory.cloneMapping((BaseMapping)mapping, (boolean)false);
                for (Field f : mapping.getInputField()) {
                    clonedField = module.cloneField(f);
                    clonedField.setPath(AtlasPath.overwriteCollectionIndex(clonedField.getPath(), i));
                    cloneMapping.getInputField().add(clonedField);
                }
                for (Field f : mapping.getOutputField()) {
                    clonedField = module.cloneField(f);
                    if (AtlasPath.isCollection(clonedField.getPath())) {
                        clonedField.setPath(AtlasPath.overwriteCollectionIndex(clonedField.getPath(), i));
                    }
                    cloneMapping.getOutputField().add(clonedField);
                }
                mappings.add(cloneMapping);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated {} mappings from mapping: {}", (Object)mappings.size(), (Object)baseMapping);
        }
        ((Collection)baseMapping).getMappings().getMapping().clear();
        ((Collection)baseMapping).getMappings().getMapping().addAll(mappings);
        return mappings;
    }

    private AtlasModule resolveModule(FieldDirection direction, Field field) {
        if (direction == FieldDirection.SOURCE && field instanceof ConstantField) {
            return this.sourceModules.get(CONSTANTS_DOCUMENT_ID);
        }
        if (direction == FieldDirection.SOURCE && field instanceof PropertyField) {
            return this.sourceModules.get(PROPERTIES_DOCUMENT_ID);
        }
        String docId = field.getDocId();
        if (docId == null || docId.isEmpty()) {
            docId = direction == FieldDirection.SOURCE ? "ATLAS_DEFAULT_SOURCE_DOC" : "ATLAS_DEFAULT_TARGET_DOC";
        }
        return direction == FieldDirection.SOURCE ? this.sourceModules.get(docId) : this.targetModules.get(docId);
    }

    private void processSourceFieldMappings(DefaultAtlasSession session, List<Field> sourceFields) throws AtlasException {
        for (Field sourceField : sourceFields) {
            session.head().setSourceField(sourceField);
            AtlasModule module = this.resolveModule(FieldDirection.SOURCE, sourceField);
            if (module == null) {
                AtlasUtil.addAudit((AtlasSession)session, sourceField.getDocId(), String.format("Module not found for docId '%s'", sourceField.getDocId()), sourceField.getPath(), AuditStatus.ERROR, null);
                return;
            }
            if (!module.isSupportedField(sourceField).booleanValue()) {
                AtlasUtil.addAudit((AtlasSession)session, sourceField.getDocId(), String.format("Unsupported source field type '%s' for DataSource '%s'", sourceField.getClass().getName(), module.getUri()), sourceField.getPath(), AuditStatus.ERROR, null);
                return;
            }
            module.processSourceFieldMapping((AtlasInternalSession)session);
        }
    }

    private void processTargetFieldMappings(DefaultAtlasSession session, Mapping mapping) throws AtlasException {
        MappingType mappingType = mapping.getMappingType();
        List sourceFields = mapping.getInputField();
        List targetFields = mapping.getOutputField();
        AtlasModule module = null;
        Field targetField = null;
        switch (mappingType) {
            case LOOKUP: 
            case MAP: {
                targetField = (Field)targetFields.get(0);
                module = this.resolveModule(FieldDirection.TARGET, targetField);
                if (!this.auditTargetFieldType(session, module, targetField)) {
                    return;
                }
                session.head().setTargetField(targetField);
                module.processTargetFieldMapping((AtlasInternalSession)session);
                return;
            }
            case COMBINE: {
                targetField = (Field)targetFields.get(0);
                module = this.resolveModule(FieldDirection.TARGET, targetField);
                if (!this.auditTargetFieldType(session, module, targetField)) {
                    return;
                }
                Field sourceField = this.processCombineField(session, mapping, sourceFields, targetField);
                session.head().setSourceField(sourceField).setTargetField(targetField);
                module.processTargetFieldMapping((AtlasInternalSession)session);
                return;
            }
            case SEPARATE: {
                Field sourceFieldsep = (Field)sourceFields.get(0);
                if (sourceFieldsep.getFieldType() != null && !FieldType.STRING.equals((Object)sourceFieldsep.getFieldType()) || sourceFieldsep.getValue() == null || !sourceFieldsep.getValue().getClass().isAssignableFrom(String.class)) {
                    AtlasUtil.addAudit((AtlasSession)session, sourceFieldsep.getDocId(), String.format("Separate requires String field type for sourceField.path=%s", sourceFieldsep.getPath()), sourceFieldsep.getPath(), AuditStatus.WARN, null);
                    return;
                }
                List<Field> separatedFields = this.processSeparateField(session, mapping, (Field)sourceFields.get(0));
                for (Field f : targetFields) {
                    targetField = f;
                    module = this.resolveModule(FieldDirection.TARGET, targetField);
                    if (!this.auditTargetFieldType(session, module, targetField)) continue;
                    if (targetField.getIndex() == null || targetField.getIndex() < 0) {
                        AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), String.format("Separate requires zero or positive Index value to be set on targetField targetField.path=%s", targetField.getPath()), targetField.getPath(), AuditStatus.WARN, null);
                        continue;
                    }
                    if (separatedFields.size() <= targetField.getIndex()) {
                        String errorMessage = String.format("Separate returned fewer segments count=%s when targetField.path=%s requested index=%s", separatedFields.size(), targetField.getPath(), targetField.getIndex());
                        AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), errorMessage, targetField.getPath(), AuditStatus.WARN, null);
                        break;
                    }
                    session.head().setSourceField(separatedFields.get(targetField.getIndex())).setTargetField(targetField);
                    module.processTargetFieldMapping((AtlasInternalSession)session);
                }
                return;
            }
        }
        AtlasUtil.addAudit((AtlasSession)session, null, String.format("Unsupported mappingType=%s detected", mapping.getMappingType()), null, AuditStatus.ERROR, null);
    }

    private boolean auditTargetFieldType(DefaultAtlasSession session, AtlasModule module, Field field) {
        if (module == null) {
            AtlasUtil.addAudit((AtlasSession)session, field.getDocId(), String.format("Module not found for field type='%s', path='%s'", field.getFieldType(), field.getPath()), field.getPath(), AuditStatus.ERROR, null);
            return false;
        }
        if (!module.isSupportedField(field).booleanValue()) {
            AtlasUtil.addAudit((AtlasSession)session, field.getDocId(), String.format("Unsupported target field type '%s' for DataSource '%s'", field.getClass().getName(), module.getUri()), field.getPath(), AuditStatus.ERROR, null);
            return false;
        }
        return true;
    }

    private Field processCombineField(DefaultAtlasSession session, Mapping mapping, List<Field> sourceFields, Field targetField) throws AtlasException {
        HashMap<Integer, String> combineValues = null;
        for (Field sourceField : sourceFields) {
            String sourceValue;
            if (sourceField.getIndex() == null || sourceField.getIndex() < 0) {
                AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), String.format("Combine requires zero or positive Index value to be set on all sourceFields sourceField.path=%s", sourceField.getPath()), targetField.getPath(), AuditStatus.WARN, null);
                continue;
            }
            if (combineValues == null) {
                combineValues = new HashMap<Integer, String>();
            }
            if (sourceField.getFieldType() == null && sourceField.getValue() == null) continue;
            try {
                sourceValue = (String)this.factory.getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), FieldType.STRING, null);
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), String.format("Suitable converter for sourceField.path=%s hasn't been found", sourceField.getPath()), targetField.getPath(), AuditStatus.WARN, null);
                sourceValue = sourceField.getValue() != null ? sourceField.getValue().toString() : null;
            }
            combineValues.put(sourceField.getIndex(), sourceValue);
        }
        String combinedValue = null;
        combinedValue = mapping.getDelimiter() != null ? session.getAtlasContext().getContextFactory().getCombineStrategy().combineValues(combineValues, mapping.getDelimiter()) : session.getAtlasContext().getContextFactory().getCombineStrategy().combineValues(combineValues);
        SimpleField answer = AtlasModelFactory.cloneFieldToSimpleField((Field)sourceFields.get(0));
        if (combinedValue == null || combinedValue.trim().isEmpty()) {
            LOG.debug(String.format("Empty combined string for Combine mapping targetField.path=%s", targetField.getPath()));
        } else {
            answer.setValue((Object)combinedValue);
        }
        return answer;
    }

    protected List<Field> processSeparateField(DefaultAtlasSession session, Mapping mapping, Field sourceField) throws AtlasException {
        String sourceValue;
        ArrayList<Field> answer = new ArrayList<Field>();
        try {
            sourceValue = (String)this.factory.getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), FieldType.STRING, null);
        }
        catch (AtlasConversionException e) {
            AtlasUtil.addAudit((AtlasSession)session, sourceField.getDocId(), String.format("Suitable converter for sourceField.path=%s hasn't been found", sourceField.getPath()), sourceField.getPath(), AuditStatus.WARN, null);
            sourceValue = sourceField.getValue().toString();
        }
        List separatedValues = null;
        separatedValues = mapping.getDelimiter() != null ? session.getAtlasContext().getContextFactory().getSeparateStrategy().separateValue(sourceValue, mapping.getDelimiter()) : session.getAtlasContext().getContextFactory().getSeparateStrategy().separateValue(sourceValue);
        if (separatedValues == null || separatedValues.isEmpty()) {
            LOG.debug(String.format("Empty string for Separate mapping sourceField.path=%s", sourceField.getPath()));
        } else {
            for (String separatedValue : separatedValues) {
                SimpleField simpleField = AtlasModelFactory.cloneFieldToSimpleField((Field)sourceField);
                simpleField.setValue((Object)separatedValue);
                simpleField.setFieldType(FieldType.STRING);
                answer.add((Field)simpleField);
            }
        }
        return answer;
    }

    public void processValidation(AtlasSession userSession) throws AtlasException {
        List validations;
        if (!(userSession instanceof DefaultAtlasSession)) {
            throw new AtlasException(String.format("Unsupported session class '%s'", userSession.getClass().getName()));
        }
        if (!this.equals(userSession.getAtlasContext())) {
            throw new AtlasException("Cannot execute AtlasSession created by the other AtlasContext");
        }
        DefaultAtlasSession session = (DefaultAtlasSession)userSession;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Begin processValidation {}", (Object)(session == null ? null : session.toString()));
        }
        if ((validations = this.getContextFactory().getValidationService().validateMapping(session.getMapping())) != null && !validations.isEmpty()) {
            session.getValidations().getValidation().addAll(validations);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detected {} core validation notices", (Object)validations.size());
        }
        for (AtlasModule module : this.getSourceModules().values()) {
            module.processPreValidation((AtlasInternalSession)session);
        }
        for (AtlasModule module : this.getTargetModules().values()) {
            module.processPreValidation((AtlasInternalSession)session);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End processValidation {}", (Object)(session == null ? null : session.toString()));
        }
    }

    protected DefaultAtlasContextFactory getDefaultAtlasContextFactory() {
        return this.factory;
    }

    public AtlasContextFactory getContextFactory() {
        return this.factory;
    }

    public AtlasMapping getMapping() {
        return this.mappingDefinition;
    }

    public AtlasSession createSession() throws AtlasException {
        if (this.mappingDefinition == null && this.atlasMappingUri != null) {
            this.init();
        }
        return this.doCreateSession();
    }

    public AtlasSession createSession(AtlasMapping mappingDefinition) throws AtlasException {
        this.atlasMappingUri = null;
        this.mappingDefinition = mappingDefinition;
        this.init();
        return this.doCreateSession();
    }

    private AtlasSession doCreateSession() {
        DefaultAtlasSession session = new DefaultAtlasSession(this.mappingDefinition);
        session.setAtlasContext(this);
        session.setAudits(new Audits());
        session.setValidations(new Validations());
        this.setDefaultSessionProperties((AtlasSession)session);
        return session;
    }

    protected void setDefaultSessionProperties(AtlasSession session) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(TimeZone.getDefault());
        session.getProperties().put("Atlas.CreatedDateTimeTZ", df.format(date));
    }

    public Map<String, AtlasModule> getSourceModules() {
        return this.sourceModules;
    }

    public void setSourceModules(Map<String, AtlasModule> sourceModules) {
        this.sourceModules = sourceModules;
    }

    public Map<String, AtlasModule> getTargetModules() {
        return this.targetModules;
    }

    public void setTargetModules(Map<String, AtlasModule> targetModules) {
        this.targetModules = targetModules;
    }

    public Map<String, LookupTable> getLookupTables() {
        return this.lookupTables;
    }

    public void setLookupTables(Map<String, LookupTable> lookupTables) {
        this.lookupTables = lookupTables;
    }

    protected void setJmxObjectName(ObjectName jmxObjectName) {
        this.jmxObjectName = jmxObjectName;
    }

    public ObjectName getJmxObjectName() {
        return this.jmxObjectName;
    }

    public String getUuid() {
        return this.uuid != null ? this.uuid.toString() : null;
    }

    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String getMappingName() {
        return this.mappingDefinition != null ? this.mappingDefinition.getName() : null;
    }

    protected void setMappingUri(URI atlasMappingUri) {
        this.atlasMappingUri = atlasMappingUri;
    }

    public String getMappingUri() {
        return this.atlasMappingUri != null ? this.atlasMappingUri.toString() : null;
    }

    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    public String getThreadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        return "DefaultAtlasContext [jmxObjectName=" + this.jmxObjectName + ", uuid=" + this.uuid + ", factory=" + this.factory + ", mappingName=" + this.getMappingName() + ", mappingUri=" + this.getMappingUri() + ", sourceModules=" + this.sourceModules + ", targetModules=" + this.targetModules + "]";
    }
}

