/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.AddDays;
import io.atlasmap.v2.AddSeconds;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class DateFieldActions
implements AtlasFieldAction {
    @AtlasFieldActionInfo(name="AddDays", sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Date addDays(Action action, Date input) {
        if (action == null || !(action instanceof AddDays)) {
            throw new IllegalArgumentException("Action must be an AddDays action");
        }
        if (input == null) {
            return null;
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(input.toInstant(), ZoneId.systemDefault());
        AddDays addDays = (AddDays)action;
        dateTime = dateTime.plusDays(addDays.getDays() == null ? 0L : (long)addDays.getDays().intValue());
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    @AtlasFieldActionInfo(name="AddSeconds", sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Date addSeconds(Action action, Date input) {
        if (action == null || !(action instanceof AddSeconds)) {
            throw new IllegalArgumentException("Action must be an AddSeconds action");
        }
        if (input == null) {
            return null;
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(input.toInstant(), ZoneId.systemDefault());
        AddSeconds addSeconds = (AddSeconds)action;
        dateTime = dateTime.plusSeconds(addSeconds.getSeconds() == null ? 0L : (long)addSeconds.getSeconds().intValue());
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    @AtlasFieldActionInfo(name="CurrentDate", sourceType=FieldType.ANY, targetType=FieldType.DATE_TIME, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Date currentDate(Action action, Object input) {
        return Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    @AtlasFieldActionInfo(name="CurrentDateTime", sourceType=FieldType.ANY, targetType=FieldType.DATE_TIME, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Date currentDateTime(Action action, Object input) {
        return Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
    }

    @AtlasFieldActionInfo(name="CurrentTime", sourceType=FieldType.ANY, targetType=FieldType.DATE_TIME, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Date currentTime(Action action, Object input) {
        return DateFieldActions.currentDateTime(action, input);
    }

    @AtlasFieldActionInfo(name="DayOfWeek", sourceType=FieldType.DATE_TIME, targetType=FieldType.INTEGER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Integer dayOfWeek(Action action, Date input) {
        if (input == null) {
            return null;
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(input.toInstant(), ZoneId.systemDefault());
        return dateTime.getDayOfWeek().getValue();
    }

    @AtlasFieldActionInfo(name="DayOfYear", sourceType=FieldType.DATE_TIME, targetType=FieldType.INTEGER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Integer dayOfYear(Action action, Date input) {
        if (input == null) {
            return null;
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(input.toInstant(), ZoneId.systemDefault());
        return dateTime.getDayOfYear();
    }
}

