/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Contains;
import io.atlasmap.v2.Equals;
import io.atlasmap.v2.FieldType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class ObjectFieldActions
implements AtlasFieldAction {
    @AtlasFieldActionInfo(name="Contains", sourceType=FieldType.ANY, targetType=FieldType.BOOLEAN, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Boolean contains(Action action, Object input) {
        if (!(action instanceof Contains)) {
            throw new IllegalArgumentException("Action must be a Contains action");
        }
        Contains contains = (Contains)action;
        if (input == null) {
            return contains.getValue() == null;
        }
        if (input instanceof Collection) {
            return ObjectFieldActions.collectionContains((Collection)input, contains);
        }
        if (input.getClass().isArray()) {
            return ObjectFieldActions.collectionContains(Arrays.asList((Object[])input), contains);
        }
        if (input instanceof Map) {
            if (ObjectFieldActions.collectionContains(((Map)input).values(), contains)) {
                return true;
            }
            return ObjectFieldActions.collectionContains(((Map)input).keySet(), contains);
        }
        if (contains.getValue() == null) {
            return false;
        }
        return input.toString().contains(contains.getValue());
    }

    @AtlasFieldActionInfo(name="Equals", sourceType=FieldType.ANY, targetType=FieldType.BOOLEAN, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Boolean equals(Action action, Object input) {
        if (!(action instanceof Equals)) {
            throw new IllegalArgumentException("Action must be an Equals action");
        }
        Equals equals = (Equals)action;
        if (input == null) {
            return equals.getValue() == null;
        }
        if (input.getClass().isArray()) {
            return Arrays.asList((Object[])input).toString().equals(equals.getValue());
        }
        return input.toString().equals(equals.getValue());
    }

    @AtlasFieldActionInfo(name="IsNull", sourceType=FieldType.ANY, targetType=FieldType.INTEGER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Boolean isNull(Action action, Object input) {
        return input == null;
    }

    @AtlasFieldActionInfo(name="Length", sourceType=FieldType.ANY, targetType=FieldType.INTEGER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Integer length(Action action, Object input) {
        if (input == null) {
            return -1;
        }
        if (input instanceof Collection) {
            return ((Collection)input).size();
        }
        if (input.getClass().isArray()) {
            return ((Object[])input).length;
        }
        if (input instanceof Map) {
            return ((Map)input).size();
        }
        return input.toString().length();
    }

    private static boolean collectionContains(Collection<?> collection, Contains contains) {
        for (Object item : collection) {
            if (!(item == null ? contains.getValue() == null : item.toString().equals(contains.getValue()))) continue;
            return true;
        }
        return false;
    }
}

