/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import java.util.regex.Pattern;

public class StringSimpleFieldActions
implements AtlasFieldAction {
    public static final String STRING_SEPARATOR_REGEX = "[\\s+\\:\\_\\+\\=\\-]+";
    public static final Pattern STRING_SEPARATOR_PATTERN = Pattern.compile("[\\s+\\:\\_\\+\\=\\-]+");

    @AtlasFieldActionInfo(name="Capitalize", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String capitalize(Action action, String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        if (input.length() == 1) {
            return String.valueOf(input.charAt(0)).toUpperCase();
        }
        return String.valueOf(input.charAt(0)).toUpperCase() + input.substring(1);
    }

    @AtlasFieldActionInfo(name="FileExtension", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String fileExtension(Action action, String input) {
        if (input == null) {
            return null;
        }
        int ndx = input.lastIndexOf(46);
        return ndx < 0 ? null : input.substring(ndx + 1);
    }

    @AtlasFieldActionInfo(name="Lowercase", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String lowercase(Action action, String input) {
        if (input == null) {
            return null;
        }
        return input.toLowerCase();
    }

    @AtlasFieldActionInfo(name="Normalize", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String normalize(Action action, String input) {
        return input == null ? null : input.replaceAll("\\s+", " ").trim();
    }

    @AtlasFieldActionInfo(name="RemoveFileExtension", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String removeFileExtension(Action action, String input) {
        if (input == null) {
            return null;
        }
        int ndx = input.lastIndexOf(46);
        return ndx < 0 ? input : input.substring(0, ndx);
    }

    @AtlasFieldActionInfo(name="SeparateByDash", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String separateByDash(Action action, String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        return STRING_SEPARATOR_PATTERN.matcher(input).replaceAll("-");
    }

    @AtlasFieldActionInfo(name="SeparateByUnderscore", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String separateByUnderscore(Action action, String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        return STRING_SEPARATOR_PATTERN.matcher(input).replaceAll("_");
    }

    @AtlasFieldActionInfo(name="Trim", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String trim(Action action, String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        return input.trim();
    }

    @AtlasFieldActionInfo(name="TrimLeft", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String trimLeft(Action action, String input) {
        int i;
        if (input == null || input.length() == 0) {
            return input;
        }
        for (i = 0; i < input.length() && Character.isWhitespace(input.charAt(i)); ++i) {
        }
        return input.substring(i);
    }

    @AtlasFieldActionInfo(name="TrimRight", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String trimRight(Action action, String input) {
        int i;
        if (input == null || input.length() == 0) {
            return input;
        }
        for (i = input.length() - 1; i >= 0 && Character.isWhitespace(input.charAt(i)); --i) {
        }
        return input.substring(0, i + 1);
    }

    @AtlasFieldActionInfo(name="Uppercase", sourceType=FieldType.STRING, targetType=FieldType.STRING, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static String uppercase(Action action, String input) {
        if (input == null) {
            return null;
        }
        return input.toUpperCase();
    }
}

