/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BooleanConverter
implements AtlasConverter<Boolean> {
    private static final String STRING_VALUES = "true|false";

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(Boolean value) throws AtlasConversionException {
        return value != null ? BigDecimal.valueOf(value != false ? 1L : 0L) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.BIG_INTEGER)
    public BigInteger toBigInteger(Boolean value) throws AtlasConversionException {
        return value != null ? BigInteger.valueOf(value != false ? 1L : 0L) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.BOOLEAN)
    public Boolean toBoolean(Boolean value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        return value != null ? Boolean.valueOf(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.BYTE)
    public Byte toByte(Boolean value) throws AtlasConversionException {
        return value != null ? Byte.valueOf((byte)(value != false ? 1 : 0)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.CHAR)
    public Character toCharacter(Boolean value) throws AtlasConversionException {
        return value != null ? Character.valueOf((char)(value != false ? 1 : 0)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.DOUBLE)
    public Double toDouble(Boolean value) throws AtlasConversionException {
        return value != null ? Double.valueOf(value != false ? 1.0 : 0.0) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.FLOAT)
    public Float toFloat(Boolean value) throws AtlasConversionException {
        return value != null ? Float.valueOf(value != false ? 1.0f : 0.0f) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.INTEGER)
    public Integer toInteger(Boolean value) throws AtlasConversionException {
        return value != null ? Integer.valueOf(value != false ? 1 : 0) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.LONG)
    public Long toLong(Boolean value) throws AtlasConversionException {
        return value != null ? Long.valueOf(value != false ? 1L : 0L) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.NUMBER)
    public Number toNumber(Boolean value) throws AtlasConversionException {
        return this.toShort(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.SHORT)
    public Short toShort(Boolean value) throws AtlasConversionException {
        return value != null ? Short.valueOf((short)(value != false ? 1 : 0)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BOOLEAN, targetType=FieldType.STRING, concerns={AtlasConversionConcern.CONVENTION})
    public String toString(Boolean value, String sourceFormat, String targetFormat) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        String format = targetFormat != null && !"".equals(targetFormat) ? targetFormat : STRING_VALUES;
        String[] values = format.split("\\|");
        String trueValue = "";
        String falseValue = "";
        if (values.length == 2) {
            trueValue = values[0];
            falseValue = values[1];
        } else if (values.length == 1) {
            trueValue = values[0];
        }
        return String.valueOf(value != false ? trueValue : falseValue);
    }
}

