/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class ByteConverter
implements AtlasConverter<Byte> {
    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(Byte value) {
        return value != null ? BigDecimal.valueOf(value.byteValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.BIG_INTEGER)
    public BigInteger toBigInteger(Byte value) {
        return value != null ? BigInteger.valueOf(value.byteValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean toBoolean(Byte value) {
        if (value == null) {
            return null;
        }
        return value != 0;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.BYTE)
    public Byte toByte(Byte value) {
        return value != null ? new Byte(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.CHAR)
    public Character toCharacter(Byte value) {
        return value != null ? Character.valueOf((char)value.byteValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.DATE_TIME)
    public Date toDate(Byte value) {
        if (value == null) {
            return null;
        }
        if ((long)value.byteValue() >= Instant.MIN.getEpochSecond()) {
            return Date.from(Instant.ofEpochMilli(value.byteValue()));
        }
        return new Date(value.byteValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.DOUBLE)
    public Double toDouble(Byte value) {
        return value != null ? Double.valueOf(value.byteValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.FLOAT)
    public Float toFloat(Byte value) {
        return value != null ? Float.valueOf(value.byteValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.INTEGER)
    public Integer toInteger(Byte value) {
        return value != null ? Integer.valueOf(value.byteValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.DATE)
    public LocalDate toLocalDate(Byte value) {
        return value != null ? Instant.ofEpochMilli(value.byteValue()).atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.TIME)
    public LocalTime toLocalTime(Byte value) {
        return value != null ? Instant.ofEpochMilli(value.byteValue()).atZone(ZoneId.systemDefault()).toLocalTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(Byte value) {
        return value != null ? Instant.ofEpochMilli(value.byteValue()).atZone(ZoneId.systemDefault()).toLocalDateTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.LONG)
    public Long toLong(Byte value) {
        return value != null ? Long.valueOf(value.byteValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.NUMBER)
    public Number toNumber(Byte value) {
        return this.toShort(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.SHORT)
    public Short toShort(Byte value) {
        return value != null ? Short.valueOf(value.byteValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.STRING, concerns={AtlasConversionConcern.CONVENTION})
    public String toString(Byte value) {
        return value != null ? String.valueOf(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(Byte value) {
        return Instant.ofEpochMilli(value.byteValue()).atZone(ZoneId.systemDefault());
    }
}

