/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConverter;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class FloatConverter
implements AtlasConverter<Float> {
    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(Float value) {
        return value != null ? BigDecimal.valueOf(value.floatValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.BIG_INTEGER, concerns={AtlasConversionConcern.FRACTIONAL_PART})
    public BigInteger toBigInteger(Float value) {
        return value != null ? BigDecimal.valueOf(value.floatValue()).toBigInteger() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean toBoolean(Float value) {
        if (value == null) {
            return null;
        }
        if ((double)value.floatValue() == 0.0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte toByte(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() % 1.0f == 0.0f && value.floatValue() >= -128.0f && value.floatValue() <= 127.0f) {
            return value.byteValue();
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException(String.format("Float %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE or is not a whole number", value)));
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Character toCharacter(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < 0.0f || value.floatValue() > 65535.0f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Character.MAX_VALUE or is less than Character.MIN_VALUE", value));
        }
        return Character.valueOf((char)value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.DATE, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.FRACTIONAL_PART})
    public Date toDate(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < -9.223372E18f || value.floatValue() > 9.223372E18f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Long.MAX_VALUE or less than Long.MIN_VALUE", value));
        }
        return new Date(value.longValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.DOUBLE)
    public Double toDouble(Float value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.FLOAT)
    public Float toFloat(Float value) {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.RANGE})
    public Integer toInteger(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < -2.1474836E9f || value.floatValue() > 2.1474836E9f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Integer.MAX_VALUE or is less than Integer.MIN_VALUE", value));
        }
        return value.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.DATE, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.FRACTIONAL_PART})
    public LocalDate toLocalDate(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < -9.223372E18f || value.floatValue() > 9.223372E18f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Long.MAX_VALUE or less than Long.MIN_VALUE", value));
        }
        return Instant.ofEpochMilli(value.longValue()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.TIME, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.FRACTIONAL_PART})
    public LocalTime toLocalTime(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < -9.223372E18f || value.floatValue() > 9.223372E18f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Long.MAX_VALUE or less than Long.MIN_VALUE", value));
        }
        return Instant.ofEpochMilli(value.longValue()).atZone(ZoneId.systemDefault()).toLocalTime();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.DATE_TIME, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.FRACTIONAL_PART})
    public LocalDateTime toLocalDateTime(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < -9.223372E18f || value.floatValue() > 9.223372E18f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Long.MAX_VALUE or less than Long.MIN_VALUE", value));
        }
        return Instant.ofEpochMilli(value.longValue()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.LONG, concerns={AtlasConversionConcern.RANGE})
    public Long toLong(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() > 9.223372E18f || value.floatValue() < -9.223372E18f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Long.MAX_VALUE or is less than Long.MIN_VALUE", value));
        }
        return value.longValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.NUMBER)
    public Number toNumber(Float value) {
        return value;
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short toShort(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() > 32767.0f || value.floatValue() < -32768.0f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Short.MAX_VALUE  or is less than Short.MIN_VALUE", value));
        }
        return value.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.STRING)
    public String toString(Float value) {
        return value != null ? String.valueOf(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.DATE_TIME_TZ, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.FRACTIONAL_PART})
    public ZonedDateTime toZonedDateTime(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() > 9.223372E18f || value.floatValue() < -9.223372E18f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Long.MAX_VALUE or less than Long.MIN_VALUE", value));
        }
        return Instant.ofEpochMilli(value.longValue()).atZone(ZoneId.systemDefault());
    }
}

