/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConverter;
import io.atlasmap.converters.DateTimeHelper;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class LocalDateConverter
implements AtlasConverter<LocalDate> {
    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DECIMAL)
    public BigDecimal toBigDecimal(LocalDate value) {
        return value != null ? BigDecimal.valueOf(this.getStartEpochMilli(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.BIG_INTEGER)
    public BigInteger toBigInteger(LocalDate value) {
        return value != null ? BigInteger.valueOf(this.getStartEpochMilli(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte toByte(LocalDate value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = this.getStartEpochMilli(value);
        if (longValue >= -128L && longValue <= 127L) {
            return longValue.byteValue();
        }
        throw new AtlasConversionException(String.format("LocalDate %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE", value));
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME_TZ)
    public Calendar toCalendar(LocalDate value) {
        return value != null ? GregorianCalendar.from(value.atStartOfDay(ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME)
    public java.util.Date toDate(LocalDate value) {
        return value != null ? new java.util.Date(this.getStartEpochMilli(value)) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DOUBLE)
    public Double toDouble(LocalDate value) {
        return value != null ? Double.valueOf(this.getStartEpochMilli(value).doubleValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.FLOAT)
    public Float toFloat(LocalDate value) {
        return value != null ? Float.valueOf(this.getStartEpochMilli(value).floatValue()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME_TZ)
    public GregorianCalendar toGregorianCalendar(LocalDate value) {
        return value != null ? GregorianCalendar.from(value.atStartOfDay(ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.RANGE})
    public Integer toInteger(LocalDate value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = this.getStartEpochMilli(value);
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw new AtlasConversionException(String.format("LocalDate %s is greater than Integer.MAX_VALUE or less than Integer.MIN_VALUE", value));
        }
        return longValue.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE)
    public LocalDate toLocalDate(LocalDate value) {
        return value;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(LocalDate value) {
        return value != null ? value.atStartOfDay() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.TIME)
    public LocalTime toLocalTime(LocalDate value) {
        return value != null ? value.atStartOfDay().toLocalTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.LONG)
    public Long toLong(LocalDate value) {
        return value != null ? this.getStartEpochMilli(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short toShort(LocalDate value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        Long longValue = this.getStartEpochMilli(value);
        if (longValue > 32767L || longValue < -32768L) {
            throw new AtlasConversionException(String.format("LocalDate %s is greater than Short.MAX_VALUE or less than Short.MIN_VALUE", value));
        }
        return longValue.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.STRING)
    public String toString(LocalDate value) {
        return value != null ? value.toString() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.NUMBER)
    public Number toNumber(LocalDate value) {
        return value != null ? this.getStartEpochMilli(value) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE)
    public Date toSqlDate(LocalDate value) {
        return Date.valueOf(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME)
    public Timestamp toSqlTimestamp(LocalDate value) {
        return value != null ? Timestamp.valueOf(value.atStartOfDay()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(LocalDate value) {
        return value != null ? value.atStartOfDay(ZoneId.systemDefault()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(LocalDate date, String sourceFormat, String targetFormat) {
        return date == null ? null : DateTimeHelper.toZonedDateTime(date, sourceFormat == null ? targetFormat : sourceFormat);
    }

    private Long getStartEpochMilli(LocalDate value) {
        return value != null ? Long.valueOf(value.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli()) : null;
    }
}

