/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.spi.AtlasCombineStrategy;
import io.atlasmap.spi.StringDelimiter;
import java.util.Map;
import java.util.TreeMap;

public class DefaultAtlasCombineStrategy
implements AtlasCombineStrategy {
    public static final StringDelimiter DEFAULT_COMBINE_DELIMITER = StringDelimiter.SPACE;
    public static final Integer DEFAULT_COMBINE_LIMIT = 512;
    private StringDelimiter delimiter = DEFAULT_COMBINE_DELIMITER;
    private Integer limit = DEFAULT_COMBINE_LIMIT;
    private boolean disableAutoTrim = false;
    private boolean disableAddDelimiterOnNull = false;

    public StringDelimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(StringDelimiter delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean isDisableAutoTrim() {
        return this.disableAutoTrim;
    }

    public void setDisableAutoTrim(boolean disableAutoTrim) {
        this.disableAutoTrim = disableAutoTrim;
    }

    public boolean isDisableAddDelimiterOnNull() {
        return this.disableAddDelimiterOnNull;
    }

    public void setDisableAddDelimiterOnNull(boolean disableAddDelimiterOnNull) {
        this.disableAddDelimiterOnNull = disableAddDelimiterOnNull;
    }

    public String combineValues(Map<Integer, String> values) {
        return this.combineValues(values, this.getDelimiter(), this.getLimit());
    }

    public String combineValues(Map<Integer, String> values, StringDelimiter delimiter) {
        return this.combineValues(values, delimiter, this.getLimit());
    }

    public String combineValues(Map<Integer, String> values, StringDelimiter delimiter, Integer limit) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        String combinedString = new String();
        if (values.size() == 1) {
            combinedString = values.get(0);
            return combinedString;
        }
        Map<Integer, String> sortedMap = DefaultAtlasCombineStrategy.sortByKey(values);
        Integer last = sortedMap.keySet().toArray(new Integer[0])[sortedMap.size() - 1];
        boolean first = true;
        int count = 0;
        for (int i = 0; i <= last; ++i) {
            String value = sortedMap.get(i);
            if (first) {
                first = false;
                if (value == null) continue;
                combinedString = this.isDisableAutoTrim() ? combinedString.concat(value) : combinedString.concat(value.trim());
            } else if (value == null) {
                if (!this.disableAddDelimiterOnNull) {
                    combinedString = combinedString.concat(delimiter != null ? delimiter.getValue() : DEFAULT_COMBINE_DELIMITER.getValue());
                }
            } else {
                combinedString = this.isDisableAutoTrim() ? combinedString.concat(delimiter != null ? delimiter.getValue() : DEFAULT_COMBINE_DELIMITER.getValue()).concat(value) : combinedString.concat(delimiter != null ? delimiter.getValue() : DEFAULT_COMBINE_DELIMITER.getValue()).concat(value.trim());
            }
            if (++count >= (limit != null ? limit : DEFAULT_COMBINE_LIMIT)) break;
        }
        return combinedString;
    }

    protected static Map<Integer, String> sortByKey(Map<Integer, String> map) {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>((key1, key2) -> {
            if (key1 == null && key2 == null) {
                return 0;
            }
            if (key1 == null) {
                return -1;
            }
            if (key2 == null) {
                return 1;
            }
            return key1.compareTo((Integer)key2);
        });
        treeMap.putAll(map);
        return treeMap;
    }
}

