/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasFieldActionService;
import io.atlasmap.api.AtlasValidationService;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasCombineStrategy;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.core.DefaultAtlasModuleInfo;
import io.atlasmap.core.DefaultAtlasModuleInfoRegistry;
import io.atlasmap.core.DefaultAtlasPropertyStrategy;
import io.atlasmap.core.DefaultAtlasSeparateStrategy;
import io.atlasmap.core.DefaultAtlasValidationService;
import io.atlasmap.mxbean.AtlasContextFactoryMXBean;
import io.atlasmap.spi.AtlasCombineStrategy;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleInfo;
import io.atlasmap.spi.AtlasModuleInfoRegistry;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.spi.AtlasSeparateStrategy;
import io.atlasmap.v2.AtlasMapping;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasContextFactory
implements AtlasContextFactory,
AtlasContextFactoryMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasContextFactory.class);
    private static DefaultAtlasContextFactory factory = null;
    private String uuid = null;
    private String threadName = null;
    private ObjectName objectName = null;
    private AtlasMappingService atlasMappingService = null;
    private DefaultAtlasConversionService atlasConversionService = null;
    private DefaultAtlasFieldActionService atlasFieldActionService = null;
    private AtlasCombineStrategy atlasCombineStrategy = new DefaultAtlasCombineStrategy();
    private AtlasPropertyStrategy atlasPropertyStrategy = new DefaultAtlasPropertyStrategy();
    private AtlasSeparateStrategy atlasSeparateStrategy = new DefaultAtlasSeparateStrategy();
    private AtlasValidationService atlasValidationService = new DefaultAtlasValidationService();
    private AtlasModuleInfoRegistry moduleInfoRegistry;
    private Map<String, String> properties = null;

    public DefaultAtlasContextFactory() {
    }

    public DefaultAtlasContextFactory(Map<String, String> properties) {
        this.properties = properties;
        this.init(properties);
    }

    public DefaultAtlasContextFactory(Properties properties) {
        HashMap<String, String> tmpProps = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            tmpProps.put(name, properties.getProperty(name));
        }
        this.setProperties(tmpProps);
    }

    public static DefaultAtlasContextFactory getInstance() {
        if (factory == null) {
            factory = new DefaultAtlasContextFactory();
            factory.init();
        }
        return factory;
    }

    public void init() {
        this.init(null);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void init(Map<String, String> properties) {
        this.uuid = UUID.randomUUID().toString();
        this.threadName = Thread.currentThread().getName();
        this.atlasConversionService = DefaultAtlasConversionService.getInstance();
        this.atlasFieldActionService = new DefaultAtlasFieldActionService(this.atlasConversionService);
        this.atlasFieldActionService.init();
        this.registerFactoryJmx(this);
        this.moduleInfoRegistry = new DefaultAtlasModuleInfoRegistry(this);
        this.loadModules("moduleClass", AtlasModule.class);
        this.setMappingService(new AtlasMappingService(this.getAllModuleConfigPackages(this.getModuleInfoRegistry())));
    }

    public void destroy() {
        this.unloadModules();
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.getJmxObjectName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistered AtlasContextFactory with JMX");
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to unregister with JMX", (Throwable)e);
        }
        this.uuid = null;
        this.objectName = null;
        this.properties = null;
        this.atlasMappingService = null;
        this.atlasFieldActionService = null;
        this.atlasConversionService = null;
        this.atlasPropertyStrategy = null;
        this.moduleInfoRegistry = null;
        this.threadName = null;
        factory = null;
    }

    public AtlasContext createContext(File atlasMappingFile) throws AtlasException {
        return this.createContext(atlasMappingFile, AtlasMappingService.AtlasMappingFormat.XML);
    }

    public AtlasContext createContext(File atlasMappingFile, AtlasMappingService.AtlasMappingFormat format) throws AtlasException {
        if (atlasMappingFile == null) {
            throw new AtlasException("AtlasMappingFile must be specified");
        }
        return this.createContext(atlasMappingFile.toURI(), format);
    }

    public AtlasContext createContext(URI atlasMappingUri) throws AtlasException {
        return this.createContext(atlasMappingUri, AtlasMappingService.AtlasMappingFormat.XML);
    }

    public AtlasContext createContext(URI atlasMappingUri, AtlasMappingService.AtlasMappingFormat format) throws AtlasException {
        if (atlasMappingUri == null) {
            throw new AtlasException("AtlasMappingUri must be specified");
        }
        if (this.getMappingService() == null) {
            throw new AtlasException("AtlasMappingService is not set");
        }
        DefaultAtlasContext context = new DefaultAtlasContext(this, atlasMappingUri, format);
        context.init();
        return context;
    }

    public AtlasContext createContext(AtlasMapping mapping) throws AtlasException {
        DefaultAtlasContext context = new DefaultAtlasContext(this, mapping);
        context.init();
        return context;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String getUuid() {
        return this.uuid;
    }

    public ObjectName getJmxObjectName() {
        return this.objectName;
    }

    public AtlasMappingService getMappingService() {
        return this.atlasMappingService;
    }

    public void setMappingService(AtlasMappingService atlasMappingService) {
        this.atlasMappingService = atlasMappingService;
    }

    public AtlasModuleInfoRegistry getModuleInfoRegistry() {
        return this.moduleInfoRegistry;
    }

    public void setModuleInfoRegistry(AtlasModuleInfoRegistry registry) {
        this.moduleInfoRegistry = registry;
    }

    public AtlasConversionService getConversionService() {
        return this.atlasConversionService;
    }

    public AtlasFieldActionService getFieldActionService() {
        return this.atlasFieldActionService;
    }

    public AtlasCombineStrategy getCombineStrategy() {
        return this.atlasCombineStrategy;
    }

    public void setCombineStrategy(AtlasCombineStrategy atlasCombineStrategy) {
        this.atlasCombineStrategy = atlasCombineStrategy;
    }

    public AtlasPropertyStrategy getPropertyStrategy() {
        return this.atlasPropertyStrategy;
    }

    public void setPropertyStrategy(AtlasPropertyStrategy atlasPropertyStrategy) {
        this.atlasPropertyStrategy = atlasPropertyStrategy;
    }

    public AtlasSeparateStrategy getSeparateStrategy() {
        return this.atlasSeparateStrategy;
    }

    public void setSeparateStrategy(AtlasSeparateStrategy atlasSeparateStrategy) {
        this.atlasSeparateStrategy = atlasSeparateStrategy;
    }

    public AtlasValidationService getValidationService() {
        return this.atlasValidationService;
    }

    public void setValidationService(AtlasValidationService atlasValidationService) {
        this.atlasValidationService = atlasValidationService;
    }

    protected void loadModules(String moduleClassProperty, Class<?> moduleInterface) {
        Class<AtlasModule> moduleClass = null;
        String moduleClassName = null;
        HashSet<String> serviceClasses = new HashSet<String>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Enumeration<URL> urls = classLoader.getResources("META-INF/services/atlas/module/atlas.module");
            while (urls.hasMoreElements()) {
                URL tmp = urls.nextElement();
                Properties prop = AtlasUtil.loadPropertiesFromURL(tmp);
                String serviceClassPropertyValue = (String)prop.get(moduleClassProperty);
                if (AtlasUtil.isEmpty(serviceClassPropertyValue)) continue;
                serviceClasses.add(serviceClassPropertyValue);
            }
        }
        catch (Exception e) {
            LOG.warn("Error loading module resources", (Throwable)e);
        }
        for (String clazz : serviceClasses) {
            try {
                moduleClass = Class.forName(clazz);
                moduleClassName = moduleClass.getName();
                if (this.isClassAtlasModule(moduleClass, moduleInterface)) {
                    Class<AtlasModule> atlasModuleClass = moduleClass;
                    Constructor<AtlasModule> constructor = atlasModuleClass.getDeclaredConstructor(new Class[0]);
                    if (constructor != null) {
                        DefaultAtlasModuleInfo module = new DefaultAtlasModuleInfo(this.getModuleName(moduleClass), this.getModuleUri(moduleClass), atlasModuleClass, constructor, this.getSupportedDataFormats(moduleClass), this.getConfigPackages(moduleClass));
                        this.getModuleInfoRegistry().register((AtlasModuleInfo)module);
                        continue;
                    }
                    LOG.warn("Invalid module class " + moduleClassName + ": constructor is not present");
                    continue;
                }
                LOG.warn("Invalid module class  " + moduleClassName + ": unsupported AtlasModule");
            }
            catch (NoSuchMethodException e) {
                LOG.warn("Invalid module class " + moduleClassName + ": constructor is not present.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Invalid module class " + moduleClassName + " not found in classLoader", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Invalid module class " + moduleClassName + " unknown error", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded: " + this.getModuleInfoRegistry().size() + " of " + serviceClasses.size() + " detected modules");
        }
    }

    protected void unloadModules() {
        int moduleCount = this.getModuleInfoRegistry().size();
        this.getModuleInfoRegistry().unregisterAll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unloaded: " + moduleCount + " modules");
        }
    }

    protected boolean isClassAtlasModule(Class<?> clazz, Class<?> moduleInterface) {
        if (clazz == null) {
            return false;
        }
        if (this.isAtlasModuleInterface(clazz, moduleInterface) && clazz.isAnnotationPresent(AtlasModuleDetail.class)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(clazz.getCanonicalName() + " is a '" + moduleInterface.getSimpleName() + "' implementation");
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(clazz.getCanonicalName() + " is NOT a '" + moduleInterface.getSimpleName() + "' implementation");
        }
        return false;
    }

    protected boolean isAtlasModuleInterface(Class<?> clazz, Class<?> moduleInterface) {
        Class<?>[] interfaces;
        if (clazz == null) {
            return false;
        }
        boolean isIface = false;
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            isIface = this.isAtlasModuleInterface(superClazz, moduleInterface);
        }
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            if (!iface.equals(moduleInterface)) continue;
            isIface = true;
        }
        return isIface;
    }

    protected String getModuleUri(Class<?> clazz) {
        AtlasModuleDetail detail = clazz.getAnnotation(AtlasModuleDetail.class);
        if (detail != null) {
            return detail.uri();
        }
        return "UNDEFINED";
    }

    protected String getModuleName(Class<?> clazz) {
        AtlasModuleDetail detail = clazz.getAnnotation(AtlasModuleDetail.class);
        if (detail != null) {
            return detail.name();
        }
        return "UNDEFINED-" + UUID.randomUUID().toString();
    }

    protected List<String> getSupportedDataFormats(Class<?> clazz) {
        ArrayList<String> dataFormats = null;
        AtlasModuleDetail detail = clazz.getAnnotation(AtlasModuleDetail.class);
        if (detail != null) {
            String[] formats;
            dataFormats = new ArrayList<String>();
            for (String format : formats = detail.dataFormats()) {
                dataFormats.add(format.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Module: " + clazz.getCanonicalName() + " supports data formats: " + ((Object)dataFormats).toString());
        }
        return dataFormats;
    }

    protected List<String> getConfigPackages(Class<?> clazz) {
        ArrayList<String> configPackages = null;
        AtlasModuleDetail detail = clazz.getAnnotation(AtlasModuleDetail.class);
        if (detail != null) {
            String[] packages;
            configPackages = new ArrayList<String>();
            for (String pkg : packages = detail.configPackages()) {
                configPackages.add(pkg.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Module: " + clazz.getCanonicalName() + " config packages: " + ((Object)configPackages).toString());
        }
        return configPackages;
    }

    protected List<String> getAllModuleConfigPackages(AtlasModuleInfoRegistry registry) {
        ArrayList<String> pkgs = new ArrayList<String>();
        for (AtlasModuleInfo moduleInfo : registry.getAll()) {
            pkgs.addAll(Arrays.asList(moduleInfo.getPackageNames()));
        }
        return pkgs;
    }

    protected void registerFactoryJmx(DefaultAtlasContextFactory factory) {
        try {
            this.setObjectName(factory.uuid);
            ManagementFactory.getPlatformMBeanServer().registerMBean(factory, factory.getJmxObjectName());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registered AtlasContextFactory with JMX");
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to resgister DefaultAtlasContextFactory with JMX", (Throwable)e);
        }
    }

    protected void setObjectName(String name) throws MalformedObjectNameException {
        String objectName = String.format("io.atlasmap:type=AtlasServiceFactory,factoryUuid=%s", this.getUuid());
        this.objectName = new ObjectName(objectName);
    }

    protected static DefaultAtlasContextFactory getFactory() {
        return factory;
    }
}

