/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.DateFieldActions;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.AddDays;
import io.atlasmap.v2.AddSeconds;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.junit.Assert;
import org.junit.Test;

public class DateFieldActionsTest {
    @Test
    public void testAddDays() {
        AddDays action = new AddDays();
        action.setDays(Integer.valueOf(2));
        Assert.assertNull((Object)DateFieldActions.addDays((Action)action, null));
        ZonedDateTime origDate = ZonedDateTime.now();
        ZonedDateTime laterDate = origDate.plusDays(2L);
        Assert.assertEquals((Object)laterDate, (Object)DateFieldActions.addDays((Action)action, (ZonedDateTime)origDate));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddDaysWithNullAction() {
        DateFieldActions.addDays(null, (ZonedDateTime)ZonedDateTime.now());
    }

    @Test
    public void testAddSeconds() {
        AddSeconds action = new AddSeconds();
        action.setSeconds(Integer.valueOf(2));
        Assert.assertNull((Object)DateFieldActions.addSeconds((Action)action, null));
        ZonedDateTime origDate = ZonedDateTime.now();
        ZonedDateTime laterDate = origDate.plusSeconds(2L);
        Assert.assertEquals((Object)laterDate, (Object)DateFieldActions.addSeconds((Action)action, (ZonedDateTime)origDate));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSecondsWithNullAction() {
        DateFieldActions.addSeconds(null, (ZonedDateTime)ZonedDateTime.now());
    }

    @Test
    public void testCurrentDate() {
        Assert.assertNotNull((Object)DateFieldActions.currentDate(null, null));
    }

    @Test
    public void testCurrentDateTime() {
        Assert.assertNotNull((Object)DateFieldActions.currentDateTime(null, null));
    }

    @Test
    public void testCurrentTime() {
        Assert.assertNotNull((Object)DateFieldActions.currentTime(null, null));
    }

    @Test
    public void testDayOfWeek() {
        Assert.assertNull((Object)DateFieldActions.dayOfWeek(null, null));
        ZonedDateTime origDate = LocalDate.of(2017, 12, 14).atStartOfDay(ZoneId.systemDefault());
        Assert.assertEquals((Object)4, (Object)DateFieldActions.dayOfWeek(null, (ZonedDateTime)origDate));
    }

    @Test
    public void testDayOfYear() {
        Assert.assertNull((Object)DateFieldActions.dayOfYear(null, null));
        ZonedDateTime origDate = LocalDate.of(2017, 12, 31).atStartOfDay(ZoneId.systemDefault());
        Assert.assertEquals((Object)365, (Object)DateFieldActions.dayOfYear(null, (ZonedDateTime)origDate));
    }
}

