/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.NumberFieldActions;
import io.atlasmap.v2.AbsoluteValue;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.Add;
import io.atlasmap.v2.AreaUnitType;
import io.atlasmap.v2.Average;
import io.atlasmap.v2.Ceiling;
import io.atlasmap.v2.ConvertAreaUnit;
import io.atlasmap.v2.ConvertDistanceUnit;
import io.atlasmap.v2.ConvertMassUnit;
import io.atlasmap.v2.ConvertVolumeUnit;
import io.atlasmap.v2.DistanceUnitType;
import io.atlasmap.v2.Divide;
import io.atlasmap.v2.Floor;
import io.atlasmap.v2.MassUnitType;
import io.atlasmap.v2.Maximum;
import io.atlasmap.v2.Minimum;
import io.atlasmap.v2.Multiply;
import io.atlasmap.v2.Round;
import io.atlasmap.v2.Subtract;
import io.atlasmap.v2.VolumeUnitType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;

public class NumberFieldActionsTest {
    @Test
    public void testAbsoluteValue() {
        Assert.assertEquals((Object)0, (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), null));
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), (Number)BigDecimal.valueOf(-1L)));
        Assert.assertEquals((Object)1.0, (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), (Number)-1.0));
        Assert.assertEquals((Object)1.0, (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), (Number)Float.valueOf(-1.0f)));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), (Number)new AtomicLong(-1L)));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), (Number)-1L));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), (Number)new AtomicInteger(-1)));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), (Number)-1));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.absoluteValue((Action)new AbsoluteValue(), (Number)-1));
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((Object)BigDecimal.valueOf(10.0), (Object)NumberFieldActions.add((Action)new Add(), (Object)new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)}));
        Assert.assertEquals((Object)10.0, (Object)NumberFieldActions.add((Action)new Add(), (Object)new double[]{1.0, 2.0, 3.0, 4.0}));
        Assert.assertEquals((Object)10L, (Object)NumberFieldActions.add((Action)new Add(), (Object)new int[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)10L, (Object)NumberFieldActions.add((Action)new Add(), Arrays.asList(1, 2, 3, 4)));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 1);
        map.put("2", 2);
        map.put("3", 3);
        map.put("4", 4);
        Assert.assertEquals((Object)10L, (Object)NumberFieldActions.add((Action)new Add(), map));
        Assert.assertEquals((Object)0, (Object)NumberFieldActions.add((Action)new Add(), null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddOfNonNumber() {
        NumberFieldActions.add((Action)new Add(), Arrays.asList("1", "2", "3"));
    }

    @Test
    public void testAverage() {
        Assert.assertEquals((Object)2.5, (Object)NumberFieldActions.average((Action)new Average(), (Object)new double[]{1.0, 2.0, 3.0, 4.0}));
        Assert.assertEquals((Object)2.5, (Object)NumberFieldActions.average((Action)new Average(), (Object)new int[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)2.5, (Object)NumberFieldActions.average((Action)new Average(), Arrays.asList(1, 2, 3, 4)));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 1);
        map.put("2", 2);
        map.put("3", 3);
        map.put("4", 4);
        Assert.assertEquals((Object)2.5, (Object)NumberFieldActions.average((Action)new Average(), map));
        Assert.assertEquals((Object)0, (Object)NumberFieldActions.average((Action)new Average(), null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAverageOfNonNumber() {
        NumberFieldActions.average((Action)new AbsoluteValue(), Arrays.asList("1", "2", "3"));
    }

    @Test
    public void testCeiling() {
        Assert.assertEquals((Object)0L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), null));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), (Number)BigDecimal.valueOf(1.1)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), (Number)1.1));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), (Number)Float.valueOf(1.1f)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), (Number)new AtomicLong(2L)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), (Number)2L));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), (Number)new AtomicInteger(2)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), (Number)2));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.ceiling((Action)new Ceiling(), (Number)2));
    }

    @Test
    public void testConvertAreaUnit() {
        ConvertAreaUnit action = new ConvertAreaUnit();
        action.setFromUnit(AreaUnitType.SQUARE_METER);
        action.setToUnit(AreaUnitType.SQUARE_METER);
        Assert.assertEquals((Object)1.0, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)1.0));
        action.setToUnit(AreaUnitType.SQUARE_FOOT);
        Assert.assertEquals((Object)21.527820833419447, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)2.0));
        action.setToUnit(AreaUnitType.SQUARE_MILE);
        Assert.assertEquals((Object)1.1583064756273378, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)3000000.0));
        action.setFromUnit(AreaUnitType.SQUARE_FOOT);
        action.setToUnit(AreaUnitType.SQUARE_METER);
        Assert.assertEquals((Object)3.7161215999999997, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)40.0));
        action.setToUnit(AreaUnitType.SQUARE_FOOT);
        Assert.assertEquals((Object)5.0, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)5.0));
        action.setToUnit(AreaUnitType.SQUARE_MILE);
        Assert.assertEquals((Object)2.1522038567493116, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)6.0E7));
        action.setFromUnit(AreaUnitType.SQUARE_MILE);
        action.setToUnit(AreaUnitType.SQUARE_METER);
        Assert.assertEquals((Object)1.8129916772352E7, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)7.0));
        action.setToUnit(AreaUnitType.SQUARE_FOOT);
        Assert.assertEquals((Object)2.230272E8, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)8.0));
        action.setToUnit(AreaUnitType.SQUARE_MILE);
        Assert.assertEquals((Object)9.0, (Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)9.0));
        Assert.assertNotNull((Object)NumberFieldActions.convertAreaUnit((Action)action, (Number)new BigDecimal("9")));
    }

    @Test
    public void testConvertDistanceUnit() {
        ConvertDistanceUnit action = new ConvertDistanceUnit();
        action.setFromUnit(DistanceUnitType.METER);
        action.setToUnit(DistanceUnitType.METER);
        Assert.assertEquals((Object)1.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)1.0));
        action.setToUnit(DistanceUnitType.FOOT);
        Assert.assertEquals((Object)6.561679790026247, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)2.0));
        action.setToUnit(DistanceUnitType.YARD);
        Assert.assertEquals((Object)3.2808398950131235, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)3.0));
        action.setToUnit(DistanceUnitType.MILE);
        Assert.assertEquals((Object)2.4854847689493362, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)4000.0));
        action.setToUnit(DistanceUnitType.INCH);
        Assert.assertEquals((Object)196.8503937007874, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)5.0));
        action.setFromUnit(DistanceUnitType.FOOT);
        action.setToUnit(DistanceUnitType.METER);
        Assert.assertEquals((Object)1.8287999999999998, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)6.0));
        action.setToUnit(DistanceUnitType.FOOT);
        Assert.assertEquals((Object)7.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)7.0));
        action.setToUnit(DistanceUnitType.YARD);
        Assert.assertEquals((Object)27.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)81.0));
        action.setToUnit(DistanceUnitType.MILE);
        Assert.assertEquals((Object)1.7045454545454546, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)9000.0));
        action.setToUnit(DistanceUnitType.INCH);
        Assert.assertEquals((Object)12.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)1.0));
        action.setFromUnit(DistanceUnitType.YARD);
        action.setToUnit(DistanceUnitType.METER);
        Assert.assertEquals((Object)22.86, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)25.0));
        action.setToUnit(DistanceUnitType.FOOT);
        Assert.assertEquals((Object)9.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)3.0));
        action.setToUnit(DistanceUnitType.YARD);
        Assert.assertEquals((Object)4.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)4.0));
        action.setToUnit(DistanceUnitType.MILE);
        Assert.assertEquals((Object)2.840909090909091, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)5000.0));
        action.setToUnit(DistanceUnitType.INCH);
        Assert.assertEquals((Object)216.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)6.0));
        action.setFromUnit(DistanceUnitType.MILE);
        action.setToUnit(DistanceUnitType.METER);
        Assert.assertEquals((Object)11265.408, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)7.0));
        action.setToUnit(DistanceUnitType.FOOT);
        Assert.assertEquals((Object)42240.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)8.0));
        action.setToUnit(DistanceUnitType.YARD);
        Assert.assertEquals((Object)15840.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)9.0));
        action.setToUnit(DistanceUnitType.MILE);
        Assert.assertEquals((Object)1.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)1.0));
        action.setToUnit(DistanceUnitType.INCH);
        Assert.assertEquals((Object)126720.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)2.0));
        action.setFromUnit(DistanceUnitType.INCH);
        action.setToUnit(DistanceUnitType.METER);
        Assert.assertEquals((Object)7.62, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)300.0));
        action.setToUnit(DistanceUnitType.FOOT);
        Assert.assertEquals((Object)3.5, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)42.0));
        action.setToUnit(DistanceUnitType.YARD);
        Assert.assertEquals((Object)1.5, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)54.0));
        action.setToUnit(DistanceUnitType.MILE);
        Assert.assertEquals((Object)9.469696969696969, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)600000.0));
        action.setToUnit(DistanceUnitType.INCH);
        Assert.assertEquals((Object)6.0, (Object)NumberFieldActions.convertDistanceUnit((Action)action, (Number)6.0));
    }

    @Test
    public void testConvertMassUnit() {
        ConvertMassUnit action = new ConvertMassUnit();
        action.setFromUnit(MassUnitType.KILO_GRAM);
        action.setToUnit(MassUnitType.POUND);
        Assert.assertEquals((long)11L, (long)NumberFieldActions.convertMassUnit((Action)action, (Number)5).intValue());
        action.setFromUnit(MassUnitType.POUND);
        action.setToUnit(MassUnitType.KILO_GRAM);
        Assert.assertEquals((float)4.5359235f, (float)NumberFieldActions.convertMassUnit((Action)action, (Number)Float.valueOf(10.0f)).floatValue(), (float)0.0f);
        Assert.assertEquals((long)0L, (long)NumberFieldActions.convertMassUnit((Action)action, null).intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertMassUnitErrorNoFromNorToSpecified() {
        ConvertMassUnit action = new ConvertMassUnit();
        Assert.assertEquals((Object)11, (Object)NumberFieldActions.convertMassUnit((Action)action, (Number)5));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertMassUnitErrorNoFromSpecified() {
        ConvertMassUnit action = new ConvertMassUnit();
        action.setToUnit(MassUnitType.POUND);
        Assert.assertEquals((Object)11, (Object)NumberFieldActions.convertMassUnit((Action)action, (Number)5));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertMassUnitErrorNoToSpecified() {
        ConvertMassUnit action = new ConvertMassUnit();
        action.setFromUnit(MassUnitType.KILO_GRAM);
        Assert.assertEquals((Object)11, (Object)NumberFieldActions.convertMassUnit((Action)action, (Number)5));
    }

    @Test
    public void testConvertVolumeUnit() {
        ConvertVolumeUnit action = new ConvertVolumeUnit();
        action.setFromUnit(VolumeUnitType.CUBIC_METER);
        action.setToUnit(VolumeUnitType.CUBIC_METER);
        Assert.assertEquals((Object)1.0, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)1.0));
        action.setToUnit(VolumeUnitType.LITTER);
        Assert.assertEquals((Object)2000.0, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)2.0));
        action.setToUnit(VolumeUnitType.CUBIC_FOOT);
        Assert.assertEquals((Object)105.94400016446578, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)3.0));
        action.setToUnit(VolumeUnitType.GALLON_US_FLUID);
        Assert.assertEquals((Object)1056.68820944, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)4.0));
        action.setFromUnit(VolumeUnitType.LITTER);
        action.setToUnit(VolumeUnitType.CUBIC_METER);
        Assert.assertEquals((Object)5.0, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)5000.0));
        action.setToUnit(VolumeUnitType.LITTER);
        Assert.assertEquals((Object)6.0, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)6.0));
        action.setToUnit(VolumeUnitType.CUBIC_FOOT);
        Assert.assertEquals((Object)2.4720266705042016, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)70.0));
        action.setToUnit(VolumeUnitType.GALLON_US_FLUID);
        Assert.assertEquals((Object)2.11337641888, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)8.0));
        action.setFromUnit(VolumeUnitType.CUBIC_FOOT);
        action.setToUnit(VolumeUnitType.CUBIC_METER);
        Assert.assertEquals((Object)2.54851619328, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)90.0));
        action.setToUnit(VolumeUnitType.LITTER);
        Assert.assertEquals((Object)28.316846591999997, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)1.0));
        action.setToUnit(VolumeUnitType.CUBIC_FOOT);
        Assert.assertEquals((Object)2.0, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)2.0));
        action.setToUnit(VolumeUnitType.GALLON_US_FLUID);
        Assert.assertEquals((Object)22.441558441715735, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)3.0));
        action.setFromUnit(VolumeUnitType.GALLON_US_FLUID);
        action.setToUnit(VolumeUnitType.CUBIC_METER);
        Assert.assertEquals((Object)1.5141647135893872, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)400.0));
        action.setToUnit(VolumeUnitType.LITTER);
        Assert.assertEquals((Object)18.92705891986734, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)5.0));
        action.setToUnit(VolumeUnitType.CUBIC_FOOT);
        Assert.assertEquals((Object)8.020833333277116, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)60.0));
        action.setToUnit(VolumeUnitType.GALLON_US_FLUID);
        Assert.assertEquals((Object)7.0, (Object)NumberFieldActions.convertVolumeUnit((Action)action, (Number)7.0));
    }

    @Test
    public void testDivide() {
        Assert.assertEquals((Object)BigDecimal.valueOf(2L), (Object)NumberFieldActions.divide((Action)new Divide(), (Object)new BigDecimal[]{BigDecimal.valueOf(4L), BigDecimal.valueOf(2L)}));
        Assert.assertEquals((Object)2.0, (Object)NumberFieldActions.divide((Action)new Divide(), (Object)new double[]{4.0, 2.0}));
        Assert.assertEquals((Object)2.0, (Object)NumberFieldActions.divide((Action)new Divide(), (Object)new int[]{4, 2}));
        Assert.assertEquals((Object)2.0, (Object)NumberFieldActions.divide((Action)new Divide(), Arrays.asList(4, 2)));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("4", 1);
        map.put("2", 2);
        Assert.assertEquals((Object)2.0, (Object)NumberFieldActions.divide((Action)new Divide(), map));
        Assert.assertEquals((Object)0, (Object)NumberFieldActions.divide((Action)new Divide(), null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivideOfNonNumber() {
        NumberFieldActions.divide((Action)new Divide(), Arrays.asList("1", "2", "3"));
    }

    @Test
    public void testFloor() {
        Assert.assertEquals((Object)0L, (Object)NumberFieldActions.floor((Action)new Floor(), null));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.floor((Action)new Floor(), (Number)BigDecimal.valueOf(1.5)));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.floor((Action)new Floor(), (Number)1.5));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.floor((Action)new Floor(), (Number)Float.valueOf(1.5f)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Action)new Floor(), (Number)new AtomicLong(2L)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Action)new Floor(), (Number)2L));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Action)new Floor(), (Number)new AtomicInteger(2)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Action)new Floor(), (Number)2));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.floor((Action)new Floor(), (Number)2));
    }

    @Test
    public void testMaximum() {
        Assert.assertEquals((Object)BigDecimal.valueOf(4L), (Object)NumberFieldActions.maximum((Action)new Maximum(), (Object)new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)}));
        Assert.assertEquals((Object)4.0, (Object)NumberFieldActions.maximum((Action)new Maximum(), (Object)new double[]{1.0, 2.0, 3.0, 4.0}));
        Assert.assertEquals((Object)4, (Object)NumberFieldActions.maximum((Action)new Maximum(), (Object)new int[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)4, (Object)NumberFieldActions.maximum((Action)new Maximum(), Arrays.asList(1, 2, 3, 4)));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 1);
        map.put("2", 2);
        map.put("3", 3);
        map.put("4", 4);
        Assert.assertEquals((Object)4, (Object)NumberFieldActions.maximum((Action)new Maximum(), map));
        Assert.assertEquals((Object)BigDecimal.valueOf(4L), (Object)NumberFieldActions.maximum((Action)new Maximum(), Arrays.asList((byte)1, 2, 3.0, BigDecimal.valueOf(4L))));
        Assert.assertEquals((Object)0, (Object)NumberFieldActions.maximum((Action)new Maximum(), null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaximumOfNonNumber() {
        NumberFieldActions.maximum((Action)new Maximum(), Arrays.asList("1", "2", "3"));
    }

    @Test
    public void testMinimum() {
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)NumberFieldActions.minimum((Action)new Minimum(), (Object)new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)}));
        Assert.assertEquals((Object)1.0, (Object)NumberFieldActions.minimum((Action)new Minimum(), (Object)new double[]{1.0, 2.0, 3.0, 4.0}));
        Assert.assertEquals((Object)1, (Object)NumberFieldActions.minimum((Action)new Minimum(), (Object)new int[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)1, (Object)NumberFieldActions.minimum((Action)new Minimum(), Arrays.asList(1, 2, 3, 4)));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 1);
        map.put("2", 2);
        map.put("3", 3);
        map.put("4", 4);
        Assert.assertEquals((Object)1, (Object)NumberFieldActions.minimum((Action)new Minimum(), map));
        Assert.assertEquals((Object)1, (Object)NumberFieldActions.minimum((Action)new Minimum(), Arrays.asList((byte)1, 2, 3.0, BigDecimal.valueOf(4L))));
        Assert.assertEquals((Object)0, (Object)NumberFieldActions.minimum((Action)new Minimum(), null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinimumOfNonNumber() {
        NumberFieldActions.minimum((Action)new Minimum(), Arrays.asList("1", "2", "3"));
    }

    @Test
    public void testRound() {
        Assert.assertEquals((Object)0L, (Object)NumberFieldActions.round((Action)new Round(), null));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.round((Action)new Round(), (Number)BigDecimal.valueOf(1.5)));
        Assert.assertEquals((Object)1L, (Object)NumberFieldActions.round((Action)new Round(), (Number)1.4));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.round((Action)new Round(), (Number)Float.valueOf(1.5f)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.round((Action)new Round(), (Number)new AtomicLong(2L)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.round((Action)new Round(), (Number)2L));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.round((Action)new Round(), (Number)new AtomicInteger(2)));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.round((Action)new Round(), (Number)2));
        Assert.assertEquals((Object)2L, (Object)NumberFieldActions.round((Action)new Round(), (Number)2));
    }

    @Test
    public void testSubtract() {
        Assert.assertEquals((Object)BigDecimal.valueOf(-8.0), (Object)NumberFieldActions.subtract((Action)new Subtract(), (Object)new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)}));
        Assert.assertEquals((Object)-8.0, (Object)NumberFieldActions.subtract((Action)new Subtract(), (Object)new double[]{1.0, 2.0, 3.0, 4.0}));
        Assert.assertEquals((Object)-8L, (Object)NumberFieldActions.subtract((Action)new Subtract(), (Object)new int[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)-8L, (Object)NumberFieldActions.subtract((Action)new Subtract(), Arrays.asList(1, 2, 3, 4)));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 1);
        map.put("2", 2);
        map.put("3", 3);
        map.put("4", 4);
        Assert.assertEquals((Object)-8L, (Object)NumberFieldActions.subtract((Action)new Subtract(), map));
        Assert.assertEquals((Object)0, (Object)NumberFieldActions.subtract((Action)new Subtract(), null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubtractOfNonNumber() {
        NumberFieldActions.subtract((Action)new Subtract(), Arrays.asList("1", "2", "3"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertMassUnitIllegalArgumentException() {
        Assert.assertEquals((long)11L, (long)NumberFieldActions.convertMassUnit((Action)new Add(), (Number)5).intValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertDistanceUnitIllegalArgumentException() {
        Assert.assertEquals((long)0L, (long)NumberFieldActions.convertDistanceUnit((Action)new Add(), null).intValue());
        NumberFieldActions.convertDistanceUnit((Action)new Add(), (Number)5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertAreaUnitIllegalArgumentException() {
        Assert.assertEquals((long)0L, (long)NumberFieldActions.convertAreaUnit((Action)new Add(), null).intValue());
        NumberFieldActions.convertAreaUnit((Action)new Add(), (Number)5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertVolumeUnitIllegalArgumentException() {
        Assert.assertEquals((long)0L, (long)NumberFieldActions.convertVolumeUnit((Action)new Add(), null).intValue());
        NumberFieldActions.convertVolumeUnit((Action)new Add(), (Number)5);
    }

    @Test
    public void testMultiply() {
        Assert.assertNotNull((Object)new NumberFieldActions());
        Assert.assertEquals((Object)0, (Object)NumberFieldActions.multiply((Action)new Multiply(), null));
        Assert.assertEquals((Object)new BigDecimal("24.0000"), (Object)NumberFieldActions.multiply((Action)new Add(), (Object)new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), BigDecimal.valueOf(3L), BigDecimal.valueOf(4L)}));
        Assert.assertEquals((Object)24.0, (Object)NumberFieldActions.multiply((Action)new Multiply(), (Object)new double[]{1.0, 2.0, 3.0, 4.0}));
        Assert.assertEquals((Object)24.0, (Object)NumberFieldActions.multiply((Action)new Multiply(), (Object)new float[]{1.0f, 2.0f, 3.0f, 4.0f}));
        Assert.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Action)new Multiply(), (Object)new int[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Action)new Multiply(), (Object)new byte[]{1, 2, 3, 4}));
        Assert.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Action)new Multiply(), (Object)new long[]{1L, 2L, 3L, 4L}));
        Assert.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Action)new Multiply(), Arrays.asList(1, 2, 3, 4)));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 1);
        map.put("2", 2);
        map.put("3", 3);
        map.put("4", 4);
        Assert.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Action)new Multiply(), map));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiplyIllegalArgumentException() {
        Assert.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Action)new Multiply(), Arrays.asList("a", "b")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiplyIllegalArgumentExceptionCollection() {
        Assert.assertEquals((Object)24L, (Object)NumberFieldActions.multiply((Action)new Multiply(), (Object)new Object()));
    }
}

