/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.ObjectFieldActions;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.Contains;
import io.atlasmap.v2.Equals;
import io.atlasmap.v2.Length;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ObjectFieldActionsTest {
    @Test
    public void testContains() {
        Contains action = new Contains();
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, null));
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Action)action, (Object)""));
        Object[] array = new Object[]{false, "foo", 2};
        Object[] arrayWithNull = new Object[]{false, null, "foo", 2};
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Action)action, (Object)array));
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, (Object)arrayWithNull));
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Action)action, Arrays.asList(array)));
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, Arrays.asList(arrayWithNull)));
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object obj : array) {
            map.put("key-" + obj, obj);
        }
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Action)action, map));
        for (Object obj : arrayWithNull) {
            map.put("key-" + obj, obj);
        }
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, map));
        action.setValue("foo");
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Action)action, null));
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Action)action, (Object)""));
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, (Object)"foobar"));
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, (Object)array));
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, Arrays.asList(array)));
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, map));
        action.setValue("key-foo");
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, map));
        action.setValue("6");
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, (Object)169));
        action.setValue("ru");
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Action)action, (Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContainsWithNullAction() {
        ObjectFieldActions.contains(null, (Object)"");
    }

    @Test
    public void testEquals() {
        Equals action = new Equals();
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Action)action, null));
        Object[] array = new Object[]{false, null, "foo", 2};
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, (Object)array));
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, Arrays.asList(array)));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Object obj : array) {
            map.put("key-" + obj, obj);
        }
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, map));
        System.out.println(Arrays.asList(array));
        action.setValue("[false, null, foo, 2]");
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Action)action, (Object)array));
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Action)action, Arrays.asList(array)));
        action.setValue("{key-false=false, key-null=null, key-foo=foo, key-2=2}");
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Action)action, map));
        action.setValue("foo");
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, null));
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, (Object)""));
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, (Object)"foobar"));
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Action)action, (Object)"foo"));
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, (Object)array));
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, Arrays.asList(array)));
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, map));
        action.setValue("6");
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, (Object)169));
        action.setValue("169");
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Action)action, (Object)169));
        action.setValue("ru");
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, (Object)true));
        action.setValue("true");
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Action)action, (Object)true));
        action.setValue("b");
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Action)action, (Object)Character.valueOf('a')));
        action.setValue("a");
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Action)action, (Object)Character.valueOf('a')));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEqualsWithNullAction() {
        ObjectFieldActions.equals(null, (Object)"");
    }

    @Test
    public void testIsNull() {
        Assert.assertTrue((boolean)ObjectFieldActions.isNull(null, null));
        Assert.assertFalse((boolean)ObjectFieldActions.isNull(null, (Object)""));
        Assert.assertFalse((boolean)ObjectFieldActions.isNull(null, (Object)new Object[0]));
    }

    @Test
    public void testLength() {
        Assert.assertEquals((Object)new Integer(-1), (Object)ObjectFieldActions.length((Action)new Length(), null));
        Assert.assertEquals((Object)new Integer(0), (Object)ObjectFieldActions.length((Action)new Length(), (Object)""));
        Assert.assertEquals((Object)new Integer(5), (Object)ObjectFieldActions.length((Action)new Length(), (Object)" foo "));
        Assert.assertEquals((Object)new Integer(4), (Object)ObjectFieldActions.length((Action)new Length(), (Object)true));
        Assert.assertEquals((Object)new Integer(3), (Object)ObjectFieldActions.length((Action)new Length(), (Object)169));
        Assert.assertEquals((Object)new Integer(0), (Object)ObjectFieldActions.length((Action)new Length(), (Object)new Boolean[0]));
        Assert.assertEquals((Object)new Integer(0), (Object)ObjectFieldActions.length((Action)new Length(), new ArrayList()));
        Assert.assertEquals((Object)new Integer(0), (Object)ObjectFieldActions.length((Action)new Length(), new HashMap()));
        Object[] array = new Object[]{false, "foo", 2};
        Assert.assertEquals((Object)new Integer(3), (Object)ObjectFieldActions.length((Action)new Length(), (Object)array));
        Assert.assertEquals((Object)new Integer(3), (Object)ObjectFieldActions.length((Action)new Length(), Arrays.asList(array)));
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object obj : array) {
            map.put(obj, obj);
        }
        Assert.assertEquals((Object)new Integer(3), (Object)ObjectFieldActions.length((Action)new Length(), map));
    }
}

