/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.converters.ByteConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class ByteConverterTest {
    private static final byte DEFAULT_VALUE = 100;
    private ByteConverter byteConverter = new ByteConverter();

    @Test
    public void convertToBoolean() {
        Assert.assertTrue((boolean)this.byteConverter.toBoolean(new Byte(1)));
        Assert.assertFalse((boolean)this.byteConverter.toBoolean(new Byte(0)));
        Assert.assertTrue((boolean)this.byteConverter.toBoolean(Byte.valueOf((byte)127)));
    }

    @Test
    public void convertToBooleanNull() {
        Assert.assertNull((Object)this.byteConverter.toBoolean(null));
    }

    @Test
    public void convertToByte() {
        this.byteConverter.toByte(Byte.valueOf((byte)127));
    }

    @Test
    public void convertToByteNull() {
        Assert.assertNull((Object)this.byteConverter.toByte(null));
    }

    @Test
    public void convertToCharacter() {
        byte value = 0;
        Assert.assertEquals((long)0L, (long)this.byteConverter.toCharacter(new Byte(value)).charValue());
        value = 99;
        Assert.assertEquals((long)99L, (long)this.byteConverter.toCharacter(new Byte(value)).charValue());
    }

    @Test
    public void convertToCharacterNull() {
        Assert.assertNull((Object)this.byteConverter.toCharacter(null));
    }

    @Test
    public void convertToDouble() {
        Assert.assertEquals((double)100.0, (double)this.byteConverter.toDouble(Byte.valueOf((byte)100)), (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Assert.assertNull((Object)this.byteConverter.toDouble(null));
    }

    @Test
    public void convertToFloat() {
        Assert.assertEquals((float)100.0f, (float)this.byteConverter.toFloat(Byte.valueOf((byte)100)).floatValue(), (float)0.0f);
    }

    @Test
    public void convertToFloatNull() {
        Assert.assertNull((Object)this.byteConverter.toFloat(null));
    }

    @Test
    public void convertToInteger() {
        Assert.assertEquals((long)100L, (long)this.byteConverter.toInteger(Byte.valueOf((byte)100)).intValue());
    }

    @Test
    public void convertToIntegerNull() {
        Assert.assertNull((Object)this.byteConverter.toInteger(null));
    }

    @Test
    public void convertToLong() {
        Assert.assertEquals((long)100L, (long)this.byteConverter.toLong(Byte.valueOf((byte)100)));
    }

    @Test
    public void convertToLongNull() {
        Assert.assertNull((Object)this.byteConverter.toLong(null));
    }

    @Test
    public void convertToShort() {
        Assert.assertEquals((long)100L, (long)this.byteConverter.toShort(Byte.valueOf((byte)100)).shortValue());
    }

    @Test
    public void convertToIShortNull() {
        Assert.assertNull((Object)this.byteConverter.toShort(null));
    }

    @Test
    public void convertToString() throws Exception {
        Assert.assertEquals((Object)this.byteConverter.toString(Byte.valueOf(Byte.parseByte("1"))), (Object)"1");
    }

    @Test
    public void convertToStringNull() {
        Assert.assertNull((Object)this.byteConverter.toString(null));
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<ByteConverter> aClass = ByteConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assert.assertNotNull((Object)annotations);
            Assert.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation : annotations) {
                Assert.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation;
                Assert.assertNotNull((Object)atlasConversionInfo.sourceType());
                Assert.assertTrue((atlasConversionInfo.sourceType().compareTo((Enum)FieldType.BYTE) == 0 ? 1 : 0) != 0);
                Assert.assertNotNull((Object)atlasConversionInfo.targetType());
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assert.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assert.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

