/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.Mappings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AtlasMappingServiceTest {
    private static AtlasMappingService atlasMappingService;
    private static AtlasMapping atlasMapping;

    @BeforeClass
    public static void setUpBeforeClass() {
        atlasMappingService = new AtlasMappingService();
        atlasMapping = new AtlasMapping();
        atlasMapping.setName("testname");
        Mappings mappings = new Mappings();
        Mapping mapping = new Mapping();
        mapping.setId("1");
        mapping.setAlias("alias1");
        mappings.getMapping().add(mapping);
        mapping = new Mapping();
        mapping.setId("2");
        mapping.setAlias("alias2");
        mappings.getMapping().add(mapping);
        atlasMapping.setMappings(mappings);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        atlasMappingService = null;
        atlasMapping = null;
    }

    @Test
    public void testAtlasMappingService() {
        Assert.assertNotNull((Object)atlasMappingService);
    }

    @Test
    public void testAtlasMappingServiceListOfString() {
        ArrayList<String> modulePackages = new ArrayList<String>();
        modulePackages.add("io.atlasmap.v2");
        atlasMappingService = new AtlasMappingService(modulePackages);
        Assert.assertNotNull((Object)atlasMappingService);
    }

    @Test(expected=Exception.class)
    public void testAtlasMappingServiceListOfStringException() {
        ArrayList<String> modulePackages = new ArrayList<String>();
        modulePackages.add("xio.atlasmap.v2");
        atlasMappingService = new AtlasMappingService(modulePackages);
    }

    @Test
    public void testInitialize() {
        ArrayList modulePackages = new ArrayList();
        atlasMappingService = new AtlasMappingService(modulePackages);
        Assert.assertNotNull((Object)atlasMappingService);
    }

    @Test(expected=IllegalStateException.class)
    public void testInitializeIllegalStateException() {
        ArrayList<String> modulePackages = new ArrayList<String>();
        modulePackages.add("xio.atlasmap.v2");
        modulePackages.add("yio.atlasmap.v2");
        atlasMappingService = new AtlasMappingService(modulePackages);
    }

    @Test(expected=IllegalStateException.class)
    public void testInitializeIllegalStateExceptionNull() {
        List modulePackages = null;
        new AtlasMappingService(modulePackages);
    }

    @Test
    public void testLoadMappingFile() throws AtlasValidationException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.xml", new String[0]).toFile();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(file);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingFileAtlasMappingFormat() throws AtlasValidationException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(file, AtlasMappingService.AtlasMappingFormat.JSON);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test(expected=AtlasValidationException.class)
    public void testLoadMappingFileAtlasMappingFormatAtlasValidationException() throws AtlasValidationException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping2.json", new String[0]).toFile();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(file, AtlasMappingService.AtlasMappingFormat.JSON);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingReader() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.xml"));
        AtlasMapping atlasMapping = atlasMappingService.loadMapping((Reader)reader);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingReaderAtlasMappingFormat() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json"));
        AtlasMapping atlasMapping = atlasMappingService.loadMapping((Reader)reader, AtlasMappingService.AtlasMappingFormat.JSON);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test(expected=AtlasValidationException.class)
    public void testLoadMappingReaderAtlasMappingFormatAtlasValidationException() throws Exception {
        Reader reader = null;
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(reader, AtlasMappingService.AtlasMappingFormat.JSON);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingStringAtlasMappingFormat() throws AtlasValidationException {
        String filename = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.xml";
        AtlasMappingService.AtlasMappingFormat format = AtlasMappingService.AtlasMappingFormat.XML;
        Assert.assertNotNull((Object)format.value());
        Assert.assertNotNull((Object)AtlasMappingService.AtlasMappingFormat.valueOf((String)"XML"));
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(filename, format);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingString() throws AtlasValidationException {
        String filename = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.xml";
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(filename);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingInputStream() throws Exception {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.xml", new String[0]).toFile();
        FileInputStream fis = new FileInputStream(file);
        AtlasMapping atlasMapping = atlasMappingService.loadMapping((InputStream)fis);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingURI() throws Exception {
        URI uri = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.xml", new String[0]).toUri();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(uri);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingURL() throws Exception {
        URL url = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.xml", new String[0]).toUri().toURL();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(url);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test(expected=AtlasValidationException.class)
    public void testLoadMappingURLAtlasMappingFormat() throws Exception {
        URL url = new URL("http://www.redhat.com/q/h?s=^IXIC");
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(url, AtlasMappingService.AtlasMappingFormat.XML);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testSaveMappingAsFileAtlasMappingFileAtlasMappingFormat() throws AtlasException {
        File file = Paths.get("target" + File.separator + "generated-test-sources" + File.separator + "atlasmapping.xml", new String[0]).toFile();
        atlasMappingService.saveMappingAsFile(atlasMapping, file);
        atlasMappingService.saveMappingAsFile(atlasMapping, file, AtlasMappingService.AtlasMappingFormat.XML);
        file = Paths.get("target" + File.separator + "generated-test-sources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        atlasMappingService.saveMappingAsFile(atlasMapping, file, AtlasMappingService.AtlasMappingFormat.JSON);
    }

    @Test
    public void testSetObjectMapper() {
        atlasMappingService.setObjectMapper(atlasMappingService.getObjectMapper());
    }

    @Test(expected=AtlasException.class)
    public void testSaveMappingAsJsonFile() throws AtlasException {
        AtlasMappingService atlasMappingService = new AtlasMappingService();
        atlasMappingService.setObjectMapper(null);
        File file = Paths.get("target" + File.separator + "generated-test-sources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        atlasMappingService.saveMappingAsJsonFile(atlasMapping, file);
    }

    @Test(expected=AtlasException.class)
    public void testSaveMappingAsXmlFile() throws Exception {
        AtlasMappingService atlasMappingService = new AtlasMappingService();
        atlasMappingService.setJAXBContext(JAXBContext.newInstance((Class[])new Class[0]));
        File file = Paths.get("target" + File.separator + "generated-test-sources" + File.separator + "atlasmapping.xml", new String[0]).toFile();
        atlasMappingService.saveMappingAsXmlFile(atlasMapping, file);
    }
}

