/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.v2.AtlasMapping;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class AtlasMappingUtil {
    private static JAXBContext jaxbContext;

    public AtlasMappingUtil(String packages) {
        try {
            jaxbContext = JAXBContext.newInstance((String)packages);
        }
        catch (JAXBException e) {
            System.err.print(e.getMessage());
        }
    }

    public AtlasMapping loadMapping(String fileName) throws Exception {
        AtlasMapping mapping = null;
        if (jaxbContext != null) {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Path newFilePath = Paths.get(fileName, new String[0]);
            mapping = (AtlasMapping)((JAXBElement)unmarshaller.unmarshal(newFilePath.toFile())).getValue();
        }
        return mapping;
    }

    public void marshallMapping(AtlasMapping mapping, String fileName) throws Exception {
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        Path newFilePath = Paths.get(fileName, new String[0]);
        Files.deleteIfExists(newFilePath);
        Path file = Files.createFile(newFilePath, new FileAttribute[0]);
        marshaller.marshal((Object)mapping, file.toFile());
    }
}

