/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasPath;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AtlasPathTest {
    @Test
    public void testOneClass() {
        AtlasPath foo = new AtlasPath("");
        foo.appendField("user");
        Assert.assertEquals((Object)"user", (Object)foo.toString());
    }

    @Test
    public void testFields() {
        AtlasPath foo = new AtlasPath("");
        foo.appendField("user").appendField("name");
        Assert.assertEquals((Object)"/user/name", (Object)foo.toString());
        foo.appendField("bar");
        Assert.assertEquals((Object)"/user/name/bar", (Object)foo.toString());
    }

    @Test
    public void testCleanPathSegment() {
        Assert.assertNull((Object)AtlasPath.cleanPathSegment(null));
        Assert.assertEquals((Object)"", (Object)AtlasPath.cleanPathSegment((String)""));
        Assert.assertEquals((Object)"foo", (Object)AtlasPath.cleanPathSegment((String)"foo"));
        Assert.assertEquals((Object)"foo", (Object)AtlasPath.cleanPathSegment((String)"foo[]"));
        Assert.assertEquals((Object)"foo", (Object)AtlasPath.cleanPathSegment((String)"foo<>"));
        Assert.assertEquals((Object)"foo", (Object)AtlasPath.cleanPathSegment((String)"foo{}"));
        Assert.assertEquals((Object)"foo", (Object)AtlasPath.cleanPathSegment((String)"foo"));
        Assert.assertEquals((Object)"foo", (Object)AtlasPath.cleanPathSegment((String)"foo[0]"));
        Assert.assertEquals((Object)"foo", (Object)AtlasPath.cleanPathSegment((String)"foo<1234>"));
        Assert.assertEquals((Object)"foo", (Object)AtlasPath.cleanPathSegment((String)"foo{bar}"));
        Assert.assertEquals((Object)"foo[0", (Object)AtlasPath.cleanPathSegment((String)"foo[0"));
        Assert.assertEquals((Object)"foo1234>", (Object)AtlasPath.cleanPathSegment((String)"foo1234>"));
        Assert.assertEquals((Object)"foo}", (Object)AtlasPath.cleanPathSegment((String)"foo}"));
        Assert.assertEquals((Object)"bar", (Object)AtlasPath.cleanPathSegment((String)"foo:bar"));
        Assert.assertEquals((Object)"bar", (Object)AtlasPath.cleanPathSegment((String)"foo:@bar"));
        Assert.assertEquals((Object)"bar", (Object)AtlasPath.cleanPathSegment((String)"@bar"));
    }

    @Test
    public void testGetLastSegmentParent() {
        AtlasPath p = new AtlasPath("/orders/contact/firstName");
        Assert.assertEquals((Object)"contact", (Object)p.getLastSegmentParent());
        Assert.assertNull((Object)new AtlasPath("orders").getLastSegmentParent());
    }

    @Test
    public void testGetLastSegmentParentPath() {
        AtlasPath p = new AtlasPath("/orders[]/contact/firstName");
        Assert.assertEquals((Object)"/orders[]/contact", (Object)p.getLastSegmentParentPath().toString());
        Assert.assertNull((Object)new AtlasPath("orders").getLastSegmentParentPath());
    }

    @Test
    public void testDeParentify() {
        AtlasPath p = new AtlasPath("/orders[]/contact/firstName");
        Assert.assertEquals((Object)"/contact/firstName", (Object)p.deParentify().toString());
        p = new AtlasPath("/orders/contact[]/firstName");
        Assert.assertEquals((Object)"/contact[]/firstName", (Object)p.deParentify().toString());
        Assert.assertNull((Object)new AtlasPath("").deParentify());
    }

    @Test
    public void testDeCollectionfy() {
        AtlasPath p = new AtlasPath("/orders[]/contact/firstName");
        Assert.assertEquals((Object)"/contact/firstName", (Object)p.deCollectionify("orders").toString());
        Assert.assertEquals((Object)"/contact/firstName", (Object)p.deCollectionify("orders[]").toString());
        Assert.assertEquals((Object)"/contact/firstName", (Object)p.deCollectionify("orders[3]").toString());
        p = new AtlasPath("/orders/contact[]/firstName");
        Assert.assertEquals((Object)"firstName", (Object)p.deCollectionify("contact").toString());
        Assert.assertEquals((Object)"firstName", (Object)p.deCollectionify("contact[]").toString());
        Assert.assertEquals((Object)"firstName", (Object)p.deCollectionify("contact[3]").toString());
        p = new AtlasPath("/orders<>/contact/firstName");
        Assert.assertEquals((Object)"/contact/firstName", (Object)p.deCollectionify("orders").toString());
        Assert.assertEquals((Object)"/contact/firstName", (Object)p.deCollectionify("orders<>").toString());
        Assert.assertEquals((Object)"/contact/firstName", (Object)p.deCollectionify("orders<3>").toString());
        p = new AtlasPath("/orders/contact<>/firstName");
        Assert.assertEquals((Object)"firstName", (Object)p.deCollectionify("contact").toString());
        Assert.assertEquals((Object)"firstName", (Object)p.deCollectionify("contact<>").toString());
        Assert.assertEquals((Object)"firstName", (Object)p.deCollectionify("contact<3>").toString());
        Assert.assertNull((Object)new AtlasPath("").deCollectionify("contact"));
    }

    @Test
    public void testCollectionIndexHandling() {
        Assert.assertNull((Object)AtlasPath.indexOfSegment(null));
        Assert.assertNull((Object)AtlasPath.indexOfSegment((String)""));
        Assert.assertNull((Object)AtlasPath.indexOfSegment((String)"foo"));
        Assert.assertNull((Object)AtlasPath.indexOfSegment((String)"foo[]"));
        Assert.assertNull((Object)AtlasPath.indexOfSegment((String)"foo<>"));
        Assert.assertNull((Object)AtlasPath.indexOfSegment((String)"foo{}"));
        Assert.assertEquals((Object)new Integer(0), (Object)AtlasPath.indexOfSegment((String)"foo[0]"));
        Assert.assertEquals((Object)new Integer(1234), (Object)AtlasPath.indexOfSegment((String)"foo<1234>"));
        Assert.assertNull((Object)AtlasPath.indexOfSegment((String)"foo{bar}"));
        AtlasPath p = new AtlasPath("/orders[4]/contact/firstName");
        p.setCollectionIndex("orders[4]", Integer.valueOf(5));
        Assert.assertEquals((Object)"/orders[5]/contact/firstName", (Object)p.toString());
        Assert.assertEquals((Object)new Integer(5), (Object)AtlasPath.indexOfSegment((String)"orders[5]"));
        try {
            p.setCollectionIndex("orders<>", Integer.valueOf(-3));
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            p.setCollectionIndex("orders{}", Integer.valueOf(3));
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            p.setCollectionIndex("orders", Integer.valueOf(3));
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            p.setCollectionIndex("/orders/contact/foo", Integer.valueOf(3));
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            p.setCollectionIndex(null, Integer.valueOf(3));
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AtlasPath q = new AtlasPath("/orders<4>/contact/firstName");
        q.setCollectionIndex("orders<7>", Integer.valueOf(6));
        Assert.assertEquals((Object)"/orders<6>/contact/firstName", (Object)q.toString());
        Assert.assertEquals((Object)new Integer(5), (Object)AtlasPath.indexOfSegment((String)"orders<5>"));
        AtlasPath r = new AtlasPath("/orders<>/contact/firstName");
        Assert.assertEquals((Object)"orders<>", (Object)r.getCollectionSegment());
        r.setCollectionIndex("orders<>", Integer.valueOf(6));
        Assert.assertEquals((Object)"/orders<6>/contact/firstName", (Object)r.toString());
        Assert.assertEquals((Object)new Integer(6), (Object)AtlasPath.indexOfSegment((String)r.getCollectionSegment()));
        Assert.assertNull((Object)new AtlasPath("").getCollectionSegment());
    }

    @Test
    public void testIsIndexedCollection() {
        AtlasPath p = null;
        p = new AtlasPath("order");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("/order/contact/firstName");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("order[]");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[4]/contact/firstName");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[0]/contact/firstName");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders[]/contact/firstName");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("orders<>");
        Assert.assertFalse((boolean)p.isIndexedCollection());
        p = new AtlasPath("orders<6>");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/foo/orders<6>");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/foo/orders<6>/bar");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<3>/contact/firstName");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<0>/contact/firstName");
        Assert.assertTrue((boolean)p.isIndexedCollection());
        p = new AtlasPath("/orders<>/contact/firstName");
        Assert.assertFalse((boolean)p.isIndexedCollection());
    }

    @Test
    public void testRemoveCollectionIndexes() {
        Assert.assertEquals(null, (Object)AtlasPath.removeCollectionIndex(null));
        Assert.assertEquals((Object)"blah", (Object)AtlasPath.removeCollectionIndex((String)"blah"));
        Assert.assertEquals((Object)"@blah", (Object)AtlasPath.removeCollectionIndex((String)"@blah"));
        Assert.assertEquals((Object)"@x:blah", (Object)AtlasPath.removeCollectionIndex((String)"@x:blah"));
        Assert.assertEquals((Object)"blah[]", (Object)AtlasPath.removeCollectionIndex((String)"blah[]"));
        Assert.assertEquals((Object)"@blah[]", (Object)AtlasPath.removeCollectionIndex((String)"@blah[]"));
        Assert.assertEquals((Object)"@x:blah[]", (Object)AtlasPath.removeCollectionIndex((String)"@x:blah[]"));
        Assert.assertEquals((Object)"blah<>", (Object)AtlasPath.removeCollectionIndex((String)"blah<>"));
        Assert.assertEquals((Object)"@blah<>", (Object)AtlasPath.removeCollectionIndex((String)"@blah<>"));
        Assert.assertEquals((Object)"@x:blah<>", (Object)AtlasPath.removeCollectionIndex((String)"@x:blah<>"));
        Assert.assertEquals((Object)"blah{}", (Object)AtlasPath.removeCollectionIndex((String)"blah{}"));
        Assert.assertEquals((Object)"@blah{}", (Object)AtlasPath.removeCollectionIndex((String)"@blah{}"));
        Assert.assertEquals((Object)"@x:blah{}", (Object)AtlasPath.removeCollectionIndex((String)"@x:blah{}"));
        Assert.assertEquals((Object)"blah[]", (Object)AtlasPath.removeCollectionIndex((String)"blah[8]"));
        Assert.assertEquals((Object)"@blah[]", (Object)AtlasPath.removeCollectionIndex((String)"@blah[955]"));
        Assert.assertEquals((Object)"@x:blah[]", (Object)AtlasPath.removeCollectionIndex((String)"@x:blah[800]"));
        Assert.assertEquals((Object)"blah<>", (Object)AtlasPath.removeCollectionIndex((String)"blah<5>"));
        Assert.assertEquals((Object)"@blah<>", (Object)AtlasPath.removeCollectionIndex((String)"@blah<6>"));
        Assert.assertEquals((Object)"@x:blah<>", (Object)AtlasPath.removeCollectionIndex((String)"@x:blah<75555>"));
        Assert.assertEquals((Object)"blah{}", (Object)AtlasPath.removeCollectionIndex((String)"blah{5}"));
        Assert.assertEquals((Object)"@blah{}", (Object)AtlasPath.removeCollectionIndex((String)"@blah{6}"));
        Assert.assertEquals((Object)"@x:blah{}", (Object)AtlasPath.removeCollectionIndex((String)"@x:blah{65565657}"));
        this.testMalformed("blah");
        this.testMalformed("@blah");
        this.testMalformed("@x:blah");
        Assert.assertEquals((Object)"/a/b[]/c/d[]/e{}/f<>/g[112/x{/z>>11", (Object)AtlasPath.removeCollectionIndexes((String)"/a/b[]/c/d[15]/e{11}/f<111>/g[112/x{/z>>11"));
    }

    public void testMalformed(String var) {
        Assert.assertEquals((Object)(var + "["), (Object)AtlasPath.removeCollectionIndex((String)(var + "[")));
        Assert.assertEquals((Object)(var + "]"), (Object)AtlasPath.removeCollectionIndex((String)(var + "]")));
        Assert.assertEquals((Object)(var + "<"), (Object)AtlasPath.removeCollectionIndex((String)(var + "<")));
        Assert.assertEquals((Object)(var + ">"), (Object)AtlasPath.removeCollectionIndex((String)(var + ">")));
        Assert.assertEquals((Object)(var + "{"), (Object)AtlasPath.removeCollectionIndex((String)(var + "{")));
        Assert.assertEquals((Object)(var + "}"), (Object)AtlasPath.removeCollectionIndex((String)(var + "}")));
        Assert.assertEquals((Object)(var + "{{"), (Object)AtlasPath.removeCollectionIndex((String)(var + "{{")));
        Assert.assertEquals((Object)(var + "}}"), (Object)AtlasPath.removeCollectionIndex((String)(var + "}}")));
    }

    @Test
    public void testGetLastSegment() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assert.assertEquals((Object)"firstName", (Object)p.getLastSegment());
        Assert.assertNull((Object)new AtlasPath("").getLastSegment());
        Assert.assertNotNull((Object)p.getOriginalPath());
    }

    @Test
    public void testHasParent() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assert.assertTrue((boolean)p.hasParent());
        p = new AtlasPath("orders");
        Assert.assertFalse((boolean)p.hasParent());
    }

    @Test
    public void testIsCollectionSegment() {
        Assert.assertFalse((boolean)AtlasPath.isCollectionSegment(null));
        Assert.assertTrue((boolean)AtlasPath.isArraySegment((String)"[]"));
        Assert.assertFalse((boolean)AtlasPath.isArraySegment((String)"]"));
        Assert.assertTrue((boolean)AtlasPath.isCollectionSegment((String)"[]"));
        Assert.assertFalse((boolean)AtlasPath.isCollectionSegment((String)"["));
        Assert.assertFalse((boolean)AtlasPath.isCollectionSegment((String)"]"));
        Assert.assertTrue((boolean)AtlasPath.isListSegment((String)"<>"));
        Assert.assertFalse((boolean)AtlasPath.isListSegment((String)">"));
        Assert.assertTrue((boolean)AtlasPath.isCollectionSegment((String)"<>"));
        Assert.assertFalse((boolean)AtlasPath.isCollectionSegment((String)"<"));
        Assert.assertFalse((boolean)AtlasPath.isCollectionSegment((String)">"));
        Assert.assertTrue((boolean)AtlasPath.isMapSegment((String)"{}"));
        Assert.assertFalse((boolean)AtlasPath.isMapSegment((String)"}"));
        Assert.assertTrue((boolean)AtlasPath.isCollectionSegment((String)"{}"));
        Assert.assertFalse((boolean)AtlasPath.isCollectionSegment((String)"{"));
        Assert.assertFalse((boolean)AtlasPath.isCollectionSegment((String)"}"));
        Assert.assertFalse((boolean)AtlasPath.isCollectionSegment((String)""));
    }

    @Test
    public void testHasCollection() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assert.assertFalse((boolean)p.hasCollection());
        p = new AtlasPath("[1,2]");
        Assert.assertTrue((boolean)p.hasCollection());
        Assert.assertTrue((boolean)AtlasPath.isCollection((String)"[1,2]"));
    }

    @Test
    public void testIsCollectionRoot() {
        AtlasPath p = new AtlasPath("/order/contact/firstName");
        Assert.assertFalse((boolean)p.isCollectionRoot());
        p = new AtlasPath("[1,2]");
        Assert.assertTrue((boolean)p.isCollectionRoot());
    }

    @Test
    public void testGetAttribute() {
        Assert.assertNotNull((Object)AtlasPath.getAttribute((String)"@attribute"));
    }

    @Test
    public void testIsAttributeSegment() {
        Assert.assertFalse((boolean)AtlasPath.isAttributeSegment(null));
        Assert.assertFalse((boolean)AtlasPath.isAttributeSegment((String)"order"));
        Assert.assertTrue((boolean)AtlasPath.isAttributeSegment((String)"@order"));
    }

    @Test
    public void testGetCollectionIndex() {
        AtlasPath p = new AtlasPath("orders/order[1]");
        Assert.assertEquals((Object)new Integer(1), (Object)p.getCollectionIndex("order"));
        p = new AtlasPath("order");
        Assert.assertEquals(null, (Object)p.getCollectionIndex("order"));
        p = new AtlasPath("orders/order<2>");
        Assert.assertEquals((Object)new Integer(2), (Object)p.getCollectionIndex("order"));
    }

    @Test
    public void testGetSegmentContexts() {
        AtlasPath path = new AtlasPath("/orders");
        Assert.assertNotNull((Object)path.getSegmentContexts(true));
        List segmentContexts = path.getSegmentContexts(false);
        Assert.assertNotNull((Object)segmentContexts);
        Assert.assertEquals((long)2L, (long)segmentContexts.size());
        AtlasPath.SegmentContext segmentContext = (AtlasPath.SegmentContext)segmentContexts.get(1);
        Assert.assertNotNull((Object)segmentContext.getSegment());
        Assert.assertNotNull((Object)segmentContext.getSegmentIndex());
        Assert.assertNotNull((Object)segmentContext.getSegmentPath());
        Assert.assertNull((Object)segmentContext.getNext());
        Assert.assertNotNull((Object)segmentContext.getPrev());
        Assert.assertNotNull((Object)segmentContext.getPathUtil());
        Assert.assertNotNull((Object)segmentContext.toString());
        Assert.assertFalse((boolean)segmentContext.hasChild());
        Assert.assertTrue((boolean)segmentContext.hasParent());
        segmentContext = (AtlasPath.SegmentContext)segmentContexts.get(0);
        Assert.assertTrue((boolean)segmentContext.hasChild());
        Assert.assertFalse((boolean)segmentContext.hasParent());
    }

    @Test
    public void testOverwriteCollectionIndex() {
        Assert.assertEquals((Object)"/orders[5]", (Object)AtlasPath.overwriteCollectionIndex((String)"/orders[4]", (int)5));
        Assert.assertEquals((Object)"/orders<5>", (Object)AtlasPath.overwriteCollectionIndex((String)"/orders<4>", (int)5));
    }
}

