/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasTestData;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.SimpleField;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class BaseDefaultAtlasContextTest {
    protected DefaultAtlasContext context = null;
    protected BaseAtlasModule sourceModule = null;
    protected BaseAtlasModule targetModule = null;
    protected AtlasMapping mapping = null;
    protected AtlasInternalSession session = null;
    protected MockFieldReader reader = null;
    protected MockFieldWriter writer = null;

    @Before
    public void init() throws AtlasException {
        this.mapping = AtlasTestData.generateAtlasMapping();
        this.context = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), this.mapping);
        this.sourceModule = this.mockAtlasModule();
        this.sourceModule.setMode(AtlasModuleMode.SOURCE);
        this.targetModule = this.mockAtlasModule();
        this.targetModule.setMode(AtlasModuleMode.TARGET);
        this.context.getSourceModules().put("ATLAS_DEFAULT_SOURCE_DOC", this.sourceModule);
        this.context.getTargetModules().put("ATLAS_DEFAULT_TARGET_DOC", this.targetModule);
        this.session = (AtlasInternalSession)this.context.createSession();
        this.reader = new MockFieldReader();
        this.session.setFieldReader("ATLAS_DEFAULT_SOURCE_DOC", (AtlasFieldReader)this.reader);
        this.writer = new MockFieldWriter();
        this.session.setFieldWriter("ATLAS_DEFAULT_TARGET_DOC", (AtlasFieldWriter)this.writer);
    }

    private BaseAtlasModule mockAtlasModule() throws AtlasException {
        BaseAtlasModule module = (BaseAtlasModule)Mockito.spy(BaseAtlasModule.class);
        module.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        Mockito.when((Object)module.isSupportedField((Field)Mockito.any(Field.class))).thenReturn((Object)true);
        ((BaseAtlasModule)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AtlasInternalSession session = (AtlasInternalSession)invocation.getArguments()[0];
                Field field = session.head().getSourceField();
                field.setValue(BaseDefaultAtlasContextTest.this.reader.sources.get(field.getPath()));
                return null;
            }
        }).when((Object)module)).processSourceFieldMapping((AtlasInternalSession)Mockito.any());
        ((BaseAtlasModule)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AtlasInternalSession session = (AtlasInternalSession)invocation.getArguments()[0];
                LookupTable table = session.head().getLookupTable();
                Field source = session.head().getSourceField();
                Field target = session.head().getTargetField();
                Object value = source.getValue();
                if (table != null) {
                    for (LookupEntry e : table.getLookupEntry()) {
                        if (!value.equals(e.getSourceValue())) continue;
                        value = e.getTargetValue();
                    }
                }
                target.setValue(value);
                BaseDefaultAtlasContextTest.this.writer.write(session);
                return null;
            }
        }).when((Object)module)).processTargetFieldMapping((AtlasInternalSession)Mockito.any());
        return module;
    }

    protected Field populateSourceField(Mapping mapping, String docId, FieldType type, Object value, int index) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setDocId(docId);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field populateSourceField(Mapping mapping, FieldType type, Object value, int index) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field populateSourceField(Mapping mapping, FieldType type, Object value) {
        SimpleField field = new SimpleField();
        field.setFieldType(type);
        field.setPath("/testPath" + value);
        mapping.getInputField().add(field);
        this.reader.sources.put(field.getPath(), value);
        return field;
    }

    protected Field populateSourceField(Mapping mapping, String docId, FieldType type, Object value) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setDocId(docId);
        return field;
    }

    protected Field populateUnsupportedSourceField(Mapping mapping, String docId, final String value, int index) {
        return this.populateSourceField(mapping, docId, FieldType.UNSUPPORTED, new Object(){

            public String toString() {
                return value;
            }
        }, index);
    }

    protected Field populateUnsupportedSourceField(Mapping mapping, String value, int index) {
        return this.populateUnsupportedSourceField(mapping, null, value, index);
    }

    protected Field prepareTargetField(Mapping mapping, String path) {
        SimpleField field = new SimpleField();
        field.setPath(path);
        mapping.getOutputField().add(field);
        return field;
    }

    protected Field prepareTargetField(Mapping mapping, String path, int index) {
        Field field = this.prepareTargetField(mapping, path);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field prepareTargetField(Mapping mapping, FieldType type, String path, int index) {
        Field field = this.prepareTargetField(mapping, path);
        field.setFieldType(type);
        field.setPath(path);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected String printAudit(AtlasSession session) {
        StringBuilder buf = new StringBuilder("Audits: ");
        for (Audit a : session.getAudits().getAudit()) {
            buf.append('[');
            buf.append(a.getStatus());
            buf.append(", message=");
            buf.append(a.getMessage());
            buf.append("], ");
        }
        return buf.toString();
    }

    protected class MockFieldWriter
    implements AtlasFieldWriter {
        protected Map<String, Object> targets = new HashMap<String, Object>();

        protected MockFieldWriter() {
        }

        public void write(AtlasInternalSession session) throws AtlasException {
            this.targets.put(session.head().getTargetField().getPath(), session.head().getTargetField().getValue());
        }
    }

    protected class MockFieldReader
    implements AtlasFieldReader {
        protected Map<String, Object> sources = new HashMap<String, Object>();

        protected MockFieldReader() {
        }

        public void read(AtlasInternalSession session) throws AtlasException {
            Field field = session.head().getSourceField();
            field.setValue(this.sources.get(field.getPath()));
        }
    }
}

