/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasCombineStrategy;
import io.atlasmap.spi.AtlasCombineStrategy;
import io.atlasmap.spi.StringDelimiter;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAtlasCombineStrategyTest {
    private AtlasCombineStrategy combine = null;

    @Before
    public void setUp() {
        this.combine = new DefaultAtlasCombineStrategy();
    }

    @After
    public void tearDown() {
        this.combine = null;
    }

    @Test
    public void testGetName() {
        Assert.assertNotNull((Object)this.combine);
        Assert.assertEquals((Object)"DefaultAtlasCombineStrategy", (Object)this.combine.getName());
    }

    protected Map<Integer, String> generateCombineMap(int count) {
        String combines = "abcdefghijklmnopqrstuvwxyz";
        HashMap<Integer, String> cMap = new HashMap<Integer, String>();
        for (int i = 0; i < count; ++i) {
            cMap.put(i, combines.substring(i, i + 1));
        }
        return cMap;
    }

    @Test
    public void testGetSetDelimiter() {
        Assert.assertNotNull((Object)this.combine);
        Assert.assertNotNull((Object)this.combine.getDelimiter());
        Assert.assertEquals((Object)DefaultAtlasCombineStrategy.DEFAULT_COMBINE_DELIMITER, (Object)this.combine.getDelimiter());
        this.combine.setDelimiter(StringDelimiter.COLON);
        Assert.assertEquals((Object)StringDelimiter.COLON, (Object)this.combine.getDelimiter());
        String value = this.combine.combineValues(this.generateCombineMap(4));
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"a:b:c:d", (Object)value);
    }

    @Test
    public void testGetSetLimit() {
        Assert.assertNotNull((Object)this.combine);
        Assert.assertNotNull((Object)this.combine.getDelimiter());
        Assert.assertEquals((Object)DefaultAtlasCombineStrategy.DEFAULT_COMBINE_LIMIT, (Object)this.combine.getLimit());
        this.combine.setLimit(Integer.valueOf(2));
        String value = this.combine.combineValues(this.generateCombineMap(4));
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"a b", (Object)value);
    }

    @Test
    public void testGetSetAutoTrim() {
        Assert.assertNotNull((Object)this.combine);
        Assert.assertFalse((boolean)((DefaultAtlasCombineStrategy)this.combine).isDisableAutoTrim());
        ((DefaultAtlasCombineStrategy)this.combine).setDisableAutoTrim(true);
        Assert.assertTrue((boolean)((DefaultAtlasCombineStrategy)this.combine).isDisableAutoTrim());
        Map<Integer, String> cMap = this.generateCombineMap(2);
        cMap.put(0, cMap.get(0) + " ");
        String value = this.combine.combineValues(cMap);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"a  b", (Object)value);
    }

    @Test
    public void testDisableAutoTrimNullDelimiter() {
        Assert.assertNotNull((Object)this.combine);
        Assert.assertFalse((boolean)((DefaultAtlasCombineStrategy)this.combine).isDisableAutoTrim());
        ((DefaultAtlasCombineStrategy)this.combine).setDisableAutoTrim(true);
        Assert.assertTrue((boolean)((DefaultAtlasCombineStrategy)this.combine).isDisableAutoTrim());
        Map<Integer, String> cMap = this.generateCombineMap(3);
        cMap.put(0, cMap.get(0) + " ");
        cMap.put(2, "  " + cMap.get(2));
        String value = this.combine.combineValues(cMap, null);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"a  b   c", (Object)value);
    }

    @Test
    public void testCombineSingleValue() {
        Assert.assertNotNull((Object)this.combine);
        String value = this.combine.combineValues(this.generateCombineMap(1));
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"a", (Object)value);
    }

    @Test
    public void testCombineValues() {
        Assert.assertNotNull((Object)this.combine);
        String value = this.combine.combineValues(this.generateCombineMap(6));
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"a b c d e f", (Object)value);
    }

    @Test
    public void testCombineValuesNullDelimiter() {
        Assert.assertNotNull((Object)this.combine);
        this.combine.setDelimiter(null);
        Assert.assertNull((Object)this.combine.getDelimiter());
        String value = this.combine.combineValues(this.generateCombineMap(6));
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"a b c d e f", (Object)value);
    }

    @Test
    public void testCombineValuesNullLimit() {
        Assert.assertNotNull((Object)this.combine);
        this.combine.setLimit(null);
        Assert.assertNull((Object)this.combine.getLimit());
        String value = this.combine.combineValues(this.generateCombineMap(6));
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"a b c d e f", (Object)value);
    }

    @Test
    public void testSeparateValuesNullValue() {
        Assert.assertNotNull((Object)this.combine);
        String value = this.combine.combineValues(null);
        Assert.assertNull((Object)value);
    }

    @Test
    public void testCombineValuesEmptyValue() {
        Assert.assertNotNull((Object)this.combine);
        String value = this.combine.combineValues(new HashMap());
        Assert.assertNull((Object)value);
    }

    @Test
    public void testSortByKey() {
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(this.generateCombineMap(4));
        Assert.assertEquals((Object)"a", cMap.get(0));
        Assert.assertEquals((Object)"b", cMap.get(1));
        Assert.assertEquals((Object)"c", cMap.get(2));
        Assert.assertEquals((Object)"d", cMap.get(3));
    }

    @Test
    public void testSortByKeyOutOfOrder() {
        HashMap<Integer, String> outOfOrder = new HashMap<Integer, String>();
        outOfOrder.put(2, "c");
        outOfOrder.put(0, "a");
        outOfOrder.put(3, "d");
        outOfOrder.put(1, "b");
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(outOfOrder);
        int count = 0;
        for (String str : cMap.values()) {
            if (count == 0) {
                Assert.assertEquals((Object)"a", (Object)str);
            }
            if (count == 1) {
                Assert.assertEquals((Object)"b", (Object)str);
            }
            if (count == 2) {
                Assert.assertEquals((Object)"c", (Object)str);
            }
            if (count == 3) {
                Assert.assertEquals((Object)"d", (Object)str);
            }
            ++count;
        }
    }

    @Test
    public void testSortByKeyOutOfOrderGaps() {
        HashMap<Integer, String> outOfOrder = new HashMap<Integer, String>();
        outOfOrder.put(7, "c");
        outOfOrder.put(3, "a");
        outOfOrder.put(99, "d");
        outOfOrder.put(5, "b");
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(outOfOrder);
        int count = 0;
        for (String str : cMap.values()) {
            if (count == 0) {
                Assert.assertEquals((Object)"a", (Object)str);
            }
            if (count == 1) {
                Assert.assertEquals((Object)"b", (Object)str);
            }
            if (count == 2) {
                Assert.assertEquals((Object)"c", (Object)str);
            }
            if (count == 3) {
                Assert.assertEquals((Object)"d", (Object)str);
            }
            ++count;
        }
    }

    @Test
    public void testSortByKeyWithNullKey() {
        Map<Integer, String> generatedCombineMap = this.generateCombineMap(4);
        generatedCombineMap.put(null, "valueWithNullKey");
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(generatedCombineMap);
        Assert.assertEquals((Object)"a", cMap.get(0));
        Assert.assertEquals((Object)"b", cMap.get(1));
        Assert.assertEquals((Object)"c", cMap.get(2));
        Assert.assertEquals((Object)"d", cMap.get(3));
        Assert.assertEquals((Object)"valueWithNullKey", cMap.get(null));
    }

    @Test
    public void testSortByKeyWithNullValue() {
        Map<Integer, String> generatedCombineMap = this.generateCombineMap(4);
        generatedCombineMap.put(4, null);
        generatedCombineMap.put(5, "f");
        Map cMap = DefaultAtlasCombineStrategy.sortByKey(generatedCombineMap);
        Assert.assertEquals((Object)"a", cMap.get(0));
        Assert.assertEquals((Object)"b", cMap.get(1));
        Assert.assertEquals((Object)"c", cMap.get(2));
        Assert.assertEquals((Object)"d", cMap.get(3));
        Assert.assertEquals(null, cMap.get(4));
        Assert.assertEquals((Object)"f", cMap.get(5));
    }
}

