/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasConverter;
import io.atlasmap.converters.StringConverter;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAtlasConversionServiceTest {
    private AtlasConversionService service = null;

    @Before
    public void setUp() {
        this.service = DefaultAtlasConversionService.getInstance();
    }

    @After
    public void tearDown() {
        if (this.service != null) {
            this.service = null;
        }
    }

    @Test
    public void getservice() {
        Assert.assertNotNull((Object)this.service);
        DefaultAtlasConversionService service2 = DefaultAtlasConversionService.getInstance();
        Assert.assertNotNull((Object)service2);
        Assert.assertSame((Object)this.service, (Object)service2);
    }

    @Test
    public void findMatchingConverterByFieldTypes() {
        Assert.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter(FieldType.STRING, FieldType.BOOLEAN);
        Assert.assertTrue((boolean)atlasConverter.isPresent());
        Assert.assertNotNull((Object)atlasConverter);
        Assert.assertEquals(StringConverter.class, ((AtlasConverter)atlasConverter.get()).getClass());
        StringConverter stringConverter = (StringConverter)atlasConverter.get();
        Assert.assertNotNull((Object)stringConverter);
        Assert.assertThat((Object)"io.atlasmap.converters.StringConverter", (Matcher)CoreMatchers.is((Object)((AtlasConverter)atlasConverter.get()).getClass().getCanonicalName()));
        Boolean t = stringConverter.toBoolean("T", null, null);
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)t);
        Boolean f = stringConverter.toBoolean("F", null, null);
        Assert.assertNotNull((Object)f);
        Assert.assertFalse((boolean)f);
        this.service.findMatchingConverter(null, FieldType.BOOLEAN);
        this.service.findMatchingConverter(FieldType.STRING, null);
        FieldType fieldType = null;
        this.service.findMatchingConverter(fieldType, fieldType);
    }

    @Test
    public void findMatchingConverterByFieldTypesCustomConverter() {
        Assert.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter(FieldType.STRING, FieldType.STRING);
        Assert.assertNotNull((Object)atlasConverter);
        Assert.assertTrue((boolean)atlasConverter.isPresent());
        Assert.assertTrue((boolean)AtlasConverter.class.isAssignableFrom(((AtlasConverter)atlasConverter.get()).getClass()));
        Assert.assertThat((Object)"io.atlasmap.converters.StringConverter", (Matcher)CoreMatchers.is((Object)((AtlasConverter)atlasConverter.get()).getClass().getCanonicalName()));
    }

    @Test
    public void findMatchingConverterByFieldTypesNoMatching() {
        Assert.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter(FieldType.STRING, FieldType.COMPLEX);
        Assert.assertFalse((boolean)atlasConverter.isPresent());
    }

    @Test
    public void findMatchingConverterBySourceClass() {
        Assert.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter("java.util.Date", "java.time.ZonedDateTime");
        Assert.assertNotNull((Object)atlasConverter);
        Assert.assertTrue((boolean)atlasConverter.isPresent());
        Assert.assertTrue((boolean)AtlasConverter.class.isAssignableFrom(((AtlasConverter)atlasConverter.get()).getClass()));
        Assert.assertThat((Object)"io.atlasmap.converters.DateConverter", (Matcher)CoreMatchers.is((Object)((AtlasConverter)atlasConverter.get()).getClass().getCanonicalName()));
    }

    @Test
    public void findMatchingConverterBySourceClassNoMatching() {
        Assert.assertNotNull((Object)this.service);
        Optional atlasConverter = this.service.findMatchingConverter("java.util.Date", "java.time.CustomClass");
        Assert.assertFalse((boolean)atlasConverter.isPresent());
    }

    @Test
    public void testIsPrimitiveClass() {
        Assert.assertTrue((boolean)this.service.isPrimitive(Boolean.TYPE));
        Assert.assertTrue((boolean)this.service.isPrimitive(Byte.TYPE));
        Assert.assertTrue((boolean)this.service.isPrimitive(Character.TYPE));
        Assert.assertTrue((boolean)this.service.isPrimitive(Double.TYPE));
        Assert.assertTrue((boolean)this.service.isPrimitive(Float.TYPE));
        Assert.assertTrue((boolean)this.service.isPrimitive(Integer.TYPE));
        Assert.assertTrue((boolean)this.service.isPrimitive(Long.TYPE));
        Assert.assertTrue((boolean)this.service.isPrimitive(Short.TYPE));
        Assert.assertFalse((boolean)this.service.isPrimitive(Boolean.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(Byte.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(Character.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(Double.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(Float.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(Integer.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(Long.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(Short.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(String.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(AtlasMapping.class));
        Assert.assertFalse((boolean)this.service.isPrimitive(List.class));
        Assert.assertFalse((boolean)this.service.isPrimitive((Class)null));
    }

    @Test
    public void testIsPrimitiveFieldType() {
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.BOOLEAN));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.BYTE));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.CHAR));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.DECIMAL));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.DOUBLE));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.FLOAT));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.INTEGER));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.LONG));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.SHORT));
        Assert.assertTrue((boolean)this.service.isPrimitive(FieldType.STRING));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.ANY));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.BYTE_ARRAY));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.COMPLEX));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.DATE));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.DATE_TIME));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.DATE_TIME_TZ));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.DATE_TZ));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.TIME));
        Assert.assertFalse((boolean)this.service.isPrimitive(FieldType.TIME_TZ));
        Assert.assertFalse((boolean)this.service.isPrimitive((FieldType)null));
    }

    @Test
    public void testIsBoxedPrimitive() {
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(Boolean.class));
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(Byte.class));
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(Character.class));
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(Double.class));
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(Float.class));
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(Integer.class));
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(Long.class));
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(Short.class));
        Assert.assertTrue((boolean)this.service.isBoxedPrimitive(String.class));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(Boolean.TYPE));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(Byte.TYPE));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(Character.TYPE));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(Double.TYPE));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(Float.TYPE));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(Integer.TYPE));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(Long.TYPE));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(Short.TYPE));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(AtlasMapping.class));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive(List.class));
        Assert.assertFalse((boolean)this.service.isBoxedPrimitive((Class)null));
    }

    @Test
    public void testBoxOrUnboxPrimitive() {
        Assert.assertEquals(Boolean.class, (Object)this.service.boxOrUnboxPrimitive(Boolean.TYPE));
        Assert.assertEquals(Boolean.TYPE, (Object)this.service.boxOrUnboxPrimitive(Boolean.class));
        Assert.assertEquals(Byte.class, (Object)this.service.boxOrUnboxPrimitive(Byte.TYPE));
        Assert.assertEquals(Byte.TYPE, (Object)this.service.boxOrUnboxPrimitive(Byte.class));
        Assert.assertEquals(Character.class, (Object)this.service.boxOrUnboxPrimitive(Character.TYPE));
        Assert.assertEquals(Character.TYPE, (Object)this.service.boxOrUnboxPrimitive(Character.class));
        Assert.assertEquals(Double.class, (Object)this.service.boxOrUnboxPrimitive(Double.TYPE));
        Assert.assertEquals(Double.TYPE, (Object)this.service.boxOrUnboxPrimitive(Double.class));
        Assert.assertEquals(Float.class, (Object)this.service.boxOrUnboxPrimitive(Float.TYPE));
        Assert.assertEquals(Float.TYPE, (Object)this.service.boxOrUnboxPrimitive(Float.class));
        Assert.assertEquals(Integer.class, (Object)this.service.boxOrUnboxPrimitive(Integer.TYPE));
        Assert.assertEquals(Integer.TYPE, (Object)this.service.boxOrUnboxPrimitive(Integer.class));
        Assert.assertEquals(Long.class, (Object)this.service.boxOrUnboxPrimitive(Long.TYPE));
        Assert.assertEquals(Long.TYPE, (Object)this.service.boxOrUnboxPrimitive(Long.class));
        Assert.assertEquals(Short.class, (Object)this.service.boxOrUnboxPrimitive(Short.TYPE));
        Assert.assertEquals(Short.TYPE, (Object)this.service.boxOrUnboxPrimitive(Short.class));
        Assert.assertEquals(String.class, (Object)this.service.boxOrUnboxPrimitive(String.class));
        Assert.assertNotEquals(Boolean.class, (Object)this.service.boxOrUnboxPrimitive(Boolean.class));
        Assert.assertNotEquals(Boolean.TYPE, (Object)this.service.boxOrUnboxPrimitive(Boolean.TYPE));
        Assert.assertNotEquals(Byte.class, (Object)this.service.boxOrUnboxPrimitive(Byte.class));
        Assert.assertNotEquals(Byte.TYPE, (Object)this.service.boxOrUnboxPrimitive(Byte.TYPE));
        Assert.assertNotEquals(Character.class, (Object)this.service.boxOrUnboxPrimitive(Character.class));
        Assert.assertNotEquals(Character.TYPE, (Object)this.service.boxOrUnboxPrimitive(Character.TYPE));
        Assert.assertNotEquals(Double.class, (Object)this.service.boxOrUnboxPrimitive(Double.class));
        Assert.assertNotEquals(Double.TYPE, (Object)this.service.boxOrUnboxPrimitive(Double.TYPE));
        Assert.assertNotEquals(Float.class, (Object)this.service.boxOrUnboxPrimitive(Float.class));
        Assert.assertNotEquals(Float.TYPE, (Object)this.service.boxOrUnboxPrimitive(Float.TYPE));
        Assert.assertNotEquals(Integer.class, (Object)this.service.boxOrUnboxPrimitive(Integer.class));
        Assert.assertNotEquals(Integer.TYPE, (Object)this.service.boxOrUnboxPrimitive(Integer.TYPE));
        Assert.assertNotEquals(Long.class, (Object)this.service.boxOrUnboxPrimitive(Long.class));
        Assert.assertNotEquals(Long.TYPE, (Object)this.service.boxOrUnboxPrimitive(Long.TYPE));
        Assert.assertNotEquals(Short.class, (Object)this.service.boxOrUnboxPrimitive(Short.class));
        Assert.assertNotEquals(Short.TYPE, (Object)this.service.boxOrUnboxPrimitive(Short.TYPE));
        Assert.assertNotEquals(String.class, (Object)this.service.boxOrUnboxPrimitive(List.class));
        Assert.assertNull((Object)this.service.boxOrUnboxPrimitive((Class)null));
    }

    @Test
    public void testCopyPrimitive() {
        Object sourceValue = null;
        Object targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNull((Object)targetValue);
        sourceValue = true;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Boolean.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)targetValue);
        sourceValue = false;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Boolean.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)targetValue);
        sourceValue = (byte)1;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Byte.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Byte(1), (Object)targetValue);
        sourceValue = (byte)0;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Byte.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Byte(0), (Object)targetValue);
        sourceValue = Character.valueOf('a');
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Character.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Character('a'), (Object)targetValue);
        sourceValue = Character.valueOf('z');
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Character.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Character('z'), (Object)targetValue);
        sourceValue = Double.MIN_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Double.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Double(Double.MIN_VALUE), (Object)targetValue);
        sourceValue = Double.MAX_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Double.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Double(Double.MAX_VALUE), (Object)targetValue);
        sourceValue = Float.valueOf(Float.MIN_VALUE);
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Float.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Float(Float.MIN_VALUE), (Object)targetValue);
        sourceValue = Float.valueOf(Float.MAX_VALUE);
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Float.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Float(Float.MAX_VALUE), (Object)targetValue);
        sourceValue = Integer.MIN_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Integer.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Integer(Integer.MIN_VALUE), (Object)targetValue);
        sourceValue = Integer.MAX_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Integer.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Integer(Integer.MAX_VALUE), (Object)targetValue);
        sourceValue = Long.MIN_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Long.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Long(Long.MIN_VALUE), (Object)targetValue);
        sourceValue = Long.MAX_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Long.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Long(Long.MAX_VALUE), (Object)targetValue);
        sourceValue = (short)Short.MIN_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Short.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Short(Short.MIN_VALUE), (Object)targetValue);
        sourceValue = (short)Short.MAX_VALUE;
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertTrue((boolean)Short.class.getCanonicalName().equals(targetValue.getClass().getCanonicalName()));
        Assert.assertEquals((Object)new Short(Short.MAX_VALUE), (Object)targetValue);
        sourceValue = new ArrayList();
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertEquals((Object)sourceValue, (Object)targetValue);
        sourceValue = "foo";
        targetValue = this.service.copyPrimitive(sourceValue);
        Assert.assertNotNull((Object)targetValue);
        Assert.assertEquals((Object)"foo", (Object)targetValue);
    }

    @Test
    public void testListPrimitiveClassNames() {
        Assert.assertNotNull((Object)DefaultAtlasConversionService.listPrimitiveClassNames());
    }

    @Test
    public void testIsPrimitive() {
        Assert.assertTrue((boolean)this.service.isPrimitive("short"));
        String s = null;
        Assert.assertFalse((boolean)this.service.isPrimitive(s));
        Assert.assertFalse((boolean)this.service.isPrimitive("String"));
    }

    @Test
    public void testFieldTypeFromClass() {
        String className = null;
        Assert.assertEquals((Object)FieldType.NONE, (Object)this.service.fieldTypeFromClass(className));
        className = "";
        Assert.assertEquals((Object)FieldType.NONE, (Object)this.service.fieldTypeFromClass(className));
        Class klass = null;
        Assert.assertNull((Object)this.service.fieldTypeFromClass(klass));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Object.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Boolean.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Byte.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Character.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Double.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Float.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Integer.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Long.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Short.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(String.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Year.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Month.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(YearMonth.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(MonthDay.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(LocalDate.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(LocalTime.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(LocalDateTime.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(Date.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(java.util.Date.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass(ZonedDateTime.class));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass("boolean"));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass("byte"));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass("char"));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass("double"));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass("float"));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass("int"));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass("long"));
        Assert.assertNotNull((Object)this.service.fieldTypeFromClass("short"));
    }

    @Test
    public void testClassFromFieldType() {
        Assert.assertNull((Object)this.service.classFromFieldType(null));
        Assert.assertEquals(Object.class, (Object)this.service.classFromFieldType(FieldType.ANY));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.BOOLEAN));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.BYTE));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.CHAR));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.DOUBLE));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.FLOAT));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.INTEGER));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.LONG));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.SHORT));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.STRING));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.DATE));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.TIME));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.DATE_TIME));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.DATE_TZ));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.TIME_TZ));
        Assert.assertNotNull((Object)this.service.classFromFieldType(FieldType.DATE_TIME_TZ));
        Assert.assertNull((Object)this.service.classFromFieldType(FieldType.NONE));
    }

    @Test
    public void testConvertTypeFromBigDecimal() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.LONG));
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.SHORT));
        Assert.assertEquals((Object)"1", (Object)this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)BigDecimal.valueOf(1L), FieldType.DECIMAL, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromBigInteger() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.LONG));
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.SHORT));
        Assert.assertEquals((Object)"1", (Object)this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)BigInteger.valueOf(1L), FieldType.BIG_INTEGER, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromBoolean() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.CHAR));
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.LONG));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.SHORT));
        Assert.assertEquals((Object)"true", (Object)this.service.convertType((Object)true, FieldType.BOOLEAN, FieldType.STRING));
    }

    @Test
    public void testConvertTypeFromByte() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.LONG));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.SHORT));
        Assert.assertEquals((Object)"1", (Object)this.service.convertType((Object)1, FieldType.BYTE, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)1, FieldType.BYTE, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromCharacter() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(97L), (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)false, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.BOOLEAN));
        Assert.assertEquals((Object)97, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('a'), (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.CHAR));
        Assert.assertEquals((Object)BigDecimal.valueOf(97L), (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.DECIMAL));
        Assert.assertEquals((Object)97.0, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(97.0f), (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.FLOAT));
        Assert.assertEquals((Object)97, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.INTEGER));
        Assert.assertEquals((Object)97L, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.LONG));
        Assert.assertEquals((Object)97, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.NUMBER));
        Assert.assertEquals((Object)97, (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.SHORT));
        Assert.assertEquals((Object)"a", (Object)this.service.convertType((Object)Character.valueOf('a'), FieldType.CHAR, FieldType.STRING));
    }

    @Test
    public void testConvertTypeFromDate() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(new java.util.Date(1L).getTime()), (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.BYTE));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.LONG));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.SHORT));
        Assert.assertEquals(String.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.STRING).getClass());
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)new java.util.Date(1L), FieldType.DATE_TIME, FieldType.TIME).getClass());
        Assert.assertEquals(LocalDateTime.class, this.service.convertType((Object)new java.util.Date(1L), null, LocalDateTime.class, null).getClass());
    }

    @Test
    public void testConvertTypeFromDouble() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1.0), (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.LONG));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.SHORT));
        Assert.assertEquals((Object)"1.0", (Object)this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)new Double(1.0), FieldType.DOUBLE, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromFloat() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1.0), (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.LONG));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.SHORT));
        Assert.assertEquals((Object)"1.0", (Object)this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)new Float(1.0f), FieldType.FLOAT, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromInteger() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.LONG));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.SHORT));
        Assert.assertEquals((Object)"1", (Object)this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)new Integer(1), FieldType.INTEGER, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromLocalDate() throws AtlasConversionException {
        Assert.assertEquals(BigInteger.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.BIG_INTEGER).getClass());
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals(BigDecimal.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DECIMAL).getClass());
        Assert.assertEquals(Double.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.DOUBLE).getClass());
        Assert.assertEquals(Float.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.FLOAT).getClass());
        Assert.assertEquals(Long.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.LONG).getClass());
        Assert.assertEquals(Long.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.NUMBER).getClass());
        Assert.assertEquals(String.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.STRING).getClass());
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)LocalDate.ofEpochDay(0L), FieldType.DATE, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromLocalTime() throws AtlasConversionException {
        Assert.assertEquals(BigInteger.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.BIG_INTEGER).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals(BigDecimal.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DECIMAL).getClass());
        Assert.assertEquals(Double.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.DOUBLE).getClass());
        Assert.assertEquals(Float.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.FLOAT).getClass());
        Assert.assertEquals(Long.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.LONG).getClass());
        Assert.assertEquals(Long.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.NUMBER).getClass());
        Assert.assertEquals(String.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.STRING).getClass());
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)LocalTime.ofSecondOfDay(0L), FieldType.TIME, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromLong() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.LONG));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.SHORT));
        Assert.assertEquals((Object)"1", (Object)this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)new Long(1L), FieldType.LONG, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromNumber() throws AtlasConversionException {
        Integer number = 1;
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.LONG));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.SHORT));
        Assert.assertEquals((Object)"1", (Object)this.service.convertType((Object)number, FieldType.NUMBER, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)number, FieldType.NUMBER, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromShort() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('\u0001'), (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.LONG));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.SHORT));
        Assert.assertEquals((Object)"1", (Object)this.service.convertType((Object)1, FieldType.SHORT, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)1, FieldType.SHORT, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromString() throws AtlasConversionException {
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.BIG_INTEGER));
        Assert.assertEquals((Object)true, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.BOOLEAN));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.BYTE));
        Assert.assertEquals((Object)Character.valueOf('1'), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.CHAR));
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)"1970-01-01", FieldType.STRING, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)"1970-01-01T00:00:00.000Z", FieldType.STRING, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)"1970-01-01T00:00:00.000Z", FieldType.STRING, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)"1970-01-01T00:00:00.000Z", FieldType.STRING, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)"1970-01-01T00:00:00.000Z", FieldType.STRING, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.DECIMAL));
        Assert.assertEquals((Object)1.0, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.DOUBLE));
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.FLOAT));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.INTEGER));
        Assert.assertEquals((Object)1L, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.LONG));
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.NUMBER));
        Assert.assertEquals((Object)1, (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.SHORT));
        Assert.assertEquals((Object)"1", (Object)this.service.convertType((Object)"1", FieldType.STRING, FieldType.STRING));
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)"00:00:00.000", FieldType.STRING, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeFromZonedDateTime() throws AtlasConversionException {
        Assert.assertEquals(BigInteger.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.BIG_INTEGER).getClass());
        Assert.assertEquals(LocalDate.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DATE).getClass());
        Assert.assertEquals(java.util.Date.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DATE_TIME).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DATE_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.TIME_TZ).getClass());
        Assert.assertEquals(ZonedDateTime.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DATE_TIME_TZ).getClass());
        Assert.assertEquals(BigDecimal.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DECIMAL).getClass());
        Assert.assertEquals(Double.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.DOUBLE).getClass());
        Assert.assertEquals(Float.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.FLOAT).getClass());
        Assert.assertEquals(Long.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.LONG).getClass());
        Assert.assertEquals(Long.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.NUMBER).getClass());
        Assert.assertEquals(String.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.STRING).getClass());
        Assert.assertEquals(LocalTime.class, this.service.convertType((Object)ZonedDateTime.now(), FieldType.DATE_TIME_TZ, FieldType.TIME).getClass());
    }

    @Test
    public void testConvertTypeToAny() throws AtlasConversionException {
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.ANY, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.BIG_INTEGER, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.BOOLEAN, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.BYTE, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.CHAR, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DATE, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DATE_TIME, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DATE_TZ, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.TIME_TZ, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DATE_TIME, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DECIMAL, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.DOUBLE, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.FLOAT, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.INTEGER, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.LONG, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.NUMBER, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.SHORT, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.STRING, FieldType.ANY));
        Assert.assertEquals((Object)"passthrough", (Object)this.service.convertType((Object)"passthrough", FieldType.TIME, FieldType.ANY));
    }

    @Test(expected=AtlasConversionException.class)
    public void testConvertTypeAtlasConversionException() throws AtlasConversionException {
        Assert.assertNotNull((Object)this.service.convertType(new Object(), null, null));
    }
}

