/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.v2.AbsoluteValue;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionDetail;
import io.atlasmap.v2.ActionParameter;
import io.atlasmap.v2.Actions;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.GenerateUUID;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.v2.Trim;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAtlasFieldActionsServiceTest {
    private DefaultAtlasFieldActionService fieldActionsService = null;

    @Before
    public void setUp() {
        this.fieldActionsService = new DefaultAtlasFieldActionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        this.fieldActionsService.init();
    }

    @After
    public void tearDown() {
        this.fieldActionsService = null;
    }

    @Test
    public void testInit() {
        Assert.assertNotNull((Object)this.fieldActionsService);
        Assert.assertNotNull((Object)this.fieldActionsService.listActionDetails());
        Assert.assertTrue((this.fieldActionsService.listActionDetails().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListActionDetails() {
        Assert.assertNotNull((Object)this.fieldActionsService);
        List actionDetails = this.fieldActionsService.listActionDetails();
        for (ActionDetail d : actionDetails) {
            if (d.getParameters() == null) continue;
            System.out.println("Action: " + d.getName());
            for (ActionParameter param : d.getParameters().getParameter()) {
                System.out.println("\t param: " + param.getName());
                System.out.println("\t type: " + param.getFieldType().value());
            }
        }
    }

    @Test
    public void testFindActionDetail() {
        ActionDetail actionDetail = this.fieldActionsService.findActionDetail("IndexOf", FieldType.STRING);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail("Index", FieldType.STRING);
        Assert.assertNull((Object)actionDetail);
        ActionDetail ad = new ActionDetail();
        ad.setName("IndexOf");
        ad.setSourceType(FieldType.INTEGER);
        this.fieldActionsService.listActionDetails().add(ad);
        actionDetail = this.fieldActionsService.findActionDetail("IndexOf", null);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail("IndexOf", FieldType.STRING);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail("IndexOf", FieldType.ANY);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail("IndexOf", FieldType.NONE);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail("IndexOf", FieldType.BOOLEAN);
        Assert.assertNotNull((Object)actionDetail);
    }

    @Test(expected=AtlasConversionException.class)
    public void testProcessActionsActionsFieldAtlasConversionException() throws AtlasException {
        Actions actions = null;
        SimpleField field = new SimpleField();
        Object value = new Object();
        field.setValue(value);
        field.setFieldType(FieldType.INTEGER);
        this.fieldActionsService.processActions(actions, (Field)field);
    }

    @Test
    public void testProcessActionsActionsField() throws AtlasException {
        Actions actions = null;
        SimpleField field = new SimpleField();
        field.setFieldType(FieldType.COMPLEX);
        this.fieldActionsService.processActions(actions, (Field)field);
        field.setValue(null);
        field.setFieldType(FieldType.INTEGER);
        this.fieldActionsService.processActions(actions, (Field)field);
        field.setValue((Object)new Integer(0));
        field.setFieldType(FieldType.INTEGER);
        this.fieldActionsService.processActions(actions, (Field)field);
        class MockActions
        extends Actions {
            MockActions() {
            }

            public List<Action> getActions() {
                return null;
            }
        }
        this.fieldActionsService.processActions((Actions)new MockActions(), (Field)field);
        actions = new Actions();
        this.fieldActionsService.processActions(actions, (Field)field);
        actions.getActions().add(new Trim());
        field.setValue((Object)"testString");
        field.setFieldType(FieldType.STRING);
        this.fieldActionsService.processActions(actions, (Field)field);
        field.setValue((Object)new Integer(8));
        field.setFieldType(FieldType.NUMBER);
        this.fieldActionsService.processActions(actions, (Field)field);
    }

    @Test(expected=AtlasConversionException.class)
    public void testprocessActionsActionsObjectFieldTypeAtlasConversionException() throws AtlasException {
        Actions actions = null;
        SimpleField field = new SimpleField();
        Object value = new Object();
        field.setValue(value);
        field.setFieldType(FieldType.INTEGER);
        this.fieldActionsService.processActions(actions, (Field)field);
    }

    @Test
    public void testprocessActionsActionsObjectFieldType() throws AtlasException {
        Actions actions = new Actions();
        Assert.assertNotNull((Object)this.fieldActionsService.processActions(actions, (Object)"testString", FieldType.STRING));
        Assert.assertNotNull((Object)this.fieldActionsService.processActions(actions, (Object)new Integer(8), FieldType.STRING));
    }

    @Test
    public void testProcessActionWithActionActionDetailObject() throws AtlasException {
        ActionDetail actionDetail = null;
        String sourceObject = "String";
        Trim action = new Trim();
        Assert.assertEquals((Object)sourceObject, (Object)this.fieldActionsService.processAction((Action)action, actionDetail, (Object)sourceObject));
        action = new GenerateUUID();
        actionDetail = new ActionDetail();
        actionDetail.setClassName("io.atlasmap.actions.StringComplexFieldActions");
        actionDetail.setSourceType(FieldType.ANY);
        actionDetail.setMethod("genareteUUID");
        Assert.assertNotNull((Object)this.fieldActionsService.processAction((Action)action, actionDetail, (Object)sourceObject));
    }

    @Test(expected=AtlasException.class)
    public void testProcessActionWithActionActionDetailObjectAtlasException() throws AtlasException {
        AbsoluteValue action = new AbsoluteValue();
        Integer sourceObject = new Integer("1");
        ActionDetail actionDetail = new ActionDetail();
        actionDetail.setClassName("io.atlasmap.actions.NumberFieldActions");
        actionDetail.setSourceType(FieldType.INTEGER);
        actionDetail.setMethod("absoluteValue");
        this.fieldActionsService.processAction((Action)action, actionDetail, (Object)sourceObject);
    }

    @Test(expected=AtlasException.class)
    public void testProcessActionWithActionActionDetailObjectAtlasExceptionNoMethod() throws AtlasException {
        AbsoluteValue action = new AbsoluteValue();
        Integer sourceObject = new Integer("1");
        ActionDetail actionDetail = new ActionDetail();
        actionDetail.setClassName("io.atlasmap.actions.NumberFieldActions");
        actionDetail.setSourceType(FieldType.NUMBER);
        this.fieldActionsService.processAction((Action)action, actionDetail, (Object)sourceObject);
    }

    @Test
    public void testGetActionDetailByActionName() {
        Assert.assertNotNull((Object)this.fieldActionsService.getActionDetailByActionName("Add"));
        Assert.assertNull((Object)this.fieldActionsService.getActionDetailByActionName("AtlasAdd"));
    }

    @Test
    public void testCamelize() {
        Assert.assertNull((Object)DefaultAtlasFieldActionService.camelize(null));
        Assert.assertEquals((Object)"", (Object)DefaultAtlasFieldActionService.camelize((String)""));
    }
}

