/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasModuleInfo;
import io.atlasmap.core.DefaultAtlasModuleInfoRegistry;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleInfo;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DefaultAtlasModuleInfoRegistryTest {
    private static DefaultAtlasModuleInfoRegistry atlasModuleInfoRegistry;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        DefaultAtlasContextFactory factory = new DefaultAtlasContextFactory();
        factory.setObjectName("DefaultAtlasContextFactory");
        atlasModuleInfoRegistry = new DefaultAtlasModuleInfoRegistry(factory);
    }

    @Test
    public void testDefaultAtlasModuleInfoRegistry() {
        Assert.assertNotNull((Object)atlasModuleInfoRegistry);
    }

    @Test
    public void testLookupByUri() {
        Assert.assertNull((Object)atlasModuleInfoRegistry.lookupByUri(null));
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("java");
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("io.atlasmap.core");
        DefaultAtlasModuleInfo atlasModuleInfo = new DefaultAtlasModuleInfo("name", "atlas:java", AtlasModule.class, null, formats, packageNames);
        atlasModuleInfoRegistry.register((AtlasModuleInfo)atlasModuleInfo);
        Assert.assertNotNull((Object)atlasModuleInfoRegistry.lookupByUri("atlas:java"));
        Assert.assertNull((Object)atlasModuleInfoRegistry.lookupByUri("java"));
    }

    @Test
    public void testGetAll() {
        Assert.assertNotNull((Object)atlasModuleInfoRegistry.getAll());
    }

    @Test
    public void testRegister() {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("java");
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add("io.atlasmap.core");
        DefaultAtlasModuleInfo atlasModuleInfo = new DefaultAtlasModuleInfo("name", "atlas:java", AtlasModule.class, null, formats, packageNames);
        atlasModuleInfoRegistry.register((AtlasModuleInfo)atlasModuleInfo);
        Assert.assertEquals((long)1L, (long)atlasModuleInfoRegistry.size());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)atlasModuleInfoRegistry.size());
    }

    @Test
    public void testUnregisterAll() {
        atlasModuleInfoRegistry.unregisterAll();
        Assert.assertEquals((long)0L, (long)atlasModuleInfoRegistry.size());
    }
}

