/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasPropertyStrategy;
import io.atlasmap.core.PropertyModule;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.MockField;
import io.atlasmap.v2.PropertyField;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class PropertyModuleTest {
    private static PropertyModule module = new PropertyModule((AtlasPropertyStrategy)new DefaultAtlasPropertyStrategy());

    @Test
    public void testDestroy() {
        module.destroy();
    }

    @Test
    public void testProcessPreValidation() throws AtlasException {
        module.processPreValidation(null);
    }

    @Test
    public void testProcessPreSourceExecution() throws AtlasException {
        module.processPreSourceExecution(null);
    }

    @Test
    public void testProcessSourceFieldMapping() throws AtlasException {
        PropertyField field = (PropertyField)Mockito.mock(PropertyField.class);
        Mockito.when((Object)field.getValue()).thenReturn((Object)"fieldValue");
        AtlasInternalSession.Head head = (AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class);
        Mockito.when((Object)head.getSourceField()).thenReturn((Object)field);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)head);
        DefaultAtlasConversionService atlasConversionService = (DefaultAtlasConversionService)Mockito.mock(DefaultAtlasConversionService.class);
        Mockito.when((Object)atlasConversionService.fieldTypeFromClass((String)ArgumentMatchers.any(String.class))).thenReturn((Object)FieldType.ANY);
        module.setConversionService((AtlasConversionService)atlasConversionService);
        module.processSourceFieldMapping(session);
    }

    @Test
    public void testProcessPostSourceExecution() throws AtlasException {
        module.processPostSourceExecution(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProcessPreTargetExecution() throws AtlasException {
        module.processPreTargetExecution(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProcessTargetFieldMapping() throws AtlasException {
        module.processTargetFieldMapping(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testProcessPostTargetExecution() throws AtlasException {
        module.processPostTargetExecution(null);
    }

    @Test
    public void testProcessPostValidation() throws AtlasException {
        module.processPostValidation(null);
    }

    @Test
    public void testGetMode() {
        Assert.assertNotNull((Object)module.getMode());
    }

    @Test
    public void testGetConversionService() {
        Assert.assertNotNull((Object)module.getConversionService());
    }

    @Test
    public void testListSupportedModes() {
        Assert.assertNotNull((Object)module.listSupportedModes());
    }

    @Test
    public void testGetDocId() {
        Assert.assertNull((Object)module.getDocId());
    }

    @Test
    public void testGetUri() {
        Assert.assertNull((Object)module.getUri());
    }

    @Test
    public void testIsStatisticsSupported() {
        Assert.assertFalse((boolean)module.isStatisticsSupported());
    }

    @Test
    public void testIsStatisticsEnabled() {
        Assert.assertFalse((boolean)module.isStatisticsEnabled());
    }

    @Test
    public void testIsSupportedField() {
        Assert.assertFalse((boolean)module.isSupportedField((Field)new MockField()));
    }

    @Test
    public void testCloneField() throws AtlasException {
        Assert.assertNull((Object)module.cloneField((Field)new MockField()));
    }

    @Test
    public void testGetCollectionSize() throws AtlasException {
        Assert.assertEquals((long)0L, (long)module.getCollectionSize(null, null));
    }

    @Test
    public void testGetFieldActionService() {
        Assert.assertNull((Object)module.getFieldActionService());
    }

    @Test
    public void testInit() {
        module.init();
    }

    @Test
    public void testSetDocId() {
        module.setDocId(null);
    }

    @Test
    public void testSetUri() {
        module.setUri(null);
    }
}

