/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.AtlasValidationHelper;
import io.atlasmap.validators.DefaultAtlasValidationsHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AtlasValidationHelperTest {
    private AtlasValidationHelper validations = null;
    private AtlasValidationHelper atlasValidationHelper = null;
    private Validation error = null;
    private Validation warning = null;
    private Validation info = null;

    @Before
    public void setUp() {
        this.validations = new DefaultAtlasValidationsHelper();
        this.error = new Validation();
        this.error.setScope(ValidationScope.ALL);
        this.error.setMessage("Error message");
        this.error.setStatus(ValidationStatus.ERROR);
        this.validations.addValidation(this.error);
        this.warning = new Validation();
        this.warning.setScope(ValidationScope.DATA_SOURCE);
        this.warning.setId("atlas:testDataSource");
        this.warning.setMessage("Warning message");
        this.warning.setStatus(ValidationStatus.WARN);
        this.validations.addValidation(this.warning);
        this.info = new Validation();
        this.info.setScope(ValidationScope.MAPPING);
        this.info.setId("0001");
        this.info.setMessage("Information message");
        this.info.setStatus(ValidationStatus.INFO);
        this.validations.addValidation(this.info);
        this.atlasValidationHelper = new DefaultAtlasValidationsHelper();
    }

    @After
    public void tearDown() {
        this.validations = null;
        this.error = null;
        this.warning = null;
        this.info = null;
        this.atlasValidationHelper = null;
    }

    @Test
    public void testGetScope() {
        Assert.assertEquals((Object)ValidationScope.ALL, (Object)this.error.getScope());
        Assert.assertEquals((Object)ValidationScope.DATA_SOURCE, (Object)this.warning.getScope());
        Assert.assertEquals((Object)ValidationScope.MAPPING, (Object)this.info.getScope());
    }

    @Test
    public void testGetId() {
        Assert.assertNull((Object)this.error.getId());
        Assert.assertEquals((Object)"atlas:testDataSource", (Object)this.warning.getId());
        Assert.assertEquals((Object)"0001", (Object)this.info.getId());
    }

    @Test
    public void testGetDefaultMessage() {
        Assert.assertTrue((boolean)this.error.getMessage().equals("Error message"));
        Assert.assertTrue((boolean)this.warning.getMessage().equals("Warning message"));
        Assert.assertTrue((boolean)this.info.getMessage().equals("Information message"));
    }

    @Test
    public void testGetLevel() {
        Assert.assertTrue((this.error.getStatus().compareTo((Enum)ValidationStatus.ERROR) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.warning.getStatus().compareTo((Enum)ValidationStatus.WARN) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.info.getStatus().compareTo((Enum)ValidationStatus.INFO) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assert.assertThat((Object)this.error.getScope(), (Matcher)CoreMatchers.is((Object)ValidationScope.ALL));
        Assert.assertThat((Object)this.error.getId(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.error.getMessage(), (Matcher)CoreMatchers.is((Object)"Error message"));
        Assert.assertThat((Object)this.error.getStatus(), (Matcher)CoreMatchers.is((Object)ValidationStatus.ERROR));
        Assert.assertThat((Object)this.warning.getScope(), (Matcher)CoreMatchers.is((Object)ValidationScope.DATA_SOURCE));
        Assert.assertThat((Object)this.warning.getId(), (Matcher)CoreMatchers.is((Object)"atlas:testDataSource"));
        Assert.assertThat((Object)this.warning.getMessage(), (Matcher)CoreMatchers.is((Object)"Warning message"));
        Assert.assertThat((Object)this.warning.getStatus(), (Matcher)CoreMatchers.is((Object)ValidationStatus.WARN));
        Assert.assertThat((Object)this.info.getScope(), (Matcher)CoreMatchers.is((Object)ValidationScope.MAPPING));
        Assert.assertThat((Object)this.info.getId(), (Matcher)CoreMatchers.is((Object)"0001"));
        Assert.assertThat((Object)this.info.getMessage(), (Matcher)CoreMatchers.is((Object)"Information message"));
        Assert.assertThat((Object)this.info.getStatus(), (Matcher)CoreMatchers.is((Object)ValidationStatus.INFO));
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.error.equals(this.info));
    }

    @Test
    public void testGetAllValidations() {
        Assert.assertNotNull((Object)this.validations.getAllValidations());
    }

    @Test
    public void testHasErrors() {
        Assert.assertTrue((boolean)this.validations.hasErrors());
        Assert.assertFalse((boolean)this.atlasValidationHelper.hasErrors());
    }

    @Test
    public void testHasWarnings() {
        Assert.assertTrue((boolean)this.validations.hasWarnings());
        Assert.assertFalse((boolean)this.atlasValidationHelper.hasWarnings());
    }

    @Test
    public void testHasInfos() {
        Assert.assertTrue((boolean)this.validations.hasInfos());
        Assert.assertFalse((boolean)this.atlasValidationHelper.hasInfos());
    }

    @Test
    public void testGetCount() {
        Assert.assertEquals((long)3L, (long)this.validations.getCount());
        Assert.assertEquals((long)0L, (long)this.atlasValidationHelper.getCount());
    }

    @Test
    public void testValidationToString() {
        Assert.assertNotNull((Object)DefaultAtlasValidationsHelper.validationToString(null));
        Assert.assertNotNull((Object)DefaultAtlasValidationsHelper.validationToString((Validation)this.info));
    }
}

