/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.AddDays;
import io.atlasmap.v2.AddSeconds;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class DateFieldActions
implements AtlasFieldAction {
    @AtlasFieldActionInfo(name="AddDays", sourceType=FieldType.ANY_DATE, targetType=FieldType.ANY_DATE, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static ZonedDateTime addDays(Action action, ZonedDateTime input) {
        if (action == null || !(action instanceof AddDays)) {
            throw new IllegalArgumentException("Action must be an AddDays action");
        }
        if (input == null) {
            return null;
        }
        AddDays addDays = (AddDays)action;
        return input.plusDays(addDays.getDays() == null ? 0L : (long)addDays.getDays().intValue());
    }

    @AtlasFieldActionInfo(name="AddSeconds", sourceType=FieldType.ANY_DATE, targetType=FieldType.ANY_DATE, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static ZonedDateTime addSeconds(Action action, ZonedDateTime input) {
        if (action == null || !(action instanceof AddSeconds)) {
            throw new IllegalArgumentException("Action must be an AddSeconds action");
        }
        if (input == null) {
            return null;
        }
        AddSeconds addSeconds = (AddSeconds)action;
        return input.plusSeconds(addSeconds.getSeconds() == null ? 0L : (long)addSeconds.getSeconds().intValue());
    }

    @AtlasFieldActionInfo(name="CurrentDate", sourceType=FieldType.ANY, targetType=FieldType.ANY_DATE, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static ZonedDateTime currentDate(Action action, Object input) {
        return LocalDate.now().atStartOfDay(ZoneId.systemDefault());
    }

    @AtlasFieldActionInfo(name="CurrentDateTime", sourceType=FieldType.ANY, targetType=FieldType.ANY_DATE, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static ZonedDateTime currentDateTime(Action action, Object input) {
        return LocalDate.now().atStartOfDay(ZoneId.systemDefault());
    }

    @AtlasFieldActionInfo(name="CurrentTime", sourceType=FieldType.ANY, targetType=FieldType.DATE_TIME, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static ZonedDateTime currentTime(Action action, Object input) {
        return LocalTime.now().atDate(LocalDate.now()).atZone(ZoneId.systemDefault());
    }

    @AtlasFieldActionInfo(name="DayOfWeek", sourceType=FieldType.ANY_DATE, targetType=FieldType.INTEGER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Integer dayOfWeek(Action action, ZonedDateTime input) {
        return input == null ? null : Integer.valueOf(input.getDayOfWeek().getValue());
    }

    @AtlasFieldActionInfo(name="DayOfYear", sourceType=FieldType.ANY_DATE, targetType=FieldType.INTEGER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Integer dayOfYear(Action action, ZonedDateTime input) {
        return input == null ? null : Integer.valueOf(input.getDayOfYear());
    }
}

