/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Json;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMappingService
implements Serializable {
    private static final long serialVersionUID = 1668362984516180517L;
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMappingService.class);
    private static final String CONFIG_V2_PACKAGE = "io.atlasmap.v2";
    private transient JAXBContext ctx = null;
    private transient ObjectMapper jsonMapper = null;

    public AtlasMappingService() {
        try {
            ArrayList<String> tmp = new ArrayList<String>();
            tmp.add(CONFIG_V2_PACKAGE);
            this.initialize(tmp);
        }
        catch (Exception e) {
            LOG.error("Error initializing JAXB: " + e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public AtlasMappingService(List<String> modulePackages) {
        try {
            this.initialize(modulePackages);
        }
        catch (Exception e) {
            LOG.error("Error initializing JAXB: " + e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected void initialize(List<String> packages) throws JAXBException {
        if (this.getJAXBContext() == null) {
            this.setJAXBContext(JAXBContext.newInstance((String)this.stringListToColonSeparated(packages)));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized JAXBContext: " + this.stringListToColonSeparated(packages));
            }
        }
        this.jsonMapper = Json.mapper();
    }

    public AtlasMapping loadMapping(File file) throws AtlasValidationException {
        return this.loadMapping(file, AtlasMappingFormat.XML);
    }

    public AtlasMapping loadMapping(File file, AtlasMappingFormat format) throws AtlasValidationException {
        try {
            AtlasMapping atlasMapping;
            switch (format) {
                case XML: {
                    StreamSource streamSource = new StreamSource(file);
                    atlasMapping = (AtlasMapping)this.createUnmarshaller().unmarshal((Source)streamSource, AtlasMapping.class).getValue();
                    break;
                }
                case JSON: {
                    atlasMapping = (AtlasMapping)this.jsonMapper.readValue(file, AtlasMapping.class);
                    break;
                }
                default: {
                    throw new AtlasValidationException("Unsupported mapping format: " + format.value);
                }
            }
            this.validate(atlasMapping);
            return atlasMapping;
        }
        catch (Exception e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public AtlasMapping loadMapping(Reader reader) throws AtlasValidationException {
        return this.loadMapping(reader, AtlasMappingFormat.XML);
    }

    public AtlasMapping loadMapping(Reader reader, AtlasMappingFormat format) throws AtlasValidationException {
        try {
            AtlasMapping atlasMapping;
            switch (format) {
                case XML: {
                    StreamSource streamSource = new StreamSource(reader);
                    atlasMapping = (AtlasMapping)this.createUnmarshaller().unmarshal((Source)streamSource, AtlasMapping.class).getValue();
                    break;
                }
                case JSON: {
                    atlasMapping = (AtlasMapping)this.jsonMapper.readValue(reader, AtlasMapping.class);
                    break;
                }
                default: {
                    throw new AtlasValidationException("Unsupported mapping format: " + format.value);
                }
            }
            this.validate(atlasMapping);
            return atlasMapping;
        }
        catch (Exception e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public AtlasMapping loadMapping(String fileName, AtlasMappingFormat format) throws AtlasValidationException {
        return this.loadMapping(new File(fileName), format);
    }

    public AtlasMapping loadMapping(String fileName) throws AtlasValidationException {
        return this.loadMapping(fileName, AtlasMappingFormat.XML);
    }

    public AtlasMapping loadMapping(InputStream inputStream) throws AtlasValidationException {
        return this.loadMapping(inputStream, AtlasMappingFormat.XML);
    }

    public AtlasMapping loadMapping(InputStream inputStream, AtlasMappingFormat format) throws AtlasValidationException {
        return this.loadMapping(new InputStreamReader(inputStream), format);
    }

    public AtlasMapping loadMapping(URI uri) throws AtlasValidationException {
        return this.loadMapping(uri, AtlasMappingFormat.XML);
    }

    public AtlasMapping loadMapping(URI uri, AtlasMappingFormat format) throws AtlasValidationException {
        return this.loadMapping(new File(uri), format);
    }

    public AtlasMapping loadMapping(URL url) throws AtlasValidationException {
        return this.loadMapping(url, AtlasMappingFormat.XML);
    }

    public AtlasMapping loadMapping(URL url, AtlasMappingFormat format) throws AtlasValidationException {
        try {
            return this.loadMapping(new File(url.toURI()), format);
        }
        catch (URISyntaxException e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public void saveMappingAsFile(AtlasMapping atlasMapping, File file) throws AtlasException {
        this.saveMappingAsFile(atlasMapping, file, AtlasMappingFormat.XML);
    }

    public void saveMappingAsFile(AtlasMapping atlasMapping, File file, AtlasMappingFormat format) throws AtlasException {
        switch (format) {
            case JSON: {
                this.saveMappingAsJsonFile(atlasMapping, file);
                break;
            }
            case XML: {
                this.saveMappingAsXmlFile(atlasMapping, file);
                break;
            }
            default: {
                this.saveMappingAsXmlFile(atlasMapping, file);
            }
        }
    }

    protected void saveMappingAsJsonFile(AtlasMapping atlasMapping, File file) throws AtlasException {
        try {
            this.jsonMapper.writeValue(file, (Object)atlasMapping);
        }
        catch (Exception e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void saveMappingAsXmlFile(AtlasMapping atlasMapping, File file) throws AtlasException {
        try {
            this.createMarshaller().marshal((Object)atlasMapping, file);
        }
        catch (JAXBException e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public void validate(AtlasMapping atlasMapping) {
    }

    public JAXBContext getJAXBContext() {
        return this.ctx;
    }

    public void setJAXBContext(JAXBContext ctx) {
        this.ctx = ctx;
    }

    public Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        return this.getJAXBContext().createUnmarshaller();
    }

    public ObjectMapper getObjectMapper() {
        return this.jsonMapper;
    }

    public void setObjectMapper(ObjectMapper mapper) {
        this.jsonMapper = mapper;
    }

    private String stringListToColonSeparated(List<String> items) {
        StringBuilder buffer = new StringBuilder(CONFIG_V2_PACKAGE);
        if (items == null) {
            return null;
        }
        if (items.isEmpty()) {
            return buffer.toString();
        }
        boolean first = true;
        for (int i = 0; i < items.size(); ++i) {
            if (CONFIG_V2_PACKAGE.equals(items.get(i))) continue;
            if (first) {
                buffer.append(":");
                first = false;
            }
            buffer.append(items.get(i));
            if (i >= items.size() - 1) continue;
            buffer.append(":");
        }
        return buffer.toString();
    }

    public static enum AtlasMappingFormat {
        XML("xml"),
        JSON("json");

        private String value;

        private AtlasMappingFormat(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

