/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConverter;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class SqlTimestampConverter
implements AtlasConverter<Timestamp> {
    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public Calendar toCalendar(Timestamp timestamp) {
        return timestamp != null ? GregorianCalendar.from(ZonedDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME)
    public Date toDate(Timestamp timestamp) {
        return timestamp != null ? Date.from(timestamp.toInstant()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public GregorianCalendar toGregorianCalendar(Timestamp timestamp) {
        return timestamp != null ? GregorianCalendar.from(ZonedDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE)
    public LocalDate toLocalDate(Timestamp timestamp) {
        return timestamp != null ? timestamp.toLocalDateTime().toLocalDate() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(Timestamp timestamp) {
        return timestamp != null ? timestamp.toLocalDateTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.TIME)
    public LocalTime toLocalTime(Timestamp timestamp) {
        return timestamp != null ? timestamp.toLocalDateTime().toLocalTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE)
    public java.sql.Date toSqlDate(Timestamp timestamp) {
        return timestamp != null ? java.sql.Date.valueOf(timestamp.toLocalDateTime().toLocalDate()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.TIME)
    public Time toSqlTime(Timestamp timestamp) {
        return timestamp != null ? Time.valueOf(timestamp.toLocalDateTime().toLocalTime()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.DATE_TIME, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(Timestamp timestamp) {
        return timestamp != null ? ZonedDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault()) : null;
    }
}

