/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasConverter;
import io.atlasmap.api.AtlasValidationService;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class BaseModuleValidationService<T extends Field>
implements AtlasValidationService {
    private AtlasConversionService conversionService;
    private AtlasModuleMode mode;
    private String docId;

    public BaseModuleValidationService() {
        this.conversionService = DefaultAtlasConversionService.getInstance();
    }

    public BaseModuleValidationService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setMode(AtlasModuleMode mode) {
        this.mode = mode;
    }

    public AtlasModuleMode getMode() {
        return this.mode;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getDocId() {
        return this.docId;
    }

    protected abstract AtlasModuleDetail getModuleDetail();

    public List<Validation> validateMapping(AtlasMapping mapping) {
        ArrayList<Validation> validations = new ArrayList<Validation>();
        if (this.getMode() == AtlasModuleMode.UNSET) {
            Validation validation = new Validation();
            validation.setMessage(String.format("No mode specified for %s/%s, skipping module validations", this.getModuleDetail().name(), this.getClass().getSimpleName()));
        }
        if (mapping != null && mapping.getMappings() != null && mapping.getMappings().getMapping() != null && !mapping.getMappings().getMapping().isEmpty()) {
            this.validateMappingEntries(mapping.getMappings().getMapping(), validations);
        }
        boolean found = false;
        for (DataSource ds : mapping.getDataSource()) {
            if (ds.getUri() == null || !ds.getUri().startsWith(this.getModuleDetail().uri())) continue;
            found = true;
            break;
        }
        if (!found) {
            Validation validation = new Validation();
            validation.setScope(ValidationScope.DATA_SOURCE);
            validation.setMessage(String.format("No DataSource with '%s' uri specified", this.getModuleDetail().uri()));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        }
        return validations;
    }

    protected void validateCombineMapping(Mapping mapping, List<Validation> validations) {
        Field targetField;
        if (mapping == null) {
            return;
        }
        List sourceFields = mapping.getInputField();
        List targetFields = mapping.getOutputField();
        Field field = targetField = targetFields != null && !targetFields.isEmpty() ? (Field)targetFields.get(0) : null;
        if (targetField == null) {
            return;
        }
        String mappingId = mapping.getId();
        if (this.getMode() == AtlasModuleMode.TARGET && this.matchDocIdOrNull(targetField.getDocId())) {
            if (sourceFields != null) {
                for (Field sourceField : sourceFields) {
                    this.validateSourceAndTargetTypes(mappingId, sourceField, targetField, validations);
                }
            }
            if (targetField.getFieldType() != FieldType.STRING) {
                Validation validation = new Validation();
                validation.setScope(ValidationScope.MAPPING);
                validation.setId(mappingId);
                validation.setMessage(String.format("Output field '%s' must be of type '%s' for a Combine Mapping", this.getFieldName(targetField), FieldType.STRING));
                validation.setStatus(ValidationStatus.ERROR);
                validations.add(validation);
            }
            this.validateField(mappingId, targetField, FieldDirection.TARGET, validations);
        } else if (sourceFields != null) {
            for (Field sourceField : sourceFields) {
                if (!this.matchDocIdOrNull(sourceField.getDocId())) continue;
                this.validateField(mappingId, sourceField, FieldDirection.SOURCE, validations);
            }
        }
    }

    protected void validateMappingEntries(List<BaseMapping> mappings, List<Validation> validations) {
        for (BaseMapping fieldMapping : mappings) {
            if (fieldMapping.getClass().isAssignableFrom(Mapping.class) && MappingType.MAP.equals((Object)((Mapping)fieldMapping).getMappingType())) {
                this.validateMapMapping((Mapping)fieldMapping, validations);
                continue;
            }
            if (fieldMapping.getClass().isAssignableFrom(Mapping.class) && MappingType.SEPARATE.equals((Object)((Mapping)fieldMapping).getMappingType())) {
                this.validateSeparateMapping((Mapping)fieldMapping, validations);
                continue;
            }
            if (!fieldMapping.getClass().isAssignableFrom(Mapping.class) || !MappingType.COMBINE.equals((Object)((Mapping)fieldMapping).getMappingType())) continue;
            this.validateCombineMapping((Mapping)fieldMapping, validations);
        }
    }

    protected void validateMapMapping(Mapping mapping, List<Validation> validations) {
        Field sourceField = null;
        Field targetField = null;
        String mappingId = mapping.getId();
        if (mapping != null && mapping.getInputField() != null && mapping.getInputField().size() > 0) {
            sourceField = (Field)mapping.getInputField().get(0);
            if (this.getMode() == AtlasModuleMode.SOURCE && this.matchDocIdOrNull(sourceField.getDocId())) {
                this.validateField(mappingId, sourceField, FieldDirection.SOURCE, validations);
            }
        }
        if (mapping != null && mapping.getOutputField() != null && mapping.getOutputField().size() > 0) {
            targetField = (Field)mapping.getOutputField().get(0);
            if (this.getMode() == AtlasModuleMode.TARGET && this.matchDocIdOrNull(targetField.getDocId())) {
                this.validateField(mappingId, targetField, FieldDirection.TARGET, validations);
            }
        }
        if (sourceField != null && targetField != null && this.getMode() == AtlasModuleMode.SOURCE && this.matchDocIdOrNull(sourceField.getDocId())) {
            this.validateSourceAndTargetTypes(mappingId, sourceField, targetField, validations);
        }
    }

    protected void validateSeparateMapping(Mapping mapping, List<Validation> validations) {
        block7: {
            String mappingId;
            List targetFields;
            block6: {
                Field sourceField;
                if (mapping == null) {
                    return;
                }
                List sourceFields = mapping.getInputField();
                Field field = sourceField = sourceFields != null && !sourceFields.isEmpty() ? (Field)sourceFields.get(0) : null;
                if (sourceField == null) {
                    return;
                }
                targetFields = mapping.getOutputField();
                mappingId = mapping.getId();
                if (this.getMode() != AtlasModuleMode.SOURCE || !this.matchDocIdOrNull(sourceField.getDocId())) break block6;
                if (sourceField.getFieldType() != FieldType.STRING) {
                    Validation validation = new Validation();
                    validation.setScope(ValidationScope.MAPPING);
                    validation.setId(mapping.getId());
                    validation.setMessage(String.format("Input field '%s' must be of type '%s' for a Separate Mapping", this.getFieldName(sourceField), FieldType.STRING));
                    validation.setStatus(ValidationStatus.ERROR);
                    validations.add(validation);
                }
                this.validateField(mappingId, sourceField, FieldDirection.SOURCE, validations);
                if (targetFields == null) break block7;
                for (Field targetField : targetFields) {
                    this.validateSourceAndTargetTypes(mappingId, sourceField, targetField, validations);
                }
                break block7;
            }
            if (targetFields != null) {
                for (Field targetField : targetFields) {
                    if (!this.matchDocIdOrNull(targetField.getDocId())) continue;
                    this.validateField(mappingId, targetField, FieldDirection.TARGET, validations);
                }
            }
        }
    }

    protected void validateField(String mappingId, Field field, FieldDirection direction, List<Validation> validations) {
        if (field == null) {
            Validation validation = new Validation();
            validation.setScope(ValidationScope.MAPPING);
            validation.setId(mappingId);
            validation.setMessage(String.format("%s field %s is null", direction.value(), this.getFieldName(field)));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        } else if (this.getFieldType().isAssignableFrom(field.getClass())) {
            this.validateModuleField(mappingId, field, direction, validations);
        }
    }

    protected abstract Class<T> getFieldType();

    protected abstract void validateModuleField(String var1, T var2, FieldDirection var3, List<Validation> var4);

    protected void validateSourceAndTargetTypes(String mappingId, Field inputField, Field outField, List<Validation> validations) {
        if (inputField.getFieldType() != outField.getFieldType()) {
            this.validateFieldTypeConversion(mappingId, inputField, outField, validations);
        }
    }

    protected void validateFieldTypeConversion(String mappingId, Field inputField, Field outField, List<Validation> validations) {
        FieldType outFieldType;
        FieldType inFieldType = inputField.getFieldType();
        Optional atlasConverter = this.conversionService.findMatchingConverter(inFieldType, outFieldType = outField.getFieldType());
        if (!atlasConverter.isPresent()) {
            Validation validation = new Validation();
            validation.setScope(ValidationScope.MAPPING);
            validation.setId(mappingId);
            validation.setMessage(String.format("Conversion from '%s' to '%s' is required but no converter is available", inputField.getFieldType(), outField.getFieldType()));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        } else {
            Method[] methods = ((AtlasConverter)atlasConverter.get()).getClass().getMethods();
            AtlasConversionInfo conversionInfo = Arrays.stream(methods).map(method -> method.getAnnotation(AtlasConversionInfo.class)).filter(atlasConversionInfo -> atlasConversionInfo != null).filter(atlasConversionInfo -> atlasConversionInfo.sourceType().compareTo((Enum)inFieldType) == 0 && atlasConversionInfo.targetType().compareTo((Enum)outFieldType) == 0).findFirst().orElse(null);
            if (conversionInfo != null) {
                this.populateConversionConcerns(mappingId, conversionInfo, this.getFieldName(inputField), this.getFieldName(outField), validations);
            }
        }
    }

    protected void populateConversionConcerns(String mappingId, AtlasConversionInfo converterAnno, String inputFieldName, String outFieldName, List<Validation> validations) {
        if (converterAnno == null || converterAnno.concerns() == null) {
            return;
        }
        for (AtlasConversionConcern atlasConversionConcern : converterAnno.concerns()) {
            Validation validation;
            String message = atlasConversionConcern.getMessage(converterAnno);
            if (AtlasConversionConcern.NONE.equals((Object)atlasConversionConcern)) {
                validation = new Validation();
                validation.setScope(ValidationScope.MAPPING);
                validation.setId(mappingId);
                validation.setMessage(message);
                validation.setStatus(ValidationStatus.INFO);
                validations.add(validation);
                continue;
            }
            if (atlasConversionConcern.equals((Object)AtlasConversionConcern.RANGE) || atlasConversionConcern.equals((Object)AtlasConversionConcern.FORMAT) || atlasConversionConcern.equals((Object)AtlasConversionConcern.FRACTIONAL_PART) || atlasConversionConcern.equals((Object)AtlasConversionConcern.TIMEZONE)) {
                validation = new Validation();
                validation.setScope(ValidationScope.MAPPING);
                validation.setId(mappingId);
                validation.setMessage(message);
                validation.setStatus(ValidationStatus.WARN);
                validations.add(validation);
                continue;
            }
            if (!atlasConversionConcern.equals((Object)AtlasConversionConcern.UNSUPPORTED)) continue;
            validation = new Validation();
            validation.setScope(ValidationScope.MAPPING);
            validation.setId(mappingId);
            validation.setMessage(message);
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        }
    }

    private boolean matchDocIdOrNull(String docId) {
        return docId == null || this.getDocId().equals(docId);
    }

    protected String getFieldName(Field field) {
        if (field == null) {
            return "null";
        }
        if (field.getClass().isAssignableFrom(this.getFieldType())) {
            return this.getModuleFieldName(field);
        }
        if (field.getFieldType() != null) {
            return field.getFieldType().name();
        }
        return field.getClass().getName();
    }

    protected abstract String getModuleFieldName(T var1);

    protected AtlasConversionService getConversionService() {
        return this.conversionService;
    }

    protected void setConversionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

