/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.ExpressionFieldAction;
import io.atlasmap.v2.Expression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionFieldActionTest {
    @Test
    public void testIF() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(${0} == ${1}, 'same', 'not same')");
        Assert.assertEquals((Object)"same", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(10, 10)));
        Assert.assertEquals((Object)"not same", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(100, 10)));
    }

    @Test
    public void testIFInteger() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(${0} == 123, 123, 456)");
        Assert.assertEquals((Object)123, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(123)));
        Assert.assertEquals((Object)456, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(789)));
    }

    @Test
    public void testIFIntegerZero() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(${0} == 0, 0, 1)");
        Assert.assertEquals((Object)0, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(0)));
        Assert.assertEquals((Object)1, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1)));
    }

    @Test
    public void testGT() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(${0} > ${1}, ${0}, ${1})");
        Assert.assertEquals((Object)1000, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1000, 100)));
        Assert.assertEquals((Object)10000, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1000, 10000)));
        Assert.assertEquals((Object)10, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(10, -10)));
    }

    @Test
    public void testLT() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(LT(${0}, ${1}), ${0}, ${1})");
        Assert.assertEquals((Object)10, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(10, 100)));
        Assert.assertEquals((Object)100, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1000, 100)));
        Assert.assertEquals((Object)-10, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(10, -10)));
        action.setExpression("IF(${0} < ${1}, ${0}, ${1})");
        Assert.assertEquals((Object)10, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(10, 100)));
        Assert.assertEquals((Object)100, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1000, 100)));
        Assert.assertEquals((Object)-10, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(10, -10)));
    }

    @Test
    public void testTOLOWER() throws Exception {
        Expression action = new Expression();
        action.setExpression("TOLOWER(${0})");
        Assert.assertEquals((Object)"qwerty", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("qWeRtY")));
    }

    @Test
    public void testISEMPTY() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(ISEMPTY(${0}), 'empty', 'not empty')");
        Assert.assertEquals((Object)"empty", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(new Object[]{null})));
        Assert.assertEquals((Object)"empty", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("")));
        Assert.assertEquals((Object)"not empty", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(" ")));
    }

    @Test
    public void testAdd() throws Exception {
        Expression action = new Expression();
        action.setExpression("${0} + ${1}");
        Assert.assertEquals((Object)110, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(10, 100)));
        Assert.assertEquals((Object)"foobar", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("foo", "bar")));
    }

    @Test
    public void testSubtract() throws Exception {
        Expression action = new Expression();
        action.setExpression("${0} - ${1}");
        Assert.assertEquals((Object)90, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(100, 10)));
    }

    @Test
    public void testMultiply() throws Exception {
        Expression action = new Expression();
        action.setExpression("${0} * ${1}");
        Assert.assertEquals((Object)1000, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(100, 10)));
    }

    @Test
    public void testDivide() throws Exception {
        Expression action = new Expression();
        action.setExpression("${0} / ${1}");
        Assert.assertEquals((Object)10.0, (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(100, 10)));
    }

    @Test
    public void testAnd() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(${0} == ${1} && ${0} == ${2}, 'all same', 'not all same')");
        Assert.assertEquals((Object)"all same", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("foo", "foo", "foo")));
        Assert.assertEquals((Object)"all same", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1, 1, 1)));
        Assert.assertEquals((Object)"not all same", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("foo", "foo", "fo")));
        Assert.assertEquals((Object)"not all same", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1, 1, 2)));
    }

    @Test
    public void testOr() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(${0} == ${1} || ${0} == ${2}, 'some of them are same', 'all different')");
        Assert.assertEquals((Object)"some of them are same", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("foo", "foo", "fo")));
        Assert.assertEquals((Object)"some of them are same", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1, 1, 2)));
        Assert.assertEquals((Object)"all different", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("foo", "foo0", "fo")));
        Assert.assertEquals((Object)"all different", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1, 3, 2)));
    }

    @Test
    public void testNot() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(!ISEMPTY(${0}), 'not empty', 'empty')");
        Assert.assertEquals((Object)"not empty", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("foo")));
        Assert.assertEquals((Object)"not empty", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(" ")));
        Assert.assertEquals((Object)"empty", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("")));
        Assert.assertEquals((Object)"empty", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(new Object[]{null})));
    }

    @Test
    public void testNull() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(${0} == null, 'null', 'not null')");
        Assert.assertEquals((Object)"null", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(new Object[]{null})));
        Assert.assertEquals((Object)"not null", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList("")));
    }

    @Test
    public void testEmptyExpression() throws Exception {
        Expression action = new Expression();
        action.setExpression(null);
        Assert.assertEquals(null, (Object)ExpressionFieldAction.process((Expression)action, null));
        action.setExpression("");
        Assert.assertEquals(null, (Object)ExpressionFieldAction.process((Expression)action, null));
        action.setExpression("   ");
        Assert.assertEquals(null, (Object)ExpressionFieldAction.process((Expression)action, null));
    }

    @Test
    public void testNumberField() throws Exception {
        Expression action = new Expression();
        Integer integer = 1;
        action.setExpression("IF(${0} == 1, '1', 'not 1')");
        Assert.assertEquals((Object)"1", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(integer)));
        BigInteger bigInt = new BigInteger("1");
        action.setExpression("IF(${0} == 1, 'bigint 1', 'not bigint 1')");
        Assert.assertEquals((Object)"bigint 1", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(bigInt)));
        BigDecimal bigDec = new BigDecimal("1");
        action.setExpression("IF(${0} == 1, 'bigdecimal 1', 'not bigdecimal 1')");
        Assert.assertEquals((Object)"bigdecimal 1", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(bigDec)));
    }

    @Test
    public void testConcatenateActionWithDelimiter() throws Exception {
        Expression action = new Expression();
        action.setExpression("CONCATENATE(${0}, ${1}, ${2}, ${3})");
        Assert.assertEquals((Object)"a,b,c", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(",", "a", "b", "c")));
    }

    @Test
    public void testConcatenateActionWithMissingArguments() throws Exception {
        Expression action = new Expression();
        action.setExpression("CONCATENATE(${0})");
        try {
            ExpressionFieldAction.process((Expression)action, Arrays.asList(","));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals(IllegalArgumentException.class, e.getClass());
            Assert.assertEquals((Object)"The transformation 'CONCATENATE' expects more arguments", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddNestedAction() throws Exception {
        Expression action = new Expression();
        action.setExpression("IF(ADD(${0}, ${1}, ${2}) == ${3}, 'pass', 'fail')");
        Assert.assertEquals((Object)"pass", (Object)ExpressionFieldAction.process((Expression)action, Arrays.asList(1, 2, 3, 6)));
    }
}

