/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.Mappings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AtlasMappingServiceTest {
    private static AtlasMappingService atlasMappingService;
    private static AtlasMapping atlasMapping;

    @BeforeClass
    public static void setUpBeforeClass() {
        atlasMappingService = new AtlasMappingService();
        atlasMapping = new AtlasMapping();
        atlasMapping.setName("testname");
        Mappings mappings = new Mappings();
        Mapping mapping = new Mapping();
        mapping.setId("1");
        mapping.setAlias("alias1");
        mappings.getMapping().add(mapping);
        mapping = new Mapping();
        mapping.setId("2");
        mapping.setAlias("alias2");
        mappings.getMapping().add(mapping);
        atlasMapping.setMappings(mappings);
    }

    @AfterClass
    public static void tearDownAfterClass() {
        atlasMappingService = null;
        atlasMapping = null;
    }

    @Test
    public void testAtlasMappingService() {
        Assert.assertNotNull((Object)atlasMappingService);
    }

    @Test
    public void testInitialize() {
        atlasMappingService = new AtlasMappingService();
        Assert.assertNotNull((Object)atlasMappingService);
    }

    @Test
    public void testLoadMappingFileAtlasMappingFormat() throws AtlasValidationException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(file);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test(expected=AtlasValidationException.class)
    public void testLoadMappingFileAtlasMappingFormatAtlasValidationException() throws AtlasValidationException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping2.json", new String[0]).toFile();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(file);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingReader() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json"));
        AtlasMapping atlasMapping = atlasMappingService.loadMapping((Reader)reader);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test(expected=AtlasValidationException.class)
    public void testLoadMappingReaderAtlasMappingFormatAtlasValidationException() throws Exception {
        Reader reader = null;
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(reader);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingString() throws AtlasValidationException {
        String filename = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json";
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(filename);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingInputStream() throws Exception {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        FileInputStream fis = new FileInputStream(file);
        AtlasMapping atlasMapping = atlasMappingService.loadMapping((InputStream)fis);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingURI() throws Exception {
        URI uri = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toUri();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(uri);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testLoadMappingURL() throws Exception {
        URL url = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toUri().toURL();
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(url);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test(expected=AtlasValidationException.class)
    public void testLoadMappingURLAtlasMappingFormat() throws Exception {
        URL url = new URL("http://www.redhat.com/q/h?s=^IXIC");
        AtlasMapping atlasMapping = atlasMappingService.loadMapping(url);
        Assert.assertNotNull((Object)atlasMapping);
    }

    @Test
    public void testSetObjectMapper() {
        atlasMappingService.setObjectMapper(atlasMappingService.getObjectMapper());
    }

    @Test(expected=AtlasException.class)
    public void testSaveMappingAsFile() throws AtlasException {
        AtlasMappingService atlasMappingService = new AtlasMappingService();
        atlasMappingService.setObjectMapper(null);
        File file = Paths.get("target" + File.separator + "generated-test-sources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        atlasMappingService.saveMappingAsFile(atlasMapping, file);
    }
}

