/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasTestData;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.SimpleField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class BaseDefaultAtlasContextTest {
    protected DefaultAtlasContext context = null;
    protected BaseAtlasModule sourceModule = null;
    protected BaseAtlasModule targetModule = null;
    protected AtlasMapping mapping = null;
    protected DefaultAtlasSession session = null;
    protected MockFieldReader reader = null;
    protected MockFieldWriter writer = null;

    @Before
    public void init() throws AtlasException {
        this.mapping = AtlasTestData.generateAtlasMapping();
        this.context = new DefaultAtlasContext(DefaultAtlasContextFactory.getInstance(), this.mapping){

            protected void init() {
            }
        };
        this.sourceModule = this.mockAtlasModule();
        this.sourceModule.setMode(AtlasModuleMode.SOURCE);
        this.targetModule = this.mockAtlasModule();
        this.targetModule.setMode(AtlasModuleMode.TARGET);
        this.context.getSourceModules().put("ATLAS_DEFAULT_SOURCE_DOC", this.sourceModule);
        this.context.getTargetModules().put("ATLAS_DEFAULT_TARGET_DOC", this.targetModule);
        this.recreateSession();
    }

    protected void recreateSession() throws AtlasException {
        this.session = (DefaultAtlasSession)this.context.createSession();
        if (this.reader == null) {
            this.reader = new MockFieldReader();
        }
        this.session.setFieldReader("ATLAS_DEFAULT_SOURCE_DOC", (AtlasFieldReader)this.reader);
        if (this.writer == null) {
            this.writer = new MockFieldWriter();
        }
        this.session.setFieldWriter("ATLAS_DEFAULT_TARGET_DOC", (AtlasFieldWriter)this.writer);
    }

    private BaseAtlasModule mockAtlasModule() throws AtlasException {
        BaseAtlasModule module = (BaseAtlasModule)Mockito.spy(BaseAtlasModule.class);
        module.setConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        Mockito.when((Object)module.isSupportedField((Field)Mockito.any(Field.class))).thenReturn((Object)true);
        ((BaseAtlasModule)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AtlasInternalSession session = (AtlasInternalSession)invocation.getArguments()[0];
                Field field = session.head().getSourceField();
                field.setValue(BaseDefaultAtlasContextTest.this.reader.sources.get(field.getPath()));
                return null;
            }
        }).when((Object)module)).readSourceValue((AtlasInternalSession)Mockito.any());
        ((BaseAtlasModule)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AtlasInternalSession session = (AtlasInternalSession)invocation.getArguments()[0];
                LookupTable table = session.head().getLookupTable();
                Field source = session.head().getSourceField();
                Field target = session.head().getTargetField();
                Object value = source.getValue();
                if (table != null) {
                    for (LookupEntry e : table.getLookupEntry()) {
                        if (!value.equals(e.getSourceValue())) continue;
                        value = e.getTargetValue();
                    }
                }
                target.setValue(value);
                return null;
            }
        }).when((Object)module)).populateTargetField((AtlasInternalSession)Mockito.any());
        ((BaseAtlasModule)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AtlasInternalSession session = (AtlasInternalSession)invocation.getArguments()[0];
                BaseDefaultAtlasContextTest.this.writer.write(session);
                return null;
            }
        }).when((Object)module)).writeTargetValue((AtlasInternalSession)Mockito.any());
        return module;
    }

    protected Field populateSourceField(Mapping mapping, String docId, FieldType type, Object value, int index) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setDocId(docId);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field populateSourceField(Mapping mapping, FieldType type, Object value, int index) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field populateSourceField(Mapping mapping, FieldType type, Object value) {
        SimpleField field = new SimpleField();
        field.setFieldType(type);
        field.setPath("/testPath" + value);
        if (mapping != null) {
            mapping.getInputField().add(field);
        }
        this.reader.sources.put(field.getPath(), value);
        return field;
    }

    protected Field populateSourceField(Mapping mapping, String docId, FieldType type, Object value) {
        Field field = this.populateSourceField(mapping, type, value);
        field.setDocId(docId);
        return field;
    }

    protected Field populateUnsupportedSourceField(Mapping mapping, String docId, final String value, int index) {
        return this.populateSourceField(mapping, docId, FieldType.UNSUPPORTED, new Object(){

            public String toString() {
                return value;
            }
        }, index);
    }

    protected FieldGroup populateCollectionSourceField(Mapping mapping, String docId, String seed) {
        String basePath = "/testPath" + seed;
        FieldGroup fieldGroup = new FieldGroup();
        fieldGroup.setFieldType(FieldType.STRING);
        fieldGroup.setDocId(docId);
        fieldGroup.setPath(basePath + "<>");
        if (mapping != null) {
            mapping.setInputFieldGroup(fieldGroup);
        }
        for (int i = 0; i < 10; ++i) {
            SimpleField child = new SimpleField();
            child.setFieldType(FieldType.STRING);
            child.setDocId(docId);
            child.setPath(basePath + "<" + i + ">");
            child.setValue((Object)(seed + i));
            child.setIndex(Integer.valueOf(i));
            fieldGroup.getField().add(child);
            this.reader.sources.put(child.getPath(), child.getValue());
        }
        this.reader.sources.put(fieldGroup.getPath(), fieldGroup);
        return fieldGroup;
    }

    protected FieldGroup populateComplexCollectionSourceField(Mapping mapping, String docId, String seed) {
        String basePath = "/testPath" + seed;
        FieldGroup fieldGroup = new FieldGroup();
        fieldGroup.setFieldType(FieldType.COMPLEX);
        fieldGroup.setDocId(docId);
        fieldGroup.setPath(basePath + "<>");
        if (mapping != null) {
            mapping.setInputFieldGroup(fieldGroup);
        }
        ArrayList<SimpleField> terminals = new ArrayList<SimpleField>();
        for (int i = 0; i < 10; ++i) {
            FieldGroup child = new FieldGroup();
            child.setFieldType(FieldType.COMPLEX);
            child.setDocId(docId);
            child.setPath(basePath + "<" + i + ">");
            child.setIndex(Integer.valueOf(i));
            SimpleField terminal = new SimpleField();
            terminal.setFieldType(FieldType.STRING);
            terminal.setDocId(docId);
            terminal.setPath(basePath + "<" + i + ">/value");
            terminal.setValue((Object)(seed + i));
            child.getField().add(terminal);
            this.reader.sources.put(terminal.getPath(), terminal.getValue());
            fieldGroup.getField().add(child);
            this.reader.sources.put(child.getPath(), child);
            this.reader.sources.put(terminal.getPath(), terminal);
            terminals.add(terminal);
        }
        this.reader.sources.put(fieldGroup.getPath(), fieldGroup);
        FieldGroup valueGroup = AtlasModelFactory.copyFieldGroup((FieldGroup)fieldGroup);
        valueGroup.getField().addAll(terminals);
        valueGroup.setPath(fieldGroup.getPath() + "/value");
        this.reader.sources.put(valueGroup.getPath(), valueGroup);
        return fieldGroup;
    }

    protected Field populateUnsupportedSourceField(Mapping mapping, String value, int index) {
        return this.populateUnsupportedSourceField(mapping, null, value, index);
    }

    protected Field prepareTargetField(Mapping mapping, String path) {
        SimpleField field = new SimpleField();
        field.setPath(path);
        mapping.getOutputField().add(field);
        return field;
    }

    protected Field prepareTargetField(Mapping mapping, String path, int index) {
        Field field = this.prepareTargetField(mapping, path);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected Field prepareTargetField(Mapping mapping, FieldType type, String path, int index) {
        Field field = this.prepareTargetField(mapping, path);
        field.setFieldType(type);
        field.setPath(path);
        field.setIndex(Integer.valueOf(index));
        return field;
    }

    protected String printAudit(Audits audits) {
        StringBuilder buf = new StringBuilder("Audits: ");
        for (Audit a : audits.getAudit()) {
            buf.append('[');
            buf.append(a.getStatus());
            buf.append(", message=");
            buf.append(a.getMessage());
            buf.append("], ");
        }
        return buf.toString();
    }

    protected String printAudit(AtlasSession session) {
        return this.printAudit(session.getAudits());
    }

    protected class MockFieldWriter
    implements AtlasFieldWriter {
        protected Map<String, Object> targets = new HashMap<String, Object>();

        protected MockFieldWriter() {
        }

        public void write(AtlasInternalSession session) throws AtlasException {
            this.targets.put(session.head().getTargetField().getPath(), session.head().getTargetField().getValue());
        }
    }

    protected class MockFieldReader
    implements AtlasFieldReader {
        protected Map<String, Object> sources = new HashMap<String, Object>();

        protected MockFieldReader() {
        }

        public Field read(AtlasInternalSession session) throws AtlasException {
            Field field = session.head().getSourceField();
            Object value = this.sources.get(field.getPath());
            if (value instanceof Field) {
                session.head().setSourceField((Field)value);
                return (Field)value;
            }
            field.setValue(value);
            return field;
        }
    }
}

