/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Json;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMappingService
implements Serializable {
    private static final long serialVersionUID = 1668362984516180517L;
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMappingService.class);
    private transient ObjectMapper jsonMapper = null;

    public AtlasMappingService() {
        this(AtlasMapping.class.getClassLoader());
    }

    public AtlasMappingService(ClassLoader classLoader) {
        this.initialize(classLoader);
    }

    private void initialize(ClassLoader classLoader) {
        this.jsonMapper = Json.withClassLoader((ClassLoader)classLoader);
    }

    public AtlasMapping loadMapping(File file) throws AtlasValidationException {
        try {
            AtlasMapping atlasMapping = (AtlasMapping)this.jsonMapper.readValue(file, AtlasMapping.class);
            this.validate(atlasMapping);
            return atlasMapping;
        }
        catch (Exception e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public AtlasMapping loadMapping(Reader reader) throws AtlasValidationException {
        try {
            AtlasMapping atlasMapping = (AtlasMapping)this.jsonMapper.readValue(reader, AtlasMapping.class);
            this.validate(atlasMapping);
            return atlasMapping;
        }
        catch (Exception e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public AtlasMapping loadMapping(String fileName) throws AtlasValidationException {
        return this.loadMapping(new File(fileName));
    }

    public AtlasMapping loadMapping(InputStream inputStream) throws AtlasValidationException {
        return this.loadMapping(new InputStreamReader(inputStream));
    }

    public AtlasMapping loadMapping(URI uri) throws AtlasValidationException {
        return this.loadMapping(new File(uri));
    }

    public AtlasMapping loadMapping(URL url) throws AtlasValidationException {
        try {
            return this.loadMapping(new File(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public void saveMappingAsFile(AtlasMapping atlasMapping, File file) throws AtlasException {
        try {
            this.jsonMapper.writeValue(file, (Object)atlasMapping);
        }
        catch (Exception e) {
            throw new AtlasValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public void validate(AtlasMapping atlasMapping) {
    }

    public ObjectMapper getObjectMapper() {
        return this.jsonMapper;
    }

    public void setObjectMapper(ObjectMapper mapper) {
        this.jsonMapper = mapper;
    }
}

