/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompoundClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CompoundClassLoader.class);
    private Set<ClassLoader> delegates = new HashSet<ClassLoader>();

    CompoundClassLoader() {
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader cl : this.delegates) {
            try {
                return cl.loadClass(name);
            }
            catch (Throwable t) {
                LOG.debug("Class '{}' was not found with ClassLoader '{}': {}", (Object)name, (Object)cl);
                LOG.debug(t.getMessage(), t);
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader cl : this.delegates) {
            URL url = cl.getResource(name);
            if (url != null) {
                return url;
            }
            LOG.debug("Resource '{}' was not found with ClassLoader '{}': {}", (Object)name, (Object)cl);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        LinkedList<URL> answer = new LinkedList<URL>();
        for (ClassLoader cl : this.delegates) {
            try {
                Enumeration<URL> urls = cl.getResources(name);
                while (urls != null && urls.hasMoreElements()) {
                    answer.add(urls.nextElement());
                }
            }
            catch (Exception e) {
                LOG.debug("I/O error while looking for a resource '{}' with ClassLoader '{}': {}", (Object)name, (Object)cl);
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
        return Collections.enumeration(answer);
    }

    public synchronized void add(ClassLoader cl) {
        this.delegates.add(cl);
    }
}

