/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasConversionService
implements AtlasConversionService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasConversionService.class);
    private static final Set<String> PRIMITIVE_CLASSNAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short")));
    private static final Set<FieldType> PRIMITIVE_FIELDTYPES = Collections.unmodifiableSet(new HashSet<FieldType>(Arrays.asList(FieldType.BOOLEAN, FieldType.BYTE, FieldType.CHAR, FieldType.DECIMAL, FieldType.DOUBLE, FieldType.FLOAT, FieldType.INTEGER, FieldType.LONG, FieldType.SHORT, FieldType.STRING)));
    private static final Set<String> BOXED_PRIMITIVE_CLASSNAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String")));
    private static volatile DefaultAtlasConversionService instance = null;
    private static final Object singletonLock = new Object();
    private Map<ConverterKey, ConverterMethodHolder> converterMethods = null;
    private Map<ConverterKey, ConverterMethodHolder> customConverterMethods = null;

    private DefaultAtlasConversionService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultAtlasConversionService getInstance() {
        DefaultAtlasConversionService result = instance;
        if (result == null) {
            Object object = singletonLock;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    result = new DefaultAtlasConversionService();
                    result.init();
                    instance = result;
                }
            }
        }
        return result;
    }

    public static Set<String> listPrimitiveClassNames() {
        return PRIMITIVE_CLASSNAMES;
    }

    public Optional<AtlasConverter<?>> findMatchingConverter(FieldType source, FieldType target) {
        Class<?> sourceClass = this.classFromFieldType(source);
        Class<?> targetClass = this.classFromFieldType(target);
        if (sourceClass != null && targetClass != null) {
            return this.findMatchingConverter(sourceClass.getCanonicalName(), targetClass.getCanonicalName());
        }
        return Optional.empty();
    }

    public Optional<AtlasConverter<?>> findMatchingConverter(String sourceClassName, String targetClassName) {
        ConverterKey converterKey = new ConverterKey(sourceClassName, targetClassName);
        if (this.customConverterMethods.containsKey(converterKey)) {
            return Optional.of(this.customConverterMethods.get(converterKey).getConverter());
        }
        if (this.converterMethods.containsKey(converterKey)) {
            return Optional.of(this.converterMethods.get(converterKey).getConverter());
        }
        return Optional.empty();
    }

    private void init() {
        this.loadConverters();
    }

    private void loadConverters() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ServiceLoader<AtlasConverter> converterServiceLoader = ServiceLoader.load(AtlasConverter.class, classLoader);
        ServiceLoader<io.atlasmap.api.AtlasConverter> compat = ServiceLoader.load(io.atlasmap.api.AtlasConverter.class, classLoader);
        LinkedHashMap methodsLoadMap = new LinkedHashMap();
        LinkedHashMap customMethodsLoadMap = new LinkedHashMap();
        converterServiceLoader.forEach(atlasConverter -> this.loadConverterMethod((AtlasConverter<?>)atlasConverter, methodsLoadMap, customMethodsLoadMap));
        compat.forEach(atlasConverter -> this.loadConverterMethod((AtlasConverter<?>)atlasConverter, methodsLoadMap, customMethodsLoadMap));
        if (!methodsLoadMap.isEmpty()) {
            this.converterMethods = Collections.unmodifiableMap(methodsLoadMap);
        }
        if (!methodsLoadMap.isEmpty()) {
            this.customConverterMethods = Collections.unmodifiableMap(customMethodsLoadMap);
        }
    }

    private void loadConverterMethod(AtlasConverter<?> atlasConverter, Map<ConverterKey, ConverterMethodHolder> methodsLoadMap, Map<ConverterKey, ConverterMethodHolder> customMethodsLoadMap) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading converter : " + atlasConverter.getClass().getCanonicalName());
        }
        boolean inbuiltConverter = atlasConverter.getClass().getPackage().getName().startsWith("io.atlasmap");
        for (Class<?> klass = atlasConverter.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(klass.getDeclaredMethods()));
            for (Method method : allMethods) {
                if (!method.isAnnotationPresent(AtlasConversionInfo.class) || method.getParameters().length <= 0 || method.isSynthetic()) continue;
                String sourceClassName = method.getParameters()[0].getType().getCanonicalName();
                ConverterKey coordinate = new ConverterKey(sourceClassName, method.getReturnType().getCanonicalName());
                boolean containsFormat = false;
                if (method.getParameters().length == 3 && method.getParameters()[1].getType() == String.class && method.getParameters()[2].getType() == String.class) {
                    containsFormat = true;
                }
                boolean staticMethod = Modifier.isStatic(method.getModifiers());
                ConverterMethodHolder methodHolder = new ConverterMethodHolder(atlasConverter, method, staticMethod, containsFormat);
                if (inbuiltConverter) {
                    if (!methodsLoadMap.containsKey(coordinate)) {
                        methodsLoadMap.put(coordinate, methodHolder);
                        continue;
                    }
                    LOG.warn("Converter between " + sourceClassName + " and " + method.getReturnType().getCanonicalName() + " aleady exists.");
                    continue;
                }
                if (!customMethodsLoadMap.containsKey(coordinate)) {
                    customMethodsLoadMap.put(coordinate, methodHolder);
                    continue;
                }
                LOG.warn("Custom converter between " + sourceClassName + " and " + method.getReturnType().getCanonicalName() + " aleady exists.");
            }
        }
    }

    public Object copyPrimitive(Object sourceValue) {
        if (sourceValue == null) {
            return null;
        }
        Class<?> clazz = sourceValue.getClass();
        if (clazz == null) {
            return clazz;
        }
        if (Boolean.TYPE.getName().equals(clazz.getName())) {
            return (boolean)((Boolean)sourceValue);
        }
        if (Boolean.class.getName().equals(clazz.getName())) {
            return (boolean)((Boolean)sourceValue);
        }
        if (Byte.TYPE.getName().equals(clazz.getName())) {
            return (byte)((Byte)sourceValue);
        }
        if (Byte.class.getName().equals(clazz.getName())) {
            return (byte)((Byte)sourceValue);
        }
        if (Character.TYPE.getName().equals(clazz.getName())) {
            return Character.valueOf(((Character)sourceValue).charValue());
        }
        if (Character.class.getName().equals(clazz.getName())) {
            return Character.valueOf(((Character)sourceValue).charValue());
        }
        if (Double.TYPE.getName().equals(clazz.getName())) {
            return (double)((Double)sourceValue);
        }
        if (Double.class.getName().equals(clazz.getName())) {
            return (double)((Double)sourceValue);
        }
        if (Float.TYPE.getName().equals(clazz.getName())) {
            return Float.valueOf(((Float)sourceValue).floatValue());
        }
        if (Float.class.getName().equals(clazz.getName())) {
            return Float.valueOf(((Float)sourceValue).floatValue());
        }
        if (Integer.TYPE.getName().equals(clazz.getName())) {
            return (int)((Integer)sourceValue);
        }
        if (Integer.class.getName().equals(clazz.getName())) {
            return (int)((Integer)sourceValue);
        }
        if (Long.TYPE.getName().equals(clazz.getName())) {
            return (long)((Long)sourceValue);
        }
        if (Long.class.getName().equals(clazz.getName())) {
            return (long)((Long)sourceValue);
        }
        if (Short.TYPE.getName().equals(clazz.getName())) {
            return (short)((Short)sourceValue);
        }
        if (Short.class.getName().equals(clazz.getName())) {
            return (short)((Short)sourceValue);
        }
        return sourceValue;
    }

    public Object convertType(Object sourceValue, FieldType origSourceType, FieldType targetType) throws AtlasConversionException {
        if (origSourceType == null || targetType == null) {
            throw new AtlasConversionException("FieldTypes must be specified on convertType method.");
        }
        if (this.isAssignableFieldType(origSourceType, targetType).booleanValue()) {
            return sourceValue;
        }
        return this.convertType(sourceValue, null, this.classFromFieldType(targetType), null);
    }

    public Object convertType(Object sourceValue, String sourceFormat, FieldType targetType, String targetFormat) throws AtlasConversionException {
        return this.convertType(sourceValue, sourceFormat, this.classFromFieldType(targetType), targetFormat);
    }

    public Object convertType(Object sourceValue, String sourceFormat, Class<?> targetType, String targetFormat) throws AtlasConversionException {
        if (sourceValue == null || targetType == null) {
            throw new AtlasConversionException("AutoConversion requires sourceValue and targetType to be specified");
        }
        if (targetType.isInstance(sourceValue)) {
            return sourceValue;
        }
        ConverterMethodHolder methodHolder = this.getConverter(sourceValue, targetType);
        if (methodHolder != null) {
            try {
                AtlasConverter target;
                AtlasConverter atlasConverter = target = methodHolder.staticMethod ? null : methodHolder.converter;
                if (methodHolder.containsFormat) {
                    return methodHolder.method.invoke((Object)target, sourceValue, sourceFormat, targetFormat);
                }
                return methodHolder.method.invoke((Object)target, sourceValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new AtlasConversionException("Invoking type convertor failed", (Throwable)e);
            }
        }
        throw new AtlasConversionException("Type Conversion is not supported for sT=" + sourceValue.getClass().getCanonicalName() + " tT=" + targetType.getCanonicalName());
    }

    public boolean isConvertionAvailableFor(Object sourceValue, Class<?> targetType) {
        return targetType.isInstance(sourceValue) || this.getConverter(sourceValue, targetType) != null;
    }

    private ConverterMethodHolder getConverter(Object sourceValue, Class<?> targetType) {
        ConverterKey converterKey;
        ConverterMethodHolder methodHolder;
        Class<?> boxedSourceClass = sourceValue.getClass();
        if (sourceValue.getClass().isPrimitive()) {
            boxedSourceClass = this.boxOrUnboxPrimitive(boxedSourceClass);
        }
        Class<?> boxedTargetClass = targetType;
        if (targetType.isPrimitive()) {
            boxedTargetClass = this.boxOrUnboxPrimitive(boxedTargetClass);
        }
        if ((methodHolder = this.customConverterMethods.get(converterKey = new ConverterKey(boxedSourceClass.getCanonicalName(), boxedTargetClass.getCanonicalName()))) == null) {
            methodHolder = this.converterMethods.get(converterKey);
        }
        return methodHolder;
    }

    public Boolean isPrimitive(String className) {
        if (className == null) {
            return false;
        }
        if (PRIMITIVE_CLASSNAMES.contains(className)) {
            return true;
        }
        return false;
    }

    public Boolean isPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (PRIMITIVE_CLASSNAMES.contains(clazz.getCanonicalName())) {
            return true;
        }
        return false;
    }

    public Boolean isPrimitive(FieldType fieldType) {
        if (fieldType == null) {
            return false;
        }
        return PRIMITIVE_FIELDTYPES.contains(fieldType);
    }

    public Boolean isBoxedPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return BOXED_PRIMITIVE_CLASSNAMES.contains(clazz.getCanonicalName());
    }

    public Class<?> boxOrUnboxPrimitive(String clazzName) {
        return this.classFromFieldType(this.fieldTypeFromClass(clazzName));
    }

    public Class<?> boxOrUnboxPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return clazz;
        }
        if (Boolean.TYPE.getName().equals(clazz.getName())) {
            return Boolean.class;
        }
        if (Boolean.class.getName().equals(clazz.getName())) {
            return Boolean.TYPE;
        }
        if (Byte.TYPE.getName().equals(clazz.getName())) {
            return Byte.class;
        }
        if (Byte.class.getName().equals(clazz.getName())) {
            return Byte.TYPE;
        }
        if (Character.TYPE.getName().equals(clazz.getName())) {
            return Character.class;
        }
        if (Character.class.getName().equals(clazz.getName())) {
            return Character.TYPE;
        }
        if (Double.TYPE.getName().equals(clazz.getName())) {
            return Double.class;
        }
        if (Double.class.getName().equals(clazz.getName())) {
            return Double.TYPE;
        }
        if (Float.TYPE.getName().equals(clazz.getName())) {
            return Float.class;
        }
        if (Float.class.getName().equals(clazz.getName())) {
            return Float.TYPE;
        }
        if (Integer.TYPE.getName().equals(clazz.getName())) {
            return Integer.class;
        }
        if (Integer.class.getName().equals(clazz.getName())) {
            return Integer.TYPE;
        }
        if (Long.TYPE.getName().equals(clazz.getName())) {
            return Long.class;
        }
        if (Long.class.getName().equals(clazz.getName())) {
            return Long.TYPE;
        }
        if (Short.TYPE.getName().equals(clazz.getName())) {
            return Short.class;
        }
        if (Short.class.getName().equals(clazz.getName())) {
            return Short.TYPE;
        }
        return clazz;
    }

    public FieldType fieldTypeFromClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return this.fieldTypeFromClass(clazz.getName());
    }

    public FieldType fieldTypeFromClass(String className) {
        if (className == null || className.isEmpty()) {
            return FieldType.NONE;
        }
        switch (className) {
            case "java.lang.Object": {
                return FieldType.ANY;
            }
            case "java.math.BigInteger": {
                return FieldType.BIG_INTEGER;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return FieldType.BOOLEAN;
            }
            case "byte": 
            case "java.lang.Byte": {
                return FieldType.BYTE;
            }
            case "[B": 
            case "[Ljava.lang.Byte": {
                return FieldType.BYTE_ARRAY;
            }
            case "char": {
                return FieldType.CHAR;
            }
            case "java.lang.Character": {
                return FieldType.CHAR;
            }
            case "java.math.BigDecimal": {
                return FieldType.DECIMAL;
            }
            case "double": 
            case "java.lang.Double": {
                return FieldType.DOUBLE;
            }
            case "float": 
            case "java.lang.Float": {
                return FieldType.FLOAT;
            }
            case "int": 
            case "java.lang.Integer": 
            case "java.util.concurrent.atomic.AtomicInteger": {
                return FieldType.INTEGER;
            }
            case "long": 
            case "java.lang.Long": 
            case "java.util.concurrent.atomic.AtomicLong": {
                return FieldType.LONG;
            }
            case "java.lang.Number": {
                return FieldType.NUMBER;
            }
            case "short": 
            case "java.lang.Short": {
                return FieldType.SHORT;
            }
            case "java.lang.String": {
                return FieldType.STRING;
            }
            case "java.sql.Date": 
            case "java.time.LocalDate": 
            case "java.time.Month": 
            case "java.time.MonthDay": 
            case "java.time.Year": 
            case "java.time.YearMonth": {
                return FieldType.DATE;
            }
            case "java.sql.Time": 
            case "java.time.LocalTime": {
                return FieldType.TIME;
            }
            case "java.sql.Timestamp": 
            case "java.time.LocalDateTime": 
            case "java.util.Date": {
                return FieldType.DATE_TIME;
            }
            case "java.time.ZonedDateTime": 
            case "java.util.Calendar": 
            case "java.util.GregorianCalendar": {
                return FieldType.DATE_TIME_TZ;
            }
        }
        return FieldType.COMPLEX;
    }

    public Class<?> classFromFieldType(FieldType fieldType) {
        if (fieldType == null) {
            return null;
        }
        switch (fieldType) {
            case ANY: {
                return Object.class;
            }
            case BIG_INTEGER: {
                return BigInteger.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case BYTE_ARRAY: {
                return Byte[].class;
            }
            case CHAR: {
                return Character.class;
            }
            case COMPLEX: {
                return null;
            }
            case DATE: {
                return LocalDate.class;
            }
            case DATE_TIME: {
                return Date.class;
            }
            case DATE_TZ: 
            case TIME_TZ: 
            case DATE_TIME_TZ: {
                return ZonedDateTime.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case NONE: {
                return null;
            }
            case NUMBER: {
                return Number.class;
            }
            case SHORT: {
                return Short.class;
            }
            case STRING: {
                return String.class;
            }
            case TIME: {
                return LocalTime.class;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported field type '%s': corresponding Java class needs to be added in DefaultAtlasConversionService", fieldType));
    }

    public Boolean isAssignableFieldType(FieldType source, FieldType target) {
        if (source == null || target == null) {
            return Boolean.FALSE;
        }
        if (source.equals((Object)target) || target == FieldType.ANY) {
            return Boolean.TRUE;
        }
        if (target == FieldType.NUMBER) {
            return source == FieldType.BIG_INTEGER || source == FieldType.BYTE || source == FieldType.DECIMAL || source == FieldType.DOUBLE || source == FieldType.FLOAT || source == FieldType.INTEGER || source == FieldType.LONG || source == FieldType.SHORT;
        }
        return Boolean.FALSE;
    }

    private class ConverterMethodHolder {
        private AtlasConverter<?> converter;
        private Method method;
        private boolean staticMethod;
        private boolean containsFormat;

        public ConverterMethodHolder(AtlasConverter<?> converter, Method method, boolean staticMethod, boolean containsFormat) {
            this.converter = converter;
            this.method = method;
            this.staticMethod = staticMethod;
            this.containsFormat = containsFormat;
        }

        public AtlasConverter<?> getConverter() {
            return this.converter;
        }
    }

    private class ConverterKey {
        private String sourceClassName;
        private String targetClassName;

        public ConverterKey(String sourceClassName, String targetClassName) {
            this.sourceClassName = sourceClassName;
            this.targetClassName = targetClassName;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ConverterKey) {
                ConverterKey s = (ConverterKey)obj;
                return this.sourceClassName.equals(s.sourceClassName) && this.targetClassName.equals(s.targetClassName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.sourceClassName, this.targetClassName);
        }
    }
}

