/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.spi.AtlasPropertyType;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.PropertyField;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasPropertyStrategy
implements AtlasPropertyStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasPropertyStrategy.class);
    private boolean environmentPropertiesEnabled = true;
    private boolean systemPropertiesEnabled = true;
    private boolean mappingDefinedPropertiesEnabled = true;
    private boolean runtimePropertiesEnabled = true;
    private List<AtlasPropertyType> propertyOrder = Arrays.asList(AtlasPropertyType.RUNTIME_PROPERTIES, AtlasPropertyType.JAVA_SYSTEM_PROPERTIES, AtlasPropertyType.ENVIRONMENT_VARIABLES, AtlasPropertyType.MAPPING_DEFINED_PROPERTIES);
    private AtlasConversionService atlasConversionService = null;

    public void processPropertyField(AtlasMapping atlasMapping, PropertyField propertyField, Map<String, Object> runtimeProperties) throws AtlasUnsupportedException, AtlasConversionException {
        if (propertyField == null || propertyField.getName() == null || propertyField.getName().trim().length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Null or empty PropertyField specified popertyField=%s", AtlasModelFactory.toString((PropertyField)propertyField)));
            }
            return;
        }
        block6: for (AtlasPropertyType propType : this.getPropertyOrder()) {
            switch (propType) {
                case RUNTIME_PROPERTIES: {
                    if (!this.processRuntimeProperties(propertyField, runtimeProperties)) continue block6;
                    return;
                }
                case JAVA_SYSTEM_PROPERTIES: {
                    if (!this.processJavaSystemProperty(propertyField)) continue block6;
                    return;
                }
                case ENVIRONMENT_VARIABLES: {
                    if (!this.processEnvironmentVariable(propertyField)) continue block6;
                    return;
                }
                case MAPPING_DEFINED_PROPERTIES: {
                    if (!this.processMappingDefinedProperties(propertyField, atlasMapping)) continue block6;
                    return;
                }
            }
            throw new AtlasUnsupportedException(String.format("Unsupported PropertyType detected type=%s for field=%s", propType, AtlasModelFactory.toString((PropertyField)propertyField)));
        }
    }

    protected boolean processEnvironmentVariable(PropertyField propertyField) throws AtlasConversionException {
        if (!this.isEnvironmentPropertiesEnabled()) {
            return false;
        }
        try {
            if (System.getenv(propertyField.getName()) != null) {
                String propertyValue = System.getenv(propertyField.getName());
                if (this.getAtlasConversionService() != null && propertyField.getFieldType() != null) {
                    propertyField.setValue(this.getAtlasConversionService().convertType((Object)propertyValue, null, this.atlasConversionService.classFromFieldType(propertyField.getFieldType()), null));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Assigned environment variable property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                    }
                } else {
                    propertyField.setValue((Object)propertyValue);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Assigned environment variable for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                    }
                }
                return true;
            }
        }
        catch (SecurityException e) {
            LOG.error(String.format("SecurityException while processing environment variable for propertyField=%s", AtlasModelFactory.toString((PropertyField)propertyField)), (Throwable)e);
        }
        return false;
    }

    protected boolean processJavaSystemProperty(PropertyField propertyField) throws AtlasConversionException {
        if (!this.isSystemPropertiesEnabled()) {
            return false;
        }
        try {
            if (System.getProperty(propertyField.getName()) != null) {
                String propertyValue = System.getProperty(propertyField.getName());
                if (this.getAtlasConversionService() != null && propertyField.getFieldType() != null) {
                    propertyField.setValue(this.getAtlasConversionService().convertType((Object)propertyValue, null, this.atlasConversionService.classFromFieldType(propertyField.getFieldType()), null));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Assigned Java system property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                    }
                } else {
                    propertyField.setValue((Object)propertyValue);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Assigned Java system property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                    }
                }
                return true;
            }
        }
        catch (SecurityException e) {
            LOG.error(String.format("SecurityException while processing Java system property for propertyField=%s", AtlasModelFactory.toString((PropertyField)propertyField)), (Throwable)e);
        }
        return false;
    }

    protected boolean processMappingDefinedProperties(PropertyField propertyField, AtlasMapping atlasMapping) throws AtlasConversionException {
        if (!this.isMappingDefinedPropertiesEnabled()) {
            return false;
        }
        if (atlasMapping == null || atlasMapping.getProperties() == null || atlasMapping.getProperties().getProperty() == null || atlasMapping.getProperties().getProperty().isEmpty()) {
            return false;
        }
        for (Property prop : atlasMapping.getProperties().getProperty()) {
            if (!propertyField.getName().equals(prop.getName())) continue;
            if (this.getAtlasConversionService() != null && (propertyField.getFieldType() != null || prop.getFieldType() != null)) {
                propertyField.setValue(this.getAtlasConversionService().convertType((Object)prop.getValue(), FieldType.STRING, propertyField.getFieldType() != null ? propertyField.getFieldType() : prop.getFieldType()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Assigned Mapping defined property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                }
            } else {
                propertyField.setValue((Object)prop.getValue());
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Assigned Mapping defined property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                }
            }
            return true;
        }
        return false;
    }

    protected boolean processRuntimeProperties(PropertyField propertyField, Map<String, Object> runtimeProperties) throws AtlasConversionException {
        if (!this.isRuntimePropertiesEnabled() || runtimeProperties == null || runtimeProperties.isEmpty()) {
            return false;
        }
        String key = propertyField.getName();
        if (key == null || key.isEmpty() || !runtimeProperties.containsKey(key)) {
            return false;
        }
        if (this.getAtlasConversionService() != null && propertyField.getFieldType() != null) {
            propertyField.setValue(this.getAtlasConversionService().convertType(runtimeProperties.get(key), null, this.atlasConversionService.classFromFieldType(propertyField.getFieldType()), null));
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Assigned Runtime defined property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
            }
        } else {
            propertyField.setValue(runtimeProperties.get(key));
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Assigned Runtime defined property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
            }
        }
        return true;
    }

    public void setPropertyOrderValue(List<String> propertyValues) {
        LinkedList<AtlasPropertyType> tmp = null;
        for (String v : propertyValues) {
            if (tmp == null) {
                tmp = new LinkedList<AtlasPropertyType>();
            }
            try {
                tmp.add(AtlasPropertyType.fromValue((String)v));
            }
            catch (IllegalArgumentException e) {
                LOG.error(String.format("Invalid AtlasPropertyType specified '%s'", v));
            }
        }
        this.propertyOrder = null;
        this.propertyOrder = tmp;
    }

    public boolean isEnvironmentPropertiesEnabled() {
        return this.environmentPropertiesEnabled;
    }

    public void setEnvironmentPropertiesEnabled(boolean environmentPropertiesEnabled) {
        this.environmentPropertiesEnabled = environmentPropertiesEnabled;
    }

    public boolean isSystemPropertiesEnabled() {
        return this.systemPropertiesEnabled;
    }

    public void setSystemPropertiesEnabled(boolean systemPropertiesEnabled) {
        this.systemPropertiesEnabled = systemPropertiesEnabled;
    }

    public boolean isMappingDefinedPropertiesEnabled() {
        return this.mappingDefinedPropertiesEnabled;
    }

    public void setMappingDefinedPropertiesEnabled(boolean mappingDefinedPropertiesEnabled) {
        this.mappingDefinedPropertiesEnabled = mappingDefinedPropertiesEnabled;
    }

    public boolean isRuntimePropertiesEnabled() {
        return this.runtimePropertiesEnabled;
    }

    public void setRuntimePropertiesEnabled(boolean runtimePropertiesEnabled) {
        this.runtimePropertiesEnabled = runtimePropertiesEnabled;
    }

    public List<AtlasPropertyType> getPropertyOrder() {
        return this.propertyOrder;
    }

    public void setPropertyOrder(List<AtlasPropertyType> propertyOrder) {
        this.propertyOrder = propertyOrder;
    }

    public AtlasConversionService getAtlasConversionService() {
        return this.atlasConversionService;
    }

    public void setAtlasConversionService(AtlasConversionService atlasConversionService) {
        this.atlasConversionService = atlasConversionService;
    }
}

