/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.TemplateCombineStrategy;
import io.atlasmap.spi.AtlasCollectionHelper;
import io.atlasmap.spi.AtlasCombineStrategy;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.DataSourceMetadata;
import io.atlasmap.v2.Field;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasContextFactoryTest {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasContextFactoryTest.class);
    private DefaultAtlasContextFactory factory = null;

    @Test
    public void testInitDestroy() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.init();
        Assert.assertNotNull((Object)this.factory);
        Assert.assertNotNull((Object)this.factory.getThreadName());
        Assert.assertEquals((Object)"io.atlasmap.core.DefaultAtlasContextFactory", (Object)this.factory.getClassName());
        Assert.assertNotNull((Object)this.factory.getUuid());
        Assert.assertNotNull((Object)this.factory.getJmxObjectName());
        Assert.assertNotNull((Object)this.factory.getMappingService());
        Assert.assertNotNull((Object)this.factory.getModuleInfoRegistry());
        this.factory.destroy();
        Assert.assertNotNull((Object)this.factory);
        Assert.assertNull((Object)this.factory.getThreadName());
        Assert.assertEquals((Object)"io.atlasmap.core.DefaultAtlasContextFactory", (Object)this.factory.getClassName());
        Assert.assertNull((Object)this.factory.getUuid());
        Assert.assertNull((Object)this.factory.getJmxObjectName());
        Assert.assertNull((Object)this.factory.getMappingService());
        Assert.assertNull((Object)this.factory.getModuleInfoRegistry());
    }

    @Test
    public void testInitDestroyInitDestroy() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.init();
        String origUuid = this.factory.getUuid();
        Assert.assertNotNull((Object)this.factory);
        Assert.assertNotNull((Object)this.factory.getThreadName());
        Assert.assertEquals((Object)"io.atlasmap.core.DefaultAtlasContextFactory", (Object)this.factory.getClassName());
        Assert.assertNotNull((Object)this.factory.getUuid());
        Assert.assertNotNull((Object)this.factory.getJmxObjectName());
        Assert.assertNotNull((Object)this.factory.getMappingService());
        Assert.assertNotNull((Object)this.factory.getModuleInfoRegistry());
        this.factory.destroy();
        Assert.assertNotNull((Object)this.factory);
        Assert.assertNull((Object)this.factory.getThreadName());
        Assert.assertEquals((Object)"io.atlasmap.core.DefaultAtlasContextFactory", (Object)this.factory.getClassName());
        Assert.assertNull((Object)this.factory.getUuid());
        Assert.assertNull((Object)this.factory.getJmxObjectName());
        Assert.assertNull((Object)this.factory.getMappingService());
        Assert.assertNull((Object)this.factory.getModuleInfoRegistry());
        this.factory.init();
        Assert.assertNotNull((Object)this.factory);
        Assert.assertNotNull((Object)this.factory.getThreadName());
        Assert.assertEquals((Object)"io.atlasmap.core.DefaultAtlasContextFactory", (Object)this.factory.getClassName());
        Assert.assertNotNull((Object)this.factory.getUuid());
        Assert.assertNotNull((Object)this.factory.getJmxObjectName());
        Assert.assertNotNull((Object)this.factory.getMappingService());
        Assert.assertNotNull((Object)this.factory.getModuleInfoRegistry());
        Assert.assertNotEquals((Object)origUuid, (Object)this.factory.getUuid());
        this.factory.destroy();
        Assert.assertNotNull((Object)this.factory);
        Assert.assertNull((Object)this.factory.getThreadName());
        Assert.assertEquals((Object)"io.atlasmap.core.DefaultAtlasContextFactory", (Object)this.factory.getClassName());
        Assert.assertNull((Object)this.factory.getUuid());
        Assert.assertNull((Object)this.factory.getJmxObjectName());
        Assert.assertNull((Object)this.factory.getMappingService());
        Assert.assertNull((Object)this.factory.getModuleInfoRegistry());
    }

    @Test
    public void testStaticFactoryInitDestroy() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.init();
        Assert.assertNotNull((Object)this.factory);
        Assert.assertNotNull((Object)this.factory.getThreadName());
        Assert.assertEquals((Object)"io.atlasmap.core.DefaultAtlasContextFactory", (Object)this.factory.getClassName());
        Assert.assertNotNull((Object)this.factory.getUuid());
        Assert.assertNotNull((Object)this.factory.getJmxObjectName());
        Assert.assertNotNull((Object)this.factory.getMappingService());
        Assert.assertNotNull((Object)this.factory.getModuleInfoRegistry());
        this.factory.destroy();
        Assert.assertNotNull((Object)this.factory);
        Assert.assertNull((Object)this.factory.getThreadName());
        Assert.assertEquals((Object)"io.atlasmap.core.DefaultAtlasContextFactory", (Object)this.factory.getClassName());
        Assert.assertNull((Object)this.factory.getUuid());
        Assert.assertNull((Object)this.factory.getJmxObjectName());
        Assert.assertNull((Object)this.factory.getMappingService());
        Assert.assertNull((Object)this.factory.getModuleInfoRegistry());
    }

    @Test
    public void testDefaultAtlasContextFactoryProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        DefaultAtlasContextFactory contextFactory = DefaultAtlasContextFactory.getInstance();
        contextFactory.init();
        contextFactory.setProperties(properties);
        contextFactory.setThreadName("threadName");
        contextFactory.setModuleInfoRegistry(null);
        contextFactory.setCombineStrategy(null);
        contextFactory.setPropertyStrategy(null);
        contextFactory.setSeparateStrategy(null);
        contextFactory.setValidationService(null);
        Assert.assertNull((Object)contextFactory.getCombineStrategy());
        Assert.assertNull((Object)contextFactory.getPropertyStrategy());
        Assert.assertNull((Object)contextFactory.getSeparateStrategy());
        Assert.assertNull((Object)contextFactory.getValidationService());
        Assert.assertNull((Object)contextFactory.getVersion());
        Assert.assertNotNull((Object)contextFactory);
        Assert.assertNotNull((Object)contextFactory.getProperties());
        TemplateCombineStrategy strategy = new TemplateCombineStrategy();
        contextFactory.setCombineStrategy((AtlasCombineStrategy)strategy);
        Assert.assertSame((Object)strategy, (Object)contextFactory.getCombineStrategy());
        contextFactory.destroy();
    }

    @Test
    public void testCreateContextWithFile() throws AtlasException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.init();
        Assert.assertNotNull((Object)this.factory.createContext(file));
    }

    @Test
    public void testCreateContextWithAtlasMapping() throws AtlasException {
        AtlasMapping atlasMapping = new AtlasMapping();
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.init();
        Assert.assertNotNull((Object)this.factory.createContext(atlasMapping));
    }

    @Test(expected=AtlasException.class)
    public void testCreateContextWithFileAtlasMappingFormat() throws AtlasException {
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.init();
        File file = null;
        Assert.assertNotNull((Object)this.factory.createContext(file));
    }

    @Test
    public void testCreateContextWithURI() throws AtlasException {
        File file = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "atlasmapping.json", new String[0]).toFile();
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.init();
        Assert.assertNotNull((Object)this.factory.createContext(file.toURI()));
    }

    @Test(expected=AtlasException.class)
    public void testCreateContextWithURIAtlasExceptionNoUri() throws AtlasException {
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.init();
        URI uri = null;
        Assert.assertNotNull((Object)this.factory.createContext(uri));
    }

    @Test
    public void testIsClassAtlasModule() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        Assert.assertFalse((boolean)this.factory.isClassAtlasModule(null, null));
        Assert.assertFalse((boolean)this.factory.isClassAtlasModule(AtlasModuleDetail.class, AtlasModule.class));
        Assert.assertFalse((boolean)this.factory.isAtlasModuleInterface(null, null));
    }

    @Test
    public void testGetModuleName() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        Assert.assertNotNull((Object)this.factory.getModuleName(Object.class));
    }

    @Test
    public void testRegisterFactoryJmx() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.factory.registerFactoryJmx(null);
    }

    @Test
    public void testGetModuleUri() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        Assert.assertEquals((Object)"UNDEFINED", (Object)this.factory.getModuleUri(Object.class));
    }

    @Test
    public void testGetConfigPackages() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        Assert.assertNotNull((Object)this.factory.getConfigPackages(MockModule.class));
    }

    @Test
    public void testGetSupportedDataFormats() {
        this.factory = DefaultAtlasContextFactory.getInstance();
        Assert.assertNotNull((Object)this.factory.getSupportedDataFormats(MockModule.class));
    }

    @AtlasModuleDetail(name="ConstantModule", uri="", modes={"SOURCE"}, dataFormats={"xml", "json"}, configPackages={"io.atlasmap.core"})
    private class MockModule
    implements AtlasModule {
        private ClassLoader classLoader;

        private MockModule() {
        }

        public void init() {
            LOG.debug("init method");
        }

        public void destroy() {
            LOG.debug("destroy method");
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void processPreValidation(AtlasInternalSession session) throws AtlasException {
            LOG.debug("processPreValidation method");
        }

        public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
            LOG.debug("processPreSourceExecution method");
        }

        public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
            LOG.debug("processPreTargetExecution method");
        }

        public void readSourceValue(AtlasInternalSession session) throws AtlasException {
            LOG.debug("processSourceFieldMapping method");
        }

        public void populateTargetField(AtlasInternalSession session) throws AtlasException {
            LOG.debug("populateTargetField method");
        }

        public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
            LOG.debug("processTargetFieldMapping method");
        }

        public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
            LOG.debug("processPostSourceExecution method");
        }

        public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
            LOG.debug("processPostTargetExecution method");
        }

        public void processPostValidation(AtlasInternalSession session) throws AtlasException {
            LOG.debug("processPostValidation method");
        }

        public AtlasModuleMode getMode() {
            return null;
        }

        public void setMode(AtlasModuleMode atlasModuleMode) {
            LOG.debug("setMode method");
        }

        public AtlasConversionService getConversionService() {
            return null;
        }

        public void setConversionService(AtlasConversionService atlasConversionService) {
            LOG.debug("setConversionService method");
        }

        public AtlasFieldActionService getFieldActionService() {
            return null;
        }

        public AtlasCollectionHelper getCollectionHelper() {
            return null;
        }

        public void setFieldActionService(AtlasFieldActionService atlasFieldActionService) {
            LOG.debug("setFieldActionService method");
        }

        public List<AtlasModuleMode> listSupportedModes() {
            return null;
        }

        public String getDocId() {
            return null;
        }

        public void setDocId(String docId) {
            LOG.debug("setDocId method");
        }

        public String getUri() {
            return null;
        }

        public void setUri(String uri) {
            LOG.debug("setUri method");
        }

        public Boolean isStatisticsSupported() {
            return null;
        }

        public Boolean isStatisticsEnabled() {
            return null;
        }

        public Boolean isSupportedField(Field field) {
            return null;
        }

        public Field cloneField(Field field) throws AtlasException {
            return null;
        }

        public String getUriDataType() {
            return null;
        }

        public Map<String, String> getUriParameters() {
            return null;
        }

        public void setDataSourceMetadata(DataSourceMetadata meta) {
        }

        public DataSourceMetadata getDataSourceMetadata() {
            return null;
        }
    }
}

