/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasCollectionHelper;
import io.atlasmap.mxbean.AtlasModuleMXBean;
import io.atlasmap.spi.AtlasCollectionHelper;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.DataSourceMetadata;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.SimpleField;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.TabularData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAtlasModule
implements AtlasModule,
AtlasModuleMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAtlasModule.class);
    private boolean automaticallyProcessOutputFieldActions = true;
    private AtlasConversionService atlasConversionService = null;
    private AtlasFieldActionService atlasFieldActionService = null;
    private AtlasCollectionHelper collectionHelper = null;
    private AtlasModuleMode atlasModuleMode = AtlasModuleMode.UNSET;
    private String docId;
    private String uri;
    private String uriDataType;
    private Map<String, String> uriParameters = new HashMap<String, String>();
    private ClassLoader classLoader;
    private DataSourceMetadata dataSourceMetadata;

    public void init() throws AtlasException {
    }

    public void destroy() throws AtlasException {
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void processPostValidation(AtlasInternalSession session) throws AtlasException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: processPostValidation completed", (Object)this.getDocId());
        }
    }

    public void populateTargetField(AtlasInternalSession session) throws AtlasException {
        Field sourceField = session.head().getSourceField();
        Field targetField = session.head().getTargetField();
        Object targetValue = null;
        if (sourceField.getFieldType() != null && sourceField.getFieldType().equals((Object)targetField.getFieldType())) {
            targetValue = sourceField.getValue();
        } else if (sourceField.getValue() != null) {
            try {
                targetValue = this.getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), targetField.getFieldType(), targetField.getFormat());
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), String.format("Unable to auto-convert for sT=%s tT=%s tF=%s msg=%s", sourceField.getFieldType(), targetField.getFieldType(), targetField.getPath(), e.getMessage()), targetField.getPath(), AuditStatus.ERROR, null);
                return;
            }
        }
        targetField.setValue(targetValue);
        LookupTable lookupTable = session.head().getLookupTable();
        if (lookupTable != null) {
            this.processLookupField(session, lookupTable, targetField.getValue(), targetField);
        }
    }

    protected void processLookupField(AtlasInternalSession session, LookupTable lookupTable, Object sourceValue, Field targetField) throws AtlasException {
        String lookupValue = null;
        FieldType lookupType = null;
        for (LookupEntry lkp : lookupTable.getLookupEntry()) {
            if (!lkp.getSourceValue().equals(sourceValue)) continue;
            lookupValue = lkp.getTargetValue();
            lookupType = lkp.getTargetType();
            break;
        }
        Object targetValue = null;
        targetValue = lookupType == null || FieldType.STRING.equals(lookupType) ? lookupValue : this.atlasConversionService.convertType((Object)lookupValue, FieldType.STRING, lookupType);
        if (targetField.getFieldType() != null && !targetField.getFieldType().equals(lookupType)) {
            targetValue = this.atlasConversionService.convertType(targetValue, lookupType, targetField.getFieldType());
        }
        targetField.setValue(targetValue);
    }

    protected Field applyTargetFieldActions(AtlasInternalSession session) throws AtlasException {
        Field field = session.head().getTargetField();
        if (this.isAutomaticallyProcessOutputFieldActions() && field.getActions() != null && field.getActions() != null) {
            return this.getFieldActionService().processActions(session, field);
        }
        return field;
    }

    protected Field applySourceFieldActions(AtlasInternalSession session) throws AtlasException {
        Field field = session.head().getSourceField();
        if (field.getActions() != null && field.getActions() != null) {
            return this.getFieldActionService().processActions(session, field);
        }
        return field;
    }

    public AtlasModuleMode getMode() {
        return this.atlasModuleMode;
    }

    public void setMode(AtlasModuleMode atlasModuleMode) {
        this.atlasModuleMode = atlasModuleMode;
    }

    public Boolean isStatisticsSupported() {
        return false;
    }

    public Boolean isStatisticsEnabled() {
        return false;
    }

    public List<AtlasModuleMode> listSupportedModes() {
        return Arrays.asList(AtlasModuleMode.SOURCE, AtlasModuleMode.TARGET);
    }

    public AtlasConversionService getConversionService() {
        return this.atlasConversionService;
    }

    public AtlasCollectionHelper getCollectionHelper() {
        return this.collectionHelper;
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.uriDataType = AtlasUtil.getUriDataType(uri);
        this.uriParameters = AtlasUtil.getUriParameters(uri);
    }

    public String getUriDataType() {
        return this.uriDataType;
    }

    public Map<String, String> getUriParameters() {
        return Collections.unmodifiableMap(this.uriParameters);
    }

    public void setConversionService(AtlasConversionService atlasConversionService) {
        this.atlasConversionService = atlasConversionService;
    }

    public AtlasFieldActionService getFieldActionService() {
        return this.atlasFieldActionService;
    }

    public void setFieldActionService(AtlasFieldActionService atlasFieldActionService) {
        this.atlasFieldActionService = atlasFieldActionService;
        this.collectionHelper = new DefaultAtlasCollectionHelper(atlasFieldActionService);
    }

    public boolean isAutomaticallyProcessOutputFieldActions() {
        return this.automaticallyProcessOutputFieldActions;
    }

    public void setAutomaticallyProcessOutputFieldActions(boolean automaticallyProcessOutputFieldActions) {
        this.automaticallyProcessOutputFieldActions = automaticallyProcessOutputFieldActions;
    }

    public boolean isSourceSupported() {
        return Arrays.asList(this.getClass().getAnnotation(AtlasModuleDetail.class).modes()).contains("SOURCE");
    }

    public boolean isTargetSupported() {
        return Arrays.asList(this.getClass().getAnnotation(AtlasModuleDetail.class).modes()).contains("TARGET");
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String[] getDataFormats() {
        return this.getClass().getAnnotation(AtlasModuleDetail.class).dataFormats();
    }

    public String getModeName() {
        return this.atlasModuleMode.name();
    }

    public String getName() {
        return this.getClass().getAnnotation(AtlasModuleDetail.class).name();
    }

    public String[] getPackageNames() {
        return null;
    }

    public long getSourceErrorCount() {
        return 0L;
    }

    public long getSourceCount() {
        return 0L;
    }

    public long getSourceMaxExecutionTime() {
        return 0L;
    }

    public long getSourceMinExecutionTime() {
        return 0L;
    }

    public long getSourceSuccessCount() {
        return 0L;
    }

    public long getSourceTotalExecutionTime() {
        return 0L;
    }

    public long getTargetCount() {
        return 0L;
    }

    public long getTargetErrorCount() {
        return 0L;
    }

    public long getTargetMaxExecutionTime() {
        return 0L;
    }

    public long getTargetMinExecutionTime() {
        return 0L;
    }

    public long getTargetSuccessCount() {
        return 0L;
    }

    public long getTargetTotalExecutionTime() {
        return 0L;
    }

    public String getUuid() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public TabularData readAndResetStatistics() {
        return null;
    }

    public void setStatisticsEnabled(boolean enabled) {
        LOG.warn("Statistics is not yet implemented");
    }

    public Boolean isSupportedField(Field field) {
        return field instanceof SimpleField || field instanceof FieldGroup;
    }

    public void setDataSourceMetadata(DataSourceMetadata meta) {
        this.dataSourceMetadata = meta;
    }

    public DataSourceMetadata getDataSourceMetadata() {
        return this.dataSourceMetadata;
    }
}

