/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Mapping;
import java.util.HashMap;
import java.util.Map;

class DefaultAtlasPreviewSession
extends DefaultAtlasSession {
    private Mapping mapping;
    private Map<String, PreviewFieldReader> readers;

    DefaultAtlasPreviewSession(DefaultAtlasContext context, Mapping mapping) throws AtlasException {
        super(context);
        this.mapping = mapping;
        this.readers = new HashMap<String, PreviewFieldReader>();
    }

    @Override
    public AtlasFieldReader getFieldReader(String docId) {
        if (!this.readers.containsKey(docId)) {
            this.readers.put(docId, new PreviewFieldReader(this.mapping, docId));
        }
        return this.readers.get(docId);
    }

    @Override
    public <T extends AtlasFieldReader> T getFieldReader(String docId, Class<T> clazz) {
        AtlasFieldReader reader = this.getFieldReader(docId);
        if (clazz.isInstance(reader)) {
            return (T)((AtlasFieldReader)clazz.cast(reader));
        }
        throw new IllegalArgumentException(clazz.getName() + " is not available for preview");
    }

    private class PreviewFieldReader
    implements AtlasFieldReader {
        private Mapping mapping;
        private String docId;

        PreviewFieldReader(Mapping mapping, String docId) {
            this.mapping = mapping;
            this.docId = docId;
        }

        public Field read(AtlasInternalSession session) throws AtlasException {
            String path = session.head().getSourceField().getPath();
            FieldGroup sourceFieldGroup = this.mapping.getInputFieldGroup();
            if (sourceFieldGroup != null) {
                return this.readFromGroup(sourceFieldGroup, path);
            }
            for (Field f : this.mapping.getInputField()) {
                if (this.docId == null && f.getDocId() != null || this.docId != null && f.getDocId() == null || this.docId != null && !this.docId.equals(f.getDocId()) || f.getPath() == null || !f.getPath().equals(path)) continue;
                return f;
            }
            return null;
        }

        private Field readFromGroup(FieldGroup group, String path) {
            if (group.getField() == null) {
                return null;
            }
            for (Field f : group.getField()) {
                Field deeper;
                if (this.docId == null && f.getDocId() != null || this.docId != null && f.getDocId() == null || this.docId != null && !this.docId.equals(f.getDocId())) continue;
                if (f.getPath() != null && f.getPath().equals(path)) {
                    return f;
                }
                if (!(f instanceof FieldGroup) || (deeper = this.readFromGroup((FieldGroup)f, path)) == null) continue;
                return deeper;
            }
            return null;
        }
    }
}

