/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.ObjectFieldActions;
import io.atlasmap.v2.Contains;
import io.atlasmap.v2.Count;
import io.atlasmap.v2.Equals;
import io.atlasmap.v2.ItemAt;
import io.atlasmap.v2.Length;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ObjectFieldActionsTest {
    @Test
    public void testCount() {
        Assert.assertEquals((Object)new Integer(0), (Object)ObjectFieldActions.count((Count)new Count(), new ArrayList()));
        Object[] array = new Object[]{false, "foo", 2};
        Assert.assertEquals((Object)new Integer(3), (Object)ObjectFieldActions.count((Count)new Count(), Arrays.asList(array)));
    }

    @Test
    public void testContains() {
        Contains action = new Contains();
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Contains)action, null));
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList("")));
        Object[] array = new Object[]{false, "foo", 2};
        Object[] arrayWithNull = new Object[]{false, null, "foo", 2};
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList(array)));
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList(arrayWithNull)));
        action.setValue("foo");
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, null));
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList("")));
        Assert.assertFalse((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList("foobar")));
        Assert.assertTrue((boolean)ObjectFieldActions.contains((Contains)action, Arrays.asList(array)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContainsWithNullAction() {
        ObjectFieldActions.contains(null, Arrays.asList(""));
    }

    @Test
    public void testEquals() {
        Equals action = new Equals();
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Equals)action, null));
        action.setValue("6");
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Equals)action, (Object)169));
        action.setValue("169");
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Equals)action, (Object)169));
        action.setValue("ru");
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Equals)action, (Object)true));
        action.setValue("true");
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Equals)action, (Object)true));
        action.setValue("b");
        Assert.assertFalse((boolean)ObjectFieldActions.equals((Equals)action, (Object)Character.valueOf('a')));
        action.setValue("a");
        Assert.assertTrue((boolean)ObjectFieldActions.equals((Equals)action, (Object)Character.valueOf('a')));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEqualsWithNullAction() {
        ObjectFieldActions.equals(null, (Object)"");
    }

    @Test
    public void testIsNull() {
        Assert.assertTrue((boolean)ObjectFieldActions.isNull(null, null));
        Assert.assertFalse((boolean)ObjectFieldActions.isNull(null, (Object)""));
        Assert.assertFalse((boolean)ObjectFieldActions.isNull(null, (Object)new Object[0]));
    }

    @Test
    public void testItemAt() {
        ItemAt action = new ItemAt();
        action.setIndex(Integer.valueOf(0));
        Assert.assertEquals((Object)"one", (Object)ObjectFieldActions.itemAt((ItemAt)action, Arrays.asList("one", "two")));
        action.setIndex(Integer.valueOf(1));
        Assert.assertEquals((Object)"two", (Object)ObjectFieldActions.itemAt((ItemAt)action, Arrays.asList("one", "two")));
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testItemAtOutOfBounds() {
        ItemAt action = new ItemAt();
        action.setIndex(Integer.valueOf(2));
        ObjectFieldActions.itemAt((ItemAt)action, Arrays.asList("one", "two"));
    }

    @Test
    public void testLength() {
        Assert.assertEquals((Object)new Integer(-1), (Object)ObjectFieldActions.length((Length)new Length(), null));
        Assert.assertEquals((Object)new Integer(0), (Object)ObjectFieldActions.length((Length)new Length(), (Object)""));
        Assert.assertEquals((Object)new Integer(5), (Object)ObjectFieldActions.length((Length)new Length(), (Object)" foo "));
        Assert.assertEquals((Object)new Integer(4), (Object)ObjectFieldActions.length((Length)new Length(), (Object)true));
        Assert.assertEquals((Object)new Integer(3), (Object)ObjectFieldActions.length((Length)new Length(), (Object)169));
    }
}

