/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.StringComplexFieldActions;
import io.atlasmap.v2.Append;
import io.atlasmap.v2.Concatenate;
import io.atlasmap.v2.EndsWith;
import io.atlasmap.v2.Format;
import io.atlasmap.v2.GenerateUUID;
import io.atlasmap.v2.IndexOf;
import io.atlasmap.v2.LastIndexOf;
import io.atlasmap.v2.PadStringLeft;
import io.atlasmap.v2.PadStringRight;
import io.atlasmap.v2.Prepend;
import io.atlasmap.v2.ReplaceAll;
import io.atlasmap.v2.ReplaceFirst;
import io.atlasmap.v2.Split;
import io.atlasmap.v2.StartsWith;
import io.atlasmap.v2.SubString;
import io.atlasmap.v2.SubStringAfter;
import io.atlasmap.v2.SubStringBefore;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class StringComplexFieldActionsTest {
    @Test
    public void testAppend() {
        Append action = new Append();
        Assert.assertEquals(null, (Object)StringComplexFieldActions.append((Append)action, null));
        Assert.assertEquals((Object)"foo", (Object)StringComplexFieldActions.append((Append)action, (String)"foo"));
        Assert.assertEquals((Object)"1", (Object)StringComplexFieldActions.append((Append)action, (String)"1"));
        action.setString("");
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.append((Append)action, null));
        Assert.assertEquals((Object)"foo", (Object)StringComplexFieldActions.append((Append)action, (String)"foo"));
        action.setString("bar");
        Assert.assertEquals((Object)"bar", (Object)StringComplexFieldActions.append((Append)action, null));
        Assert.assertEquals((Object)"foobar", (Object)StringComplexFieldActions.append((Append)action, (String)"foo"));
        Assert.assertEquals((Object)"1bar", (Object)StringComplexFieldActions.append((Append)action, (String)"1"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAppendNullAction() {
        StringComplexFieldActions.append(null, null);
    }

    @Test
    public void testConcatenate() {
        Concatenate action = new Concatenate();
        Assert.assertEquals(null, (Object)StringComplexFieldActions.concatenate((Concatenate)action, null));
        Assert.assertEquals((Object)"1true2.0", (Object)StringComplexFieldActions.concatenate((Concatenate)action, Arrays.asList("1", "true", "2.0")));
        Assert.assertEquals((Object)"1true2.0", (Object)StringComplexFieldActions.concatenate((Concatenate)action, Arrays.asList("1", "true", "2.0")));
        action.setDelimiter("-");
        Assert.assertEquals(null, (Object)StringComplexFieldActions.concatenate((Concatenate)action, null));
        Assert.assertEquals((Object)"1-true-2.0", (Object)StringComplexFieldActions.concatenate((Concatenate)action, Arrays.asList("1", "true", "2.0")));
        Assert.assertEquals((Object)"1-true-2.0", (Object)StringComplexFieldActions.concatenate((Concatenate)action, Arrays.asList("1", "true", "2.0")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConcatenateNullAction() {
        StringComplexFieldActions.concatenate(null, null);
    }

    @Test
    public void testEndsWith() {
        EndsWith action = new EndsWith();
        action.setString("");
        Assert.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, null));
        Assert.assertTrue((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)""));
        Assert.assertTrue((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)"foo"));
        action.setString("bar");
        Assert.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, null));
        Assert.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)""));
        Assert.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)"foo"));
        Assert.assertTrue((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)"foobar"));
        Assert.assertFalse((boolean)StringComplexFieldActions.endsWith((EndsWith)action, (String)"barfoo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEndsWithNullAction() {
        StringComplexFieldActions.endsWith(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEndsWithNullString() {
        StringComplexFieldActions.endsWith((EndsWith)new EndsWith(), null);
    }

    @Test
    public void testFormat() {
        Format action = new Format();
        action.setTemplate("foofoo");
        Assert.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format((Format)action, null));
        Assert.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("")));
        Assert.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("bar")));
        action.setTemplate("foo%sfoo");
        Assert.assertEquals((Object)"foonullfoo", (Object)StringComplexFieldActions.format((Format)action, null));
        Assert.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("")));
        Assert.assertEquals((Object)"foobarfoo", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("bar")));
        action.setTemplate("foo%1$sfoo%1$s");
        Assert.assertEquals((Object)"foobarfoobar", (Object)StringComplexFieldActions.format((Format)action, Arrays.asList("bar")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatNullAction() {
        StringComplexFieldActions.format(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatNullTemplate() {
        StringComplexFieldActions.format((Format)new Format(), null);
    }

    @Test
    public void testGenareteUUID() {
        this.validateGeneratedUUID(StringComplexFieldActions.genareteUUID((GenerateUUID)new GenerateUUID()));
    }

    @Test
    public void testIndexOf() {
        IndexOf action = new IndexOf();
        action.setString("");
        Assert.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf((IndexOf)action, null));
        Assert.assertEquals((Object)0, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)""));
        Assert.assertEquals((Object)0, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)"foo"));
        action.setString("bar");
        Assert.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf((IndexOf)action, null));
        Assert.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)""));
        Assert.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)"foo"));
        Assert.assertEquals((Object)3, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)"foobar"));
        Assert.assertEquals((Object)3, (Object)StringComplexFieldActions.indexOf((IndexOf)action, (String)"foobarbar"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIndexOfNullAction() {
        StringComplexFieldActions.indexOf(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIndexOfNullString() {
        StringComplexFieldActions.indexOf((IndexOf)new IndexOf(), null);
    }

    @Test
    public void testLastIndexOf() {
        LastIndexOf action = new LastIndexOf();
        action.setString("");
        Assert.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, null));
        Assert.assertEquals((Object)0, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)""));
        Assert.assertEquals((Object)3, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)"foo"));
        action.setString("bar");
        Assert.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, null));
        Assert.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)""));
        Assert.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)"foo"));
        Assert.assertEquals((Object)3, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)"foobar"));
        Assert.assertEquals((Object)6, (Object)StringComplexFieldActions.lastIndexOf((LastIndexOf)action, (String)"foobarbar"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastIndexOfNullAction() {
        StringComplexFieldActions.lastIndexOf(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastIndexOfNullString() {
        StringComplexFieldActions.lastIndexOf((LastIndexOf)new LastIndexOf(), null);
    }

    @Test
    public void testPadStringLeft() {
        PadStringLeft incomplete;
        PadStringLeft padStringLeft = new PadStringLeft();
        padStringLeft.setPadCharacter("a");
        padStringLeft.setPadCount(Integer.valueOf(3));
        Assert.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringLeft((PadStringLeft)padStringLeft, null));
        Assert.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringLeft((PadStringLeft)padStringLeft, (String)""));
        Assert.assertEquals((Object)"aaaa", (Object)StringComplexFieldActions.padStringLeft((PadStringLeft)padStringLeft, (String)"a"));
        Assert.assertEquals((Object)"aaab", (Object)StringComplexFieldActions.padStringLeft((PadStringLeft)padStringLeft, (String)"b"));
        try {
            StringComplexFieldActions.padStringLeft(null, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            StringComplexFieldActions.padStringLeft((PadStringLeft)new PadStringLeft(), (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            incomplete = new PadStringLeft();
            incomplete.setPadCharacter("f");
            StringComplexFieldActions.padStringLeft((PadStringLeft)incomplete, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            incomplete = new PadStringLeft();
            incomplete.setPadCount(Integer.valueOf(3));
            StringComplexFieldActions.padStringLeft((PadStringLeft)incomplete, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testPadStringRight() {
        PadStringRight incomplete2;
        PadStringRight padStringRight = new PadStringRight();
        padStringRight.setPadCharacter("a");
        padStringRight.setPadCount(Integer.valueOf(3));
        Assert.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringRight((PadStringRight)padStringRight, null));
        Assert.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringRight((PadStringRight)padStringRight, (String)""));
        Assert.assertEquals((Object)"aaaa", (Object)StringComplexFieldActions.padStringRight((PadStringRight)padStringRight, (String)"a"));
        Assert.assertEquals((Object)"baaa", (Object)StringComplexFieldActions.padStringRight((PadStringRight)padStringRight, (String)"b"));
        try {
            StringComplexFieldActions.padStringRight(null, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringComplexFieldActions.padStringRight((PadStringRight)new PadStringRight(), (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            incomplete2 = new PadStringRight();
            incomplete2.setPadCharacter("f");
            StringComplexFieldActions.padStringRight((PadStringRight)incomplete2, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException incomplete2) {
            // empty catch block
        }
        try {
            incomplete2 = new PadStringRight();
            incomplete2.setPadCount(Integer.valueOf(3));
            StringComplexFieldActions.padStringRight((PadStringRight)incomplete2, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPrepend() {
        Prepend action = new Prepend();
        Assert.assertEquals(null, (Object)StringComplexFieldActions.prepend((Prepend)action, null));
        Assert.assertEquals((Object)"foo", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"foo"));
        Assert.assertEquals((Object)"1", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"1"));
        action.setString("");
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.prepend((Prepend)action, null));
        Assert.assertEquals((Object)"foo", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"foo"));
        action.setString("bar");
        Assert.assertEquals((Object)"bar", (Object)StringComplexFieldActions.prepend((Prepend)action, null));
        Assert.assertEquals((Object)"barfoo", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"foo"));
        Assert.assertEquals((Object)"bar1", (Object)StringComplexFieldActions.prepend((Prepend)action, (String)"1"));
    }

    @Test(expected=NullPointerException.class)
    public void testPrependNullAction() {
        StringComplexFieldActions.prepend(null, null);
    }

    @Test
    public void testReplaceFirst() {
        ReplaceFirst replaceFirst = new ReplaceFirst();
        replaceFirst.setMatch(" ");
        Assert.assertNull((Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, null));
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)""));
        Assert.assertEquals((Object)"test", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)"test"));
        replaceFirst.setMatch("e");
        Assert.assertEquals((Object)"tst", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)"test"));
        replaceFirst.setMatch("t");
        replaceFirst.setNewString("h");
        Assert.assertEquals((Object)"hest", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)"test"));
        replaceFirst.setMatch("is");
        replaceFirst.setNewString("at");
        Assert.assertEquals((Object)"That is a test", (Object)StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)"This is a test"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceFirstEmptyMatch() {
        ReplaceFirst replaceFirst = new ReplaceFirst();
        replaceFirst.setMatch("");
        StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)" ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceFirstNullAction() {
        StringComplexFieldActions.replaceFirst(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceFirstNullMatch() {
        ReplaceFirst replaceFirst = new ReplaceFirst();
        StringComplexFieldActions.replaceFirst((ReplaceFirst)replaceFirst, (String)" ");
    }

    @Test
    public void testReplaceAll() {
        ReplaceAll replaceAll = new ReplaceAll();
        replaceAll.setMatch(" ");
        Assert.assertNull((Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, null));
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)""));
        Assert.assertEquals((Object)"test", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)"test"));
        replaceAll.setMatch("e");
        Assert.assertEquals((Object)"tst", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)"test"));
        replaceAll.setMatch("t");
        replaceAll.setNewString("h");
        Assert.assertEquals((Object)"hesh", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)"test"));
        replaceAll.setMatch("is");
        replaceAll.setNewString("at");
        Assert.assertEquals((Object)"That at a test", (Object)StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)"This is a test"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceAllEmptyMatch() {
        ReplaceAll replaceAll = new ReplaceAll();
        replaceAll.setMatch("");
        StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)" ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceAllNullAction() {
        StringComplexFieldActions.replaceAll(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceAllNullOldString() {
        ReplaceAll replaceAll = new ReplaceAll();
        StringComplexFieldActions.replaceAll((ReplaceAll)replaceAll, (String)" ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSplitNoDelimiter() {
        Split action = new Split();
        StringComplexFieldActions.split((Split)action, (String)"foobar");
    }

    @Test
    public void testSplit() {
        Split action = new Split();
        action.setDelimiter(",");
        Assert.assertArrayEquals(null, (Object[])StringComplexFieldActions.split((Split)action, null));
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split((Split)action, (String)"1,2,3"));
    }

    @Test
    public void testStartsWith() {
        StartsWith action = new StartsWith();
        action.setString("");
        Assert.assertFalse((boolean)StringComplexFieldActions.startsWith((StartsWith)action, null));
        Assert.assertTrue((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)""));
        Assert.assertTrue((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)"foo"));
        action.setString("foo");
        Assert.assertFalse((boolean)StringComplexFieldActions.startsWith((StartsWith)action, null));
        Assert.assertFalse((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)""));
        Assert.assertTrue((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)"foo"));
        Assert.assertTrue((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)"foobar"));
        Assert.assertFalse((boolean)StringComplexFieldActions.startsWith((StartsWith)action, (String)"barfoo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStartsWithNullAction() {
        StringComplexFieldActions.startsWith(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStartsWithNullString() {
        StringComplexFieldActions.startsWith((StartsWith)new StartsWith(), null);
    }

    @Test
    public void testSubString() {
        SubString action = new SubString();
        action.setStartIndex(Integer.valueOf(2));
        action.setEndIndex(Integer.valueOf(4));
        Assert.assertNull((Object)StringComplexFieldActions.subString((SubString)action, null));
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.subString((SubString)action, (String)""));
        try {
            StringComplexFieldActions.subString(null, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSubStringAfter() {
        SubStringAfter err;
        SubStringAfter action = new SubStringAfter();
        action.setStartIndex(Integer.valueOf(3));
        action.setEndIndex(null);
        action.setMatch("foo");
        Assert.assertNull((Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, null));
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)""));
        Assert.assertEquals((Object)"blah", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"foobarblah"));
        Assert.assertEquals((Object)"blahfoo", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"foobarblahfoo"));
        Assert.assertEquals((Object)"barblah", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"barblah"));
        action.setEndIndex(Integer.valueOf(7));
        Assert.assertEquals((Object)"blah", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"foobarblahfoo"));
        action.setEndIndex(Integer.valueOf(3));
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringAfter((SubStringAfter)action, (String)"foobarblahfoo"));
        try {
            StringComplexFieldActions.subStringAfter(null, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            StringComplexFieldActions.subStringAfter((SubStringAfter)err, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            err.setEndIndex(Integer.valueOf(5));
            err.setStartIndex(Integer.valueOf(0));
            StringComplexFieldActions.subStringAfter((SubStringAfter)err, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            err.setEndIndex(Integer.valueOf(0));
            err.setStartIndex(Integer.valueOf(5));
            StringComplexFieldActions.subStringAfter((SubStringAfter)err, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSubStringBefore() {
        SubStringBefore err;
        SubStringBefore action = new SubStringBefore();
        action.setStartIndex(Integer.valueOf(3));
        action.setEndIndex(null);
        action.setMatch("blah");
        Assert.assertNull((Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, null));
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)""));
        Assert.assertEquals((Object)"bar", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"foobarblah"));
        Assert.assertEquals((Object)"foobar", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"foofoobarblahfoo"));
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"barblah"));
        action.setEndIndex(Integer.valueOf(5));
        Assert.assertEquals((Object)"ba", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"foobarblah"));
        action.setEndIndex(Integer.valueOf(3));
        Assert.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore((SubStringBefore)action, (String)"foobarblah"));
        try {
            StringComplexFieldActions.subStringBefore(null, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            StringComplexFieldActions.subStringBefore((SubStringBefore)err, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            err.setEndIndex(Integer.valueOf(5));
            err.setStartIndex(Integer.valueOf(0));
            StringComplexFieldActions.subStringBefore((SubStringBefore)err, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            err.setEndIndex(Integer.valueOf(0));
            err.setStartIndex(Integer.valueOf(5));
            StringComplexFieldActions.subStringBefore((SubStringBefore)err, (String)"aa");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    protected void validateCurrentDate(String dateValue) {
        Assert.assertNotNull((Object)dateValue);
        Assert.assertTrue((dateValue.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Pattern.compile("20([1-9][0-9])-(0[0-9]|1[0-2])-(0[0-9]|1[0-9]|2[0-9]|3[0-1])").matcher(dateValue).matches());
    }

    protected void validateCurrentDateTime(String dateTimeValue) {
        Assert.assertNotNull((Object)dateTimeValue);
        Assert.assertTrue((dateTimeValue.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Pattern.compile("20([1-9][0-9])-(0[0-9]|1[0-2])-(0[0-9]|1[0-9]|2[0-9]|3[0-1])T([01]?[0-9]|2[0-3]):[0-5][0-9]Z").matcher(dateTimeValue).matches());
    }

    protected void validateCurrentTime(String timeValue) {
        Assert.assertNotNull((Object)timeValue);
        Assert.assertTrue((timeValue.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Pattern.compile("([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]").matcher(timeValue).matches());
    }

    protected void validateGeneratedUUID(String uuid) {
        Assert.assertNotNull((Object)uuid);
        Assert.assertTrue((uuid.length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matcher(uuid).matches());
    }
}

