/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.PositiveIntegerValidator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PositiveIntegerValidatorTest
extends BaseValidatorTest {
    private PositiveIntegerValidator validator;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.validator = new PositiveIntegerValidator(ValidationScope.MAPPING, "Integer must be >= 0");
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupported() {
        Assert.assertTrue((boolean)this.validator.supports(Integer.class));
        Assert.assertTrue((boolean)this.validator.supports(String.class));
    }

    @Test
    public void testUnsupported() {
        Assert.assertFalse((boolean)this.validator.supports(Boolean.class));
    }

    @Test
    public void testValidate() {
        this.validator.validate((Object)0, this.validations, null);
        this.validator.validate((Object)1222, this.validations, null);
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateInvalid() {
        this.validator.validate((Object)-1, this.validations, "testValidateInvalid");
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(this.validationHelper.getCount()));
        Assert.assertEquals((Object)"testValidateInvalid", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
    }

    @Test
    public void testValidateInvalidWarn() {
        this.validator.validate((Object)-1, this.validations, "testValidateInvalidWarn", ValidationStatus.WARN);
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(this.validationHelper.getCount()));
        Assert.assertEquals((Object)"testValidateInvalidWarn", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
    }

    @Test
    public void testValidateInvalidInfo() {
        this.validator.validate((Object)-1, this.validations, "testValidateInvalidInfo", ValidationStatus.INFO);
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertTrue((boolean)this.validationHelper.hasInfos());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(this.validationHelper.getCount()));
        Assert.assertEquals((Object)"testValidateInvalidInfo", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
    }

    @Test
    public void testValidateWithErrorLevel() {
        this.validator.validate((Object)0, this.validations, "testValidateWithErrorLevel", ValidationStatus.WARN);
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }
}

