/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AbsoluteValue;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionDetail;
import io.atlasmap.v2.ActionParameter;
import io.atlasmap.v2.Add;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.GenerateUUID;
import io.atlasmap.v2.IndexOf;
import io.atlasmap.v2.Prepend;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.Uppercase;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultAtlasFieldActionsServiceTest {
    private DefaultAtlasFieldActionService fieldActionsService = null;

    @Before
    public void setUp() {
        this.fieldActionsService = DefaultAtlasFieldActionService.getInstance();
        this.fieldActionsService.init();
    }

    @After
    public void tearDown() {
        this.fieldActionsService = null;
    }

    @Test
    public void testInit() {
        Assert.assertNotNull((Object)this.fieldActionsService);
        Assert.assertNotNull((Object)this.fieldActionsService.listActionDetails());
        Assert.assertTrue((this.fieldActionsService.listActionDetails().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListActionDetails() {
        Assert.assertNotNull((Object)this.fieldActionsService);
        List actionDetails = this.fieldActionsService.listActionDetails();
        for (ActionDetail d : actionDetails) {
            if (d.getParameters() == null) continue;
            System.out.println("Action: " + d.getName());
            for (ActionParameter param : d.getParameters().getParameter()) {
                System.out.println("\t param: " + param.getName());
                System.out.println("\t type: " + param.getFieldType().value());
            }
        }
    }

    @Test
    public void testFindActionDetail() throws Exception {
        ActionDetail actionDetail = this.fieldActionsService.findActionDetail((Action)new Prepend(), FieldType.STRING);
        Assert.assertNotNull((Object)actionDetail);
        System.out.println(new ObjectMapper().writeValueAsString((Object)actionDetail.getActionSchema()));
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.STRING);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail(new Action(){}, FieldType.STRING);
        Assert.assertNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), null);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.STRING);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.ANY);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.NONE);
        Assert.assertNotNull((Object)actionDetail);
        actionDetail = this.fieldActionsService.findActionDetail((Action)new IndexOf(), FieldType.BOOLEAN);
        Assert.assertNotNull((Object)actionDetail);
    }

    @Test(expected=AtlasConversionException.class)
    public void testProcessActionsActionsFieldAtlasConversionException() throws AtlasException {
        SimpleField field = new SimpleField();
        Object value = new Object();
        field.setValue(value);
        field.setFieldType(FieldType.INTEGER);
        ArrayList<Add> actions = new ArrayList<Add>();
        actions.add(new Add());
        field.setActions(actions);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
    }

    @Test
    public void testProcessActionsActionsField() throws AtlasException {
        SimpleField field = new SimpleField();
        field.setFieldType(FieldType.COMPLEX);
        field.setActions(null);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setValue(null);
        field.setFieldType(FieldType.INTEGER);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setValue((Object)new Integer(0));
        field.setFieldType(FieldType.INTEGER);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setActions(new ArrayList());
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setActions(new ArrayList());
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.getActions().add(new Trim());
        field.setValue((Object)"testString");
        field.setFieldType(FieldType.STRING);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
        field.setValue((Object)new Integer(8));
        field.setFieldType(FieldType.NUMBER);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
    }

    @Test(expected=AtlasConversionException.class)
    public void testprocessActionsActionsObjectFieldTypeAtlasConversionException() throws AtlasException {
        SimpleField field = new SimpleField();
        Object value = new Object();
        field.setValue(value);
        field.setFieldType(FieldType.INTEGER);
        ArrayList<Add> actions = new ArrayList<Add>();
        actions.add(new Add());
        field.setActions(actions);
        this.fieldActionsService.processActions((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class), (Field)field);
    }

    @Test
    public void testProcessActionWithActionActionDetailObject() throws AtlasException {
        DefaultAtlasFieldActionService.ActionProcessor processor = null;
        String sourceObject = "String";
        Trim action = new Trim();
        processor = this.fieldActionsService.findActionProcessor((Action)action, FieldType.STRING);
        Assert.assertEquals((Object)sourceObject, (Object)processor.process((Action)action, (Object)sourceObject));
        action = new GenerateUUID();
        processor = this.fieldActionsService.findActionProcessor((Action)action, FieldType.NONE);
        Assert.assertNotNull((Object)processor.process((Action)action, (Object)sourceObject));
    }

    @Test
    public void testProcessActionWithActionActionDetailObjectAssignableType() throws AtlasException {
        AbsoluteValue action = new AbsoluteValue();
        Integer sourceObject = new Integer("1");
        DefaultAtlasFieldActionService.ActionProcessor processor = this.fieldActionsService.findActionProcessor((Action)action, FieldType.STRING);
        Assert.assertEquals((Object)1L, (Object)processor.process((Action)action, (Object)sourceObject));
    }

    @Test
    public void testGetActionDetailByActionName() {
        Assert.assertNotNull((Object)this.fieldActionsService.getActionDetailByActionName("Add"));
        Assert.assertNull((Object)this.fieldActionsService.getActionDetailByActionName("AtlasAdd"));
    }

    @Test
    public void testProcessActionForEachCollectionItem() throws Exception {
        DefaultAtlasSession session = (DefaultAtlasSession)Mockito.mock(DefaultAtlasSession.class);
        FieldGroup fieldGroup = new FieldGroup();
        SimpleField field1 = new SimpleField();
        field1.setValue((Object)"one");
        fieldGroup.getField().add(field1);
        SimpleField field2 = new SimpleField();
        field2.setValue((Object)"two");
        fieldGroup.getField().add(field2);
        SimpleField field3 = new SimpleField();
        field3.setValue((Object)"three");
        fieldGroup.getField().add(field3);
        Uppercase action = new Uppercase();
        fieldGroup.setActions(new ArrayList());
        fieldGroup.getActions().add(action);
        Field answer = this.fieldActionsService.processActions((AtlasInternalSession)session, (Field)fieldGroup);
        Assert.assertEquals(FieldGroup.class, answer.getClass());
        FieldGroup answerGroup = (FieldGroup)answer;
        Assert.assertEquals((Object)"ONE", (Object)((Field)answerGroup.getField().get(0)).getValue());
        Assert.assertEquals((Object)"TWO", (Object)((Field)answerGroup.getField().get(1)).getValue());
        Assert.assertEquals((Object)"THREE", (Object)((Field)answerGroup.getField().get(2)).getValue());
    }
}

